/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.biolab;

import com.github.elenterius.biomancy.block.base.MachineBlock;
import com.github.elenterius.biomancy.block.base.MachineBlockEntity;
import com.github.elenterius.biomancy.block.biolab.BioLabStateData;
import com.github.elenterius.biomancy.client.util.ClientLoopingSoundHelper;
import com.github.elenterius.biomancy.crafting.recipe.BioLabRecipe;
import com.github.elenterius.biomancy.crafting.recipe.IngredientStack;
import com.github.elenterius.biomancy.crafting.recipe.SimpleRecipeType;
import com.github.elenterius.biomancy.init.ModBlockEntities;
import com.github.elenterius.biomancy.init.ModCapabilities;
import com.github.elenterius.biomancy.init.ModRecipes;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import com.github.elenterius.biomancy.inventory.BehavioralInventory;
import com.github.elenterius.biomancy.inventory.SimpleInventory;
import com.github.elenterius.biomancy.inventory.itemhandler.HandlerBehaviors;
import com.github.elenterius.biomancy.menu.BioLabMenu;
import com.github.elenterius.biomancy.styles.TextComponentUtil;
import com.github.elenterius.biomancy.util.ILoopingSoundHelper;
import com.github.elenterius.biomancy.util.SoundUtil;
import com.github.elenterius.biomancy.util.fuel.FluidFuelConsumerHandler;
import com.github.elenterius.biomancy.util.fuel.FuelHandler;
import com.github.elenterius.biomancy.util.fuel.IFuelHandler;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.RangedWrapper;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BioLabBlockEntity
extends MachineBlockEntity<BioLabRecipe, Container, BioLabStateData>
implements MenuProvider,
GeoBlockEntity {
    public static final int FUEL_SLOTS = 1;
    public static final int INPUT_SLOTS = 5;
    public static final int OUTPUT_SLOTS = 1;
    public static final int MAX_FUEL = 1000;
    public static final RegistryObject<SimpleRecipeType.ItemStackRecipeType<BioLabRecipe>> RECIPE_TYPE = ModRecipes.BIO_BREWING_RECIPE_TYPE;
    protected static final RawAnimation WORKING_ANIM = RawAnimation.begin().thenLoop("bio_lab.working");
    protected static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("bio_lab.idle");
    private final BioLabStateData stateData;
    private final FuelHandler fuelHandler;
    private final BehavioralInventory<?> fuelInventory;
    private final SimpleInventory inputInventory;
    private final BehavioralInventory<?> outputInventory;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private ILoopingSoundHelper loopingSoundHelper = ILoopingSoundHelper.NULL;
    private LazyOptional<IItemHandler> optionalCombinedInventory;
    private LazyOptional<IFluidHandler> optionalFluidConsumer;

    public BioLabBlockEntity(BlockPos worldPosition, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.BIO_LAB.get(), worldPosition, blockState);
        this.inputInventory = SimpleInventory.createServerContents(5, this::canPlayerOpenInv, () -> ((BioLabBlockEntity)this).m_6596_());
        this.outputInventory = BehavioralInventory.createServerContents(1, x$0 -> (IItemHandlerModifiable)HandlerBehaviors.denyInput((IItemHandler)x$0), this::canPlayerOpenInv, () -> ((BioLabBlockEntity)this).m_6596_());
        this.fuelInventory = BehavioralInventory.createServerContents(1, x$0 -> (IItemHandlerModifiable)HandlerBehaviors.filterFuel((IItemHandler)x$0), this::canPlayerOpenInv, () -> ((BioLabBlockEntity)this).m_6596_());
        this.optionalCombinedInventory = this.createCombinedInventory();
        this.fuelHandler = FuelHandler.createNutrientFuelHandler(1000, () -> ((BioLabBlockEntity)this).m_6596_());
        this.stateData = new BioLabStateData(this.fuelHandler);
        this.optionalFluidConsumer = LazyOptional.of(() -> new FluidFuelConsumerHandler(this.fuelHandler));
    }

    private LazyOptional<IItemHandler> createCombinedInventory() {
        return LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{(IItemHandlerModifiable)this.fuelInventory.getItemHandlerWithBehavior(), new RangedWrapper((IItemHandlerModifiable)this.inputInventory.getItemHandler(), this.inputInventory.m_6643_() - 1, this.inputInventory.m_6643_())}));
    }

    public void onLoad() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.loopingSoundHelper = new ClientLoopingSoundHelper();
        }
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    public Component m_7755_() {
        return TextComponentUtil.getTranslationText("container", "bio_lab");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        return BioLabMenu.createServerMenu(containerId, playerInventory, this.fuelInventory, this.inputInventory, this.outputInventory, this.stateData);
    }

    @Override
    protected BioLabStateData getStateData() {
        return this.stateData;
    }

    @Override
    protected Container getInputInventory() {
        return this.inputInventory;
    }

    @Override
    protected IFuelHandler getFuelHandler() {
        return this.fuelHandler;
    }

    @Override
    public ItemStack getStackInFuelSlot() {
        return this.fuelInventory.m_8020_(0);
    }

    @Override
    public void setStackInFuelSlot(ItemStack stack) {
        this.fuelInventory.m_6836_(0, stack);
    }

    @Override
    protected boolean doesRecipeResultFitIntoOutputInv(BioLabRecipe craftingGoal, ItemStack stackToCraft) {
        return this.outputInventory.m_8020_(0).m_41619_() || this.outputInventory.doesItemStackFit(0, stackToCraft);
    }

    @Override
    @Nullable
    protected BioLabRecipe resolveRecipeFromInput(Level level) {
        return ((SimpleRecipeType.ItemStackRecipeType)RECIPE_TYPE.get()).getRecipeFromContainer(level, this.inputInventory).orElse(null);
    }

    @Override
    protected boolean doesRecipeMatchInput(BioLabRecipe recipeToTest, Level level) {
        return recipeToTest.m_5818_(this.inputInventory, level);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.stateData.serialize(tag);
        tag.m_128365_("Fuel", (Tag)this.fuelHandler.serializeNBT());
        tag.m_128365_("FuelSlots", (Tag)this.fuelInventory.serializeNBT());
        tag.m_128365_("InputSlots", (Tag)this.inputInventory.serializeNBT());
        tag.m_128365_("OutputSlots", (Tag)this.outputInventory.serializeNBT());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.stateData.deserialize(tag);
        this.fuelHandler.deserializeNBT(tag.m_128469_("Fuel"));
        this.fuelInventory.deserializeNBT(tag.m_128469_("FuelSlots"));
        this.inputInventory.deserializeNBT(tag.m_128469_("InputSlots"));
        this.outputInventory.deserializeNBT(tag.m_128469_("OutputSlots"));
    }

    @Override
    public void dropAllInvContents(Level level, BlockPos pos) {
        Containers.m_19002_((Level)level, (BlockPos)pos, this.fuelInventory);
        Containers.m_19002_((Level)level, (BlockPos)pos, (Container)this.inputInventory);
        Containers.m_19002_((Level)level, (BlockPos)pos, this.outputInventory);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (this.f_58859_) {
            return super.getCapability(cap, side);
        }
        if (cap == ModCapabilities.ITEM_HANDLER) {
            if (side == null || side == Direction.DOWN) {
                return this.outputInventory.getOptionalItemHandler().cast();
            }
            if (side == Direction.UP) {
                return this.inputInventory.getOptionalItemHandler().cast();
            }
            return this.optionalCombinedInventory.cast();
        }
        if (cap == ModCapabilities.FLUID_HANDLER) {
            return this.optionalFluidConsumer.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.fuelInventory.invalidate();
        this.inputInventory.invalidate();
        this.outputInventory.invalidate();
        this.optionalCombinedInventory.invalidate();
        this.optionalFluidConsumer.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.fuelInventory.revive();
        this.inputInventory.revive();
        this.outputInventory.revive();
        this.optionalCombinedInventory = this.createCombinedInventory();
        this.optionalFluidConsumer = LazyOptional.of(() -> new FluidFuelConsumerHandler(this.fuelHandler));
    }

    @Override
    protected boolean craftRecipe(BioLabRecipe recipeToCraft, Level level) {
        ItemStack result = recipeToCraft.m_8043_(level.m_9598_()).m_41777_();
        if (result.m_41619_() || !this.doesRecipeResultFitIntoOutputInv(recipeToCraft, result)) {
            return false;
        }
        List<IngredientStack> ingredients = recipeToCraft.getIngredientQuantities();
        int[] ingredientCost = new int[ingredients.size()];
        for (int i = 0; i < ingredients.size(); ++i) {
            ingredientCost[i] = ingredients.get(i).count();
        }
        int lastIndex = this.inputInventory.m_6643_() - 1;
        this.inputInventory.m_7407_(lastIndex, 1);
        block1: for (int idx = 0; idx < lastIndex; ++idx) {
            ItemStack foundStack = this.inputInventory.m_8020_(idx);
            if (foundStack.m_41619_()) continue;
            for (int i = 0; i < ingredients.size(); ++i) {
                int remainingCost = ingredientCost[i];
                if (remainingCost <= 0 || !ingredients.get(i).testItem(foundStack)) continue;
                int amount = Math.min(remainingCost, foundStack.m_41613_());
                this.inputInventory.m_7407_(idx, amount);
                int n = i;
                ingredientCost[n] = ingredientCost[n] - amount;
                continue block1;
            }
        }
        this.outputInventory.insertItemStack(0, result);
        SoundUtil.broadcastBlockSound((ServerLevel)level, this.m_58899_(), ModSoundEvents.BIO_LAB_CRAFTING_COMPLETED);
        this.m_6596_();
        return true;
    }

    private <T extends BioLabBlockEntity> PlayState handleAnimationState(AnimationState<T> event) {
        boolean isCrafting = Boolean.TRUE.equals(this.m_58900_().m_61143_((Property)MachineBlock.CRAFTING));
        if (isCrafting) {
            event.getController().setAnimation(WORKING_ANIM);
            this.loopingSoundHelper.startLoop(this, (SoundEvent)ModSoundEvents.BIO_LAB_CRAFTING.get(), 0.65f);
        } else {
            event.getController().setAnimation(IDLE_ANIM);
            this.loopingSoundHelper.stopLoop();
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "main", 0, this::handleAnimationState)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_7651_() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.loopingSoundHelper.clear();
        }
        super.m_7651_();
    }
}

