/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.bloom;

import com.github.elenterius.biomancy.block.bloom.BloomBlock;
import com.github.elenterius.biomancy.util.IntermediaryKeyCache;
import com.github.elenterius.biomancy.util.VoxelShapeUtil;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class BloomShapes {
    static final IntermediaryKeyCache<BlockState, ComputedShapes> CACHE = new IntermediaryKeyCache(BloomShapes::computeKey);

    private BloomShapes() {
    }

    static void computePossibleShapes(List<BlockState> possibleStates) {
        possibleStates.forEach(possibleState -> CACHE.computeIfAbsent((BlockState)possibleState, BloomShapes::computeShapes));
    }

    static VoxelShape getBoundingShape(BlockState blockState) {
        return CACHE.get(blockState).boundingShape();
    }

    static VoxelShape getCollisionShape(BlockState blockState) {
        return CACHE.get(blockState).collisionShape();
    }

    private static Integer computeKey(BlockState blockState) {
        Direction direction = BloomBlock.getFacing(blockState);
        int stage = BloomBlock.getStage(blockState);
        return Objects.hash(direction, stage);
    }

    private static ComputedShapes computeShapes(BlockState blockState) {
        Direction direction = BloomBlock.getFacing(blockState);
        int stage = BloomBlock.getStage(blockState);
        if (stage == 0) {
            VoxelShape boundingShape = VoxelShapeUtil.createXZRotatedTowards(direction, 5.0, 0.0, 5.0, 11.0, 6.0, 11.0);
            VoxelShape collisionShape = VoxelShapeUtil.createXZRotatedTowards(direction, 5.0, 0.0, 5.0, 11.0, 2.0, 11.0);
            return new ComputedShapes(boundingShape, collisionShape);
        }
        VoxelShape shape = switch (stage) {
            case 1 -> Shapes.m_83113_((VoxelShape)VoxelShapeUtil.createXZRotatedTowards(direction, 5.0, 0.0, 5.0, 11.0, 2.0, 11.0), (VoxelShape)VoxelShapeUtil.createXZRotatedTowards(direction, 4.0, 2.0, 4.0, 12.0, 10.0, 12.0), (BooleanOp)BooleanOp.f_82695_);
            case 2 -> Shapes.m_83113_((VoxelShape)VoxelShapeUtil.createXZRotatedTowards(direction, 5.0, 0.0, 5.0, 11.0, 2.0, 11.0), (VoxelShape)VoxelShapeUtil.createXZRotatedTowards(direction, 2.0, 2.0, 2.0, 14.0, 15.0, 14.0), (BooleanOp)BooleanOp.f_82695_);
            case 3, 4 -> Shapes.m_83144_();
            default -> Shapes.m_83040_();
        };
        return new ComputedShapes(shape, shape);
    }

    protected record ComputedShapes(VoxelShape boundingShape, VoxelShape collisionShape) {
    }
}

