/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.chrysalis;

import com.github.elenterius.biomancy.entity.mob.fleshblob.FleshBlob;
import com.github.elenterius.biomancy.util.MobUtil;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public interface Chrysalis {
    public static final String ENTITY_KEY = "entity_info";
    public static final String ENTITY_NAME_KEY = "name";
    public static final String ENTITY_DATA_KEY = "data";
    public static final String ENTITY_VOLUME_KEY = "volume";

    public static boolean isValidEntity(Entity entity) {
        if (entity instanceof Player) {
            return false;
        }
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity living = (LivingEntity)entity;
        boolean valid = entity.m_6084_() && entity.m_6072_() && entity.m_6095_().m_20654_() && entity.m_6095_().m_20584_();
        return valid && (living instanceof FleshBlob || living.m_6162_());
    }

    public static boolean storeEntity(CompoundTag tag, Entity entity, boolean removeEntity) {
        if (removeEntity && entity.m_20159_()) {
            entity.m_6038_();
            if (entity.m_20159_()) {
                return false;
            }
        }
        List cachedPassengers = null;
        if (entity.m_20160_()) {
            cachedPassengers = entity.m_20197_();
            entity.m_20153_();
        }
        if (Chrysalis.saveEntity(tag, entity)) {
            if (removeEntity) {
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
            } else if (cachedPassengers != null) {
                cachedPassengers.forEach(passenger -> passenger.m_20329_(entity));
            }
            return true;
        }
        return false;
    }

    public static boolean saveEntity(CompoundTag compoundTag, Entity entity) {
        CompoundTag entityData = new CompoundTag();
        if (entity.m_20086_(entityData)) {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_(ENTITY_DATA_KEY, (Tag)entityData);
            tag.m_128359_(ENTITY_NAME_KEY, entity.m_6095_().m_20675_());
            EntityDimensions dimensions = entity.m_6972_(entity.m_20089_());
            float volume = dimensions.f_20377_ * dimensions.f_20378_ * dimensions.f_20377_;
            tag.m_128350_(ENTITY_VOLUME_KEY, volume);
            compoundTag.m_128365_(ENTITY_KEY, (Tag)tag);
            return true;
        }
        return false;
    }

    public static boolean spawnEntity(ServerLevel level, Vec3 pos, CompoundTag entityTag) {
        Entity entityToSpawn = EntityType.m_20645_((CompoundTag)entityTag.m_128469_(ENTITY_DATA_KEY), (Level)level, entity -> {
            entity.m_7678_(pos.f_82479_, pos.f_82480_, pos.f_82481_, Mth.m_14177_((float)(level.f_46441_.m_188501_() * 360.0f)), 0.0f);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.f_20885_ = living.m_146908_();
                living.f_20883_ = living.m_146908_();
            }
            entity.m_20334_(0.0, 0.0, 0.0);
            entity.f_19789_ = 0.0f;
            return entity;
        });
        if (entityToSpawn != null) {
            if (!MobUtil.isEntityIdUnique(level, entityToSpawn)) {
                MobUtil.randomizeUUID(entityToSpawn);
            }
            return level.m_7967_(entityToSpawn);
        }
        return false;
    }
}

