/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.chrysalis;

import com.github.elenterius.biomancy.block.base.WaterloggedFacingEntityBlock;
import com.github.elenterius.biomancy.block.chrysalis.ChrysalisBlockEntity;
import com.github.elenterius.biomancy.util.VoxelShapeUtil;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ChrysalisBlock
extends WaterloggedFacingEntityBlock {
    public static final VoxelShape SHAPE_UP = ChrysalisBlock.createShape(Direction.UP);
    public static final VoxelShape SHAPE_DOWN = ChrysalisBlock.createShape(Direction.DOWN);
    public static final VoxelShape SHAPE_NORTH = ChrysalisBlock.createShape(Direction.NORTH);
    public static final VoxelShape SHAPE_SOUTH = ChrysalisBlock.createShape(Direction.SOUTH);
    public static final VoxelShape SHAPE_WEST = ChrysalisBlock.createShape(Direction.WEST);
    public static final VoxelShape SHAPE_EAST = ChrysalisBlock.createShape(Direction.EAST);

    public ChrysalisBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    private static VoxelShape createShape(Direction direction) {
        return Stream.of(VoxelShapeUtil.createXZRotatedTowards(direction, 4.0, 9.0, 4.0, 12.0, 13.0, 12.0), VoxelShapeUtil.createXZRotatedTowards(direction, 3.5, 0.0, 3.5, 12.5, 1.0, 12.5), VoxelShapeUtil.createXZRotatedTowards(direction, 3.0, 1.0, 3.0, 13.0, 9.0, 13.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).orElse(Shapes.m_83040_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ChrysalisBlockEntity(pos, state);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ChrysalisBlockEntity) {
            ChrysalisBlockEntity blockEntity2 = (ChrysalisBlockEntity)blockEntity;
            if (stack.m_41788_()) {
                blockEntity2.setCustomName(stack.m_41786_());
            }
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        ChrysalisBlockEntity chrysalis;
        BlockEntity blockEntity;
        if (level.f_46443_) {
            super.m_5707_(level, pos, state, player);
            return;
        }
        if (player.m_7500_() && (blockEntity = level.m_7702_(pos)) instanceof ChrysalisBlockEntity && !(chrysalis = (ChrysalisBlockEntity)blockEntity).isEmpty()) {
            ItemStack stack = new ItemStack((ItemLike)this);
            chrysalis.m_187476_(stack);
            if (chrysalis.m_8077_()) {
                stack.m_41714_(chrysalis.m_7770_());
            }
            ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack);
            itemEntity.m_32060_();
            level.m_7967_((Entity)itemEntity);
        }
        super.m_5707_(level, pos, state, player);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch (ChrysalisBlock.getFacing(state)) {
            case Direction.DOWN -> SHAPE_DOWN;
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            default -> SHAPE_UP;
        };
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }
}

