/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.cradle;

import com.github.elenterius.biomancy.block.cradle.PrimordialCradleBlockEntity;
import com.github.elenterius.biomancy.client.util.ClientTextUtil;
import com.github.elenterius.biomancy.init.ModBlockEntities;
import com.github.elenterius.biomancy.init.ModCapabilities;
import com.github.elenterius.biomancy.init.ModItems;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import com.github.elenterius.biomancy.init.ModTriggers;
import com.github.elenterius.biomancy.init.tags.ModItemTags;
import com.github.elenterius.biomancy.integration.ModsCompatHandler;
import com.github.elenterius.biomancy.styles.TextStyles;
import com.github.elenterius.biomancy.util.ComponentUtil;
import com.github.elenterius.biomancy.util.SoundUtil;
import com.github.elenterius.biomancy.world.mound.MoundShape;
import com.github.elenterius.biomancy.world.spatial.SpatialShapeManager;
import java.text.DecimalFormat;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class PrimordialCradleBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final Predicate<ItemStack> CANNOT_BE_SACRIFICED = stack -> {
        BlockItem blockItem;
        Block block;
        if (stack.m_204117_(ModItemTags.CANNOT_BE_EATEN_BY_CRADLE)) {
            return true;
        }
        Item item = stack.m_41720_();
        if (item instanceof TieredItem || item instanceof Vanishable) {
            return true;
        }
        if (item instanceof BlockItem && (block = (blockItem = (BlockItem)item).m_40614_()) instanceof EntityBlock) {
            return true;
        }
        if (ModsCompatHandler.getTetraHelper().isToolOrModularItem(item)) {
            return true;
        }
        if (stack.m_41793_()) {
            return true;
        }
        if (!item.m_142095_()) {
            return true;
        }
        return stack.getCapability(ModCapabilities.ITEM_HANDLER).isPresent();
    };
    protected static final VoxelShape INSIDE_AABB = PrimordialCradleBlock.m_49796_((double)3.0, (double)4.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    protected static final VoxelShape OUTSIDE_AABB = Stream.of(PrimordialCradleBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)5.0, (double)15.0), PrimordialCradleBlock.m_49796_((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), PrimordialCradleBlock.m_49796_((double)1.0, (double)12.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape AABB = Shapes.m_83113_((VoxelShape)OUTSIDE_AABB, (VoxelShape)INSIDE_AABB, (BooleanOp)BooleanOp.f_82685_);

    public PrimordialCradleBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public static float getYRotation(BlockState state) {
        return ((Direction)state.m_61143_((Property)f_54117_)).m_122435_();
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> blockEntityType, BlockEntityType<E> targetType, BlockEntityTicker<? super E> entityTicker) {
        return targetType == blockEntityType ? entityTicker : null;
    }

    public static int getPrimalEnergy(CompoundTag tag) {
        return tag.m_128441_("PrimalEnergy") ? tag.m_128451_("PrimalEnergy") : 0;
    }

    public static MutableComponent createValueComponent(DecimalFormat df, int value, String name) {
        return ComponentUtil.literal(df.format(value)).m_130948_(TextStyles.PRIMORDIAL_RUNES_LIGHT_GRAY).m_7220_(ComponentUtil.space()).m_7220_((Component)ComponentUtil.literal(name).m_130948_(TextStyles.GRAY));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModBlockEntities.PRIMORDIAL_CRADLE.get()).m_155264_(pos, state);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                SpatialShapeManager.remove(serverLevel, pos);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : PrimordialCradleBlock.createTickerHelper(blockEntityType, (BlockEntityType)ModBlockEntities.PRIMORDIAL_CRADLE.get(), PrimordialCradleBlockEntity::serverTick);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (this.increaseFillLevel((Entity)player, level, pos, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1))) {
            if (!level.f_46443_) {
                boolean isPotion = stack.m_41720_() instanceof PotionItem;
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                if (stack.hasCraftingRemainingItem()) {
                    player.m_150109_().m_36054_(stack.getCraftingRemainingItem());
                } else if (isPotion && stack.m_41619_()) {
                    player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42590_));
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (!level.f_46443_) {
            SoundUtil.broadcastBlockSound((ServerLevel)level, pos, ModSoundEvents.CRADLE_NO);
        }
        return InteractionResult.CONSUME;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!level.m_5776_() && entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            ItemStack stack = itemEntity.m_32055_();
            Entity thrower = itemEntity.m_19749_();
            if (stack.m_150930_((Item)ModItems.LIVING_FLESH.get()) && thrower == null && itemEntity.m_32059_() < 80) {
                return;
            }
            if (this.increaseFillLevel(thrower, level, pos, stack)) {
                if (stack.hasCraftingRemainingItem()) {
                    entity.m_19983_(stack.getCraftingRemainingItem());
                } else if (stack.m_41720_() instanceof PotionItem) {
                    entity.m_19983_(new ItemStack((ItemLike)Items.f_42590_));
                }
            }
        }
    }

    private boolean increaseFillLevel(@Nullable Entity player, Level level, BlockPos pos, ItemStack stack) {
        PrimordialCradleBlockEntity cradle;
        if (level.m_5776_()) {
            return false;
        }
        if (stack.m_41619_()) {
            return false;
        }
        if (CANNOT_BE_SACRIFICED.test(stack)) {
            return false;
        }
        ItemStack copyOfStack = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PrimordialCradleBlockEntity && !(cradle = (PrimordialCradleBlockEntity)blockEntity).isFull() && cradle.insertItem(stack)) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ModTriggers.SACRIFICED_ITEM_TRIGGER.trigger(serverPlayer, copyOfStack);
            }
            SoundEvent soundEvent = cradle.isFull() ? (SoundEvent)ModSoundEvents.CRADLE_BECAME_FULL.get() : (SoundEvent)ModSoundEvents.CRADLE_EAT.get();
            SoundUtil.broadcastBlockSound((ServerLevel)level, pos, soundEvent);
            return true;
        }
        return false;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        PrimordialCradleBlockEntity creator;
        BlockEntity blockEntity;
        if (random.m_188503_(4) == 0 && (blockEntity = level.m_7702_(pos)) instanceof PrimordialCradleBlockEntity && (creator = (PrimordialCradleBlockEntity)blockEntity).isFull()) {
            int particleAmount = random.m_216339_(2, 8);
            int color = 10438006;
            double r = (double)(color >> 16 & 0xFF) / 255.0;
            double g = (double)(color >> 8 & 0xFF) / 255.0;
            double b = (double)(color & 0xFF) / 255.0;
            for (int i = 0; i < particleAmount; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123811_, (double)pos.m_123341_() + ((double)random.m_188501_() * 0.60625 + (double)0.13125f), (double)((float)pos.m_123342_() + 0.5f), (double)pos.m_123343_() + ((double)random.m_188501_() * 0.60625 + (double)0.13125f), r, g, b);
            }
            if (random.m_188503_(3) == 0) {
                SoundUtil.clientPlayBlockSound(level, pos, ModSoundEvents.CRADLE_CRAFTING_RANDOM, 0.85f);
            }
        }
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag tag = BlockItem.m_186336_((ItemStack)stack);
        if (tag == null) {
            return;
        }
        DecimalFormat df = ClientTextUtil.getDecimalFormatter("#,###,###");
        int primalEnergy = PrimordialCradleBlock.getPrimalEnergy(tag);
        boolean hasPrimalEnergy = primalEnergy > 0;
        boolean hasTributes = tag.m_128441_("SacrificeHandler");
        boolean hasProcGenValues = tag.m_128441_("ProcGenValues");
        if (hasProcGenValues) {
            tooltip.add(ComponentUtil.emptyLine());
            tooltip.add((Component)ComponentUtil.literal("Seeded with:").m_130948_(TextStyles.PRIMORDIAL_RUNES_MUTED_PURPLE));
            MoundShape.ProcGenValues procGenValues = MoundShape.ProcGenValues.readFrom(tag.m_128469_("ProcGenValues"));
            tooltip.add((Component)ComponentUtil.literal(df.format(procGenValues.biomeTemperature())).m_130948_(TextStyles.PRIMORDIAL_RUNES_PURPLE).m_7220_((Component)ComponentUtil.literal(" Temperature").m_130948_(TextStyles.PRIMORDIAL_RUNES_MUTED_PURPLE)));
            tooltip.add((Component)ComponentUtil.literal(df.format(procGenValues.biomeHumidity())).m_130948_(TextStyles.PRIMORDIAL_RUNES_PURPLE).m_7220_((Component)ComponentUtil.literal(" Humidity").m_130948_(TextStyles.PRIMORDIAL_RUNES_MUTED_PURPLE)));
            if (!hasPrimalEnergy) {
                tooltip.add(ComponentUtil.emptyLine());
            }
        }
        if (hasPrimalEnergy) {
            tooltip.add(ComponentUtil.emptyLine());
            tooltip.add((Component)ComponentUtil.literal(df.format(primalEnergy)).m_130948_(TextStyles.PRIMORDIAL_RUNES_PURPLE).m_7220_((Component)ComponentUtil.literal(" Primal Energy").m_130948_(TextStyles.PRIMORDIAL_RUNES_MUTED_PURPLE)));
            if (!hasTributes) {
                tooltip.add(ComponentUtil.emptyLine());
            }
        }
        if (hasTributes) {
            tooltip.add(ComponentUtil.emptyLine());
            CompoundTag sacrificeTag = tag.m_128469_("SacrificeHandler");
            byte biomass = sacrificeTag.m_128445_("Biomass");
            int lifeEnergy = sacrificeTag.m_128451_("LifeEnergy");
            int success = sacrificeTag.m_128451_("Success");
            int disease = sacrificeTag.m_128451_("Disease");
            int hostile = sacrificeTag.m_128451_("Hostile");
            int anomaly = sacrificeTag.m_128451_("Anomaly");
            if (biomass > 0) {
                tooltip.add((Component)PrimordialCradleBlock.createValueComponent(df, biomass, "Biomass"));
            }
            if (lifeEnergy > 0) {
                tooltip.add((Component)PrimordialCradleBlock.createValueComponent(df, lifeEnergy, "Life Energy"));
            }
            if (success > 0) {
                tooltip.add((Component)PrimordialCradleBlock.createValueComponent(df, success, "Success"));
            }
            if (disease > 0) {
                tooltip.add((Component)PrimordialCradleBlock.createValueComponent(df, disease, "Disease"));
            }
            if (hostile != 0) {
                tooltip.add((Component)PrimordialCradleBlock.createValueComponent(df, hostile, "Hostile"));
            }
            if (anomaly > 0) {
                tooltip.add((Component)PrimordialCradleBlock.createValueComponent(df, anomaly, "Anomaly"));
            }
        }
    }
}

