/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.cradle;

import com.github.elenterius.biomancy.api.tribute.Tribute;
import com.github.elenterius.biomancy.api.tribute.Tributes;
import com.google.common.math.IntMath;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;

public class SacrificeHandler
implements INBTSerializable<CompoundTag> {
    private static final int MAX_BIOMASS_VALUE = 100;
    private byte biomass;
    private int lifeEnergy;
    private int successValue;
    private int diseaseValue;
    private int hostileValue;
    private int anomalyValue;
    private boolean hasModifiers;

    public SacrificeHandler() {
        this.reset();
    }

    public void reset() {
        this.biomass = 0;
        this.lifeEnergy = 0;
        this.successValue = 0;
        this.diseaseValue = 0;
        this.hostileValue = 85;
        this.anomalyValue = 7;
        this.hasModifiers = false;
    }

    public boolean isFull() {
        return this.lifeEnergy >= 100 && this.biomass >= 100;
    }

    public void setBiomass(int amount) {
        this.biomass = (byte)Mth.m_14045_((int)amount, (int)0, (int)100);
    }

    public boolean addBiomass(int amount) {
        if (amount == 0) {
            return false;
        }
        if (amount < 0 && this.biomass > 0) {
            this.setBiomass(this.biomass + amount);
            return true;
        }
        if (amount > 0 && this.biomass < 100) {
            this.setBiomass(this.biomass + amount);
            return true;
        }
        return false;
    }

    public int getBiomassAmount() {
        return this.biomass;
    }

    public float getBiomassPct() {
        return (float)this.biomass / 100.0f;
    }

    public void setLifeEnergy(int amount) {
        this.lifeEnergy = Mth.m_14045_((int)amount, (int)0, (int)Integer.MAX_VALUE);
    }

    public boolean addLifeEnergy(int amount) {
        if (amount == 0) {
            return false;
        }
        if (amount < 0 && this.lifeEnergy > 0) {
            this.setLifeEnergy(this.lifeEnergy + amount);
            return true;
        }
        if (amount > 0) {
            this.setLifeEnergy(IntMath.saturatedAdd((int)this.lifeEnergy, (int)amount));
            return true;
        }
        return false;
    }

    public int getLifeEnergyAmount() {
        return this.lifeEnergy;
    }

    public float getLifeEnergyPct() {
        return (float)this.lifeEnergy / 100.0f;
    }

    public float getSuccessChance() {
        return (float)this.successValue / 100.0f;
    }

    public float getHostileChance() {
        return (float)this.hostileValue / 100.0f;
    }

    public float getAnomalyChance() {
        return (float)this.anomalyValue / 100.0f;
    }

    public float getTumorFactor() {
        return (float)this.diseaseValue / 100.0f;
    }

    public boolean hasModifiers() {
        return this.hasModifiers;
    }

    public boolean addItem(ItemStack stack, Consumer<Tribute> onSuccess) {
        if (this.isFull()) {
            return false;
        }
        if (stack.m_41619_()) {
            return false;
        }
        Tribute tribute = Tributes.getTribute(stack);
        int count = this.addTribute(tribute, stack.m_41613_());
        if (count > 0) {
            stack.m_41774_(count);
            onSuccess.accept(tribute);
            return true;
        }
        return false;
    }

    public boolean addItem(ItemStack stack) {
        if (this.isFull()) {
            return false;
        }
        if (stack.m_41619_()) {
            return false;
        }
        int count = this.addTribute(Tributes.getTribute(stack), stack.m_41613_());
        if (count > 0) {
            stack.m_41774_(count);
            return true;
        }
        return false;
    }

    private int addTribute(Tribute tribute, int maxCount) {
        int n;
        for (n = maxCount; n > 0 && this.addTribute(tribute); --n) {
        }
        return maxCount - n;
    }

    public boolean addTribute(Tribute tribute) {
        boolean isModifier;
        if (this.isFull()) {
            return false;
        }
        if (tribute.isEmpty()) {
            return false;
        }
        boolean addedBiomass = this.addBiomass(tribute.biomass());
        boolean addedLifeEnergy = this.addLifeEnergy(tribute.lifeEnergy());
        boolean consumeTribute = addedBiomass || addedLifeEnergy;
        boolean bl = isModifier = tribute.biomass() == 0 && tribute.lifeEnergy() == 0;
        if (consumeTribute || isModifier) {
            this.successValue += tribute.successModifier();
            int diseaseModifier = tribute.diseaseModifier();
            int hostileModifier = tribute.hostileModifier();
            int anomalyModifier = tribute.anomalyModifier();
            if (diseaseModifier != 0 || hostileModifier != 0 || anomalyModifier != 0) {
                this.hasModifiers = true;
            }
            this.diseaseValue += diseaseModifier;
            this.hostileValue += hostileModifier;
            this.anomalyValue += anomalyModifier;
            return true;
        }
        return false;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128344_("Biomass", this.biomass);
        tag.m_128405_("LifeEnergy", this.lifeEnergy);
        tag.m_128405_("Success", this.successValue);
        tag.m_128405_("Disease", this.diseaseValue);
        tag.m_128405_("Hostile", this.hostileValue);
        tag.m_128405_("Anomaly", this.anomalyValue);
        tag.m_128379_("HasModifiers", this.hasModifiers);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.biomass = tag.m_128445_("Biomass");
        this.lifeEnergy = tag.m_128451_("LifeEnergy");
        this.successValue = tag.m_128451_("Success");
        this.diseaseValue = tag.m_128451_("Disease");
        this.hostileValue = tag.m_128451_("Hostile");
        this.anomalyValue = tag.m_128451_("Anomaly");
        this.hasModifiers = tag.m_128471_("HasModifiers");
    }
}

