/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.fleshspike;

import com.github.elenterius.biomancy.block.base.WaterloggedFacingBlock;
import com.github.elenterius.biomancy.block.fleshspike.FleshSpikeShapes;
import com.github.elenterius.biomancy.init.ModBlockProperties;
import com.github.elenterius.biomancy.init.ModDamageSources;
import com.github.elenterius.biomancy.util.EnhancedIntegerProperty;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FleshSpikeBlock
extends WaterloggedFacingBlock {
    public static final EnhancedIntegerProperty SPIKES = ModBlockProperties.SPIKES;

    public FleshSpikeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)SPIKES.get(), (Comparable)Integer.valueOf(SPIKES.getMin())));
        FleshSpikeShapes.computePossibleShapes((List<BlockState>)this.f_49792_.m_61056_());
    }

    public static int getSpikes(BlockState blockState) {
        return SPIKES.getValue(blockState);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{SPIKES.get()});
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockState = context.m_43725_().m_8055_(context.m_8083_());
        if (blockState.m_60734_() instanceof FleshSpikeBlock) {
            return SPIKES.addValue(blockState, 1);
        }
        return super.m_5573_(context);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        if (!useContext.m_7078_() && useContext.m_43722_().m_150930_(this.m_5456_()) && FleshSpikeBlock.getSpikes(state) < SPIKES.getMax()) {
            return true;
        }
        return super.m_6864_(state, useContext);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = FleshSpikeBlock.getFacing(state);
        BlockPos basePos = pos.m_121945_(direction.m_122424_());
        return Block.m_49863_((LevelReader)level, (BlockPos)basePos, (Direction)direction);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return FleshSpikeShapes.getBoundingShape(state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.f_60443_ ? FleshSpikeShapes.getCollisionShape(state) : Shapes.m_83040_();
    }

    public boolean m_180643_(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (FleshSpikeBlock.getFacing(state) == Direction.UP) {
            int spikes = FleshSpikeBlock.getSpikes(state);
            entity.m_142535_(fallDistance + 2.0f, 1.0f + (float)spikes * 0.5f, ModDamageSources.fallOnSpike(level, pos));
        } else {
            super.m_142072_(level, state, pos, entity, fallDistance);
        }
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof ItemEntity) {
            return;
        }
        if (!this.isEntityInsideDamageArea(level, pos, state, entity)) {
            return;
        }
        Direction direction = FleshSpikeBlock.getFacing(state);
        Vec3i normal = direction.m_122436_();
        float x = (float)(1 - Math.abs(normal.m_123341_())) * 0.1f;
        float y = (float)(1 - Math.abs(normal.m_123342_())) * 0.1f;
        float z = (float)(1 - Math.abs(normal.m_123343_())) * 0.1f;
        entity.m_7601_(state, new Vec3(0.9 - (double)x, 0.9 - (double)y, 0.9 - (double)z));
        if (!level.f_46443_) {
            boolean isMovingAwayCorrectly = entity.m_6374_() == direction;
            int spikes = FleshSpikeBlock.getSpikes(state);
            entity.m_6469_(ModDamageSources.impaleBySpike(level, pos), (float)spikes + (!isMovingAwayCorrectly ? 0.5f : 0.0f));
        }
    }

    private boolean isEntityInsideDamageArea(Level level, BlockPos pos, BlockState state, Entity entity) {
        VoxelShape blockShape = FleshSpikeShapes.getDamageShape(state).m_83216_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        VoxelShape entityShape = Shapes.m_83064_((AABB)entity.m_20191_());
        return Shapes.m_83157_((VoxelShape)blockShape, (VoxelShape)entityShape, (BooleanOp)BooleanOp.f_82689_);
    }
}

