/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.mawhopper;

import com.github.elenterius.biomancy.block.mawhopper.MawHopperBlockEntity;
import com.github.elenterius.biomancy.block.mawhopper.MawHopperShapes;
import com.github.elenterius.biomancy.block.property.DirectedConnection;
import com.github.elenterius.biomancy.block.property.VertexType;
import com.github.elenterius.biomancy.init.ModBlockEntities;
import com.github.elenterius.biomancy.init.ModBlockProperties;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MawHopperBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<DirectedConnection> CONNECTION = ModBlockProperties.DIRECTED_CONNECTION;
    public static final EnumProperty<VertexType> VERTEX_TYPE = ModBlockProperties.VERTEX_TYPE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public MawHopperBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(CONNECTION, (Comparable)((Object)DirectedConnection.UP_DOWN))).m_61124_(VERTEX_TYPE, (Comparable)((Object)VertexType.SOURCE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        MawHopperShapes.computePossibleShapes((List<BlockState>)this.f_49792_.m_61056_());
    }

    public static DirectedConnection getConnection(BlockState state) {
        return (DirectedConnection)((Object)state.m_61143_(CONNECTION));
    }

    public static VertexType getVertexType(BlockState state) {
        return (VertexType)((Object)state.m_61143_(VERTEX_TYPE));
    }

    private static boolean isWaterlogged(BlockState blockState) {
        return Boolean.TRUE.equals(blockState.m_61143_((Property)WATERLOGGED));
    }

    private static boolean isOutgoingConnected(LevelAccessor level, BlockPos pos, DirectedConnection connection) {
        BlockState blockStateAtOutgoingPos = level.m_8055_(pos.m_121945_(connection.outgoing));
        return blockStateAtOutgoingPos.m_60734_() instanceof MawHopperBlock && MawHopperBlock.getConnection((BlockState)blockStateAtOutgoingPos).ingoing.m_122424_() == connection.outgoing;
    }

    private static boolean isIngoingConnected(LevelAccessor level, BlockPos pos, DirectedConnection connection) {
        BlockState blockStateAtOutgoingPos = level.m_8055_(pos.m_121945_(connection.ingoing));
        return blockStateAtOutgoingPos.m_60734_() instanceof MawHopperBlock && MawHopperBlock.getConnection((BlockState)blockStateAtOutgoingPos).outgoing.m_122424_() == connection.ingoing;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{CONNECTION, VERTEX_TYPE, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return MawHopperBlock.isWaterlogged(state) ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction outgoing;
        Direction ingoing;
        boolean isWaterlogged;
        boolean bl = isWaterlogged = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        if (context.m_7078_()) {
            ingoing = context.m_43719_();
            outgoing = ingoing.m_122424_();
        } else {
            outgoing = context.m_43719_();
            ingoing = outgoing.m_122424_();
        }
        DirectedConnection connection = DirectedConnection.from(ingoing, outgoing);
        BlockPos sourcePos = context.m_8083_().m_121945_(context.m_43719_().m_122424_());
        BlockState sourceState = context.m_43725_().m_8055_(sourcePos);
        if (sourceState.m_60734_() instanceof MawHopperBlock && MawHopperBlock.getVertexType(sourceState) != VertexType.INNER) {
            DirectedConnection sourceConnection = MawHopperBlock.getConnection(sourceState);
            Direction direction = ingoing.m_122424_();
            VertexType vertexType = VertexType.SOURCE;
            if (direction == sourceConnection.outgoing) {
                vertexType = VertexType.SINK;
            }
            return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(CONNECTION, (Comparable)((Object)connection))).m_61124_(VERTEX_TYPE, (Comparable)((Object)vertexType))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged));
        }
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(CONNECTION, (Comparable)((Object)connection))).m_61124_(VERTEX_TYPE, (Comparable)((Object)VertexType.SOURCE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged));
    }

    public BlockState m_7417_(BlockState ourState, Direction updateDirection, BlockState theirState, LevelAccessor level, BlockPos ourPos, BlockPos theirPos) {
        if (MawHopperBlock.isWaterlogged(ourState)) {
            level.m_186469_(ourPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        DirectedConnection ourConnection = MawHopperBlock.getConnection(ourState);
        boolean isUpdateFromIngoing = updateDirection == ourConnection.ingoing;
        boolean isUpdateFromOutgoing = updateDirection == ourConnection.outgoing;
        boolean isUpdateFromMaw = theirState.m_60734_() instanceof MawHopperBlock;
        if (isUpdateFromMaw) {
            VertexType ourVertexType = MawHopperBlock.getVertexType(ourState);
            if (ourVertexType == VertexType.INNER) {
                return ourState;
            }
            DirectedConnection theirConnection = MawHopperBlock.getConnection(theirState);
            boolean theyPullFromUs = theirPos.m_121945_(theirConnection.ingoing).equals((Object)ourPos);
            boolean theyPushToUs = theirPos.m_121945_(theirConnection.outgoing).equals((Object)ourPos);
            if (theyPushToUs && !isUpdateFromOutgoing) {
                DirectedConnection connection = DirectedConnection.from(theirConnection.outgoing.m_122424_(), ourConnection.outgoing);
                boolean isOutgoingConnected = MawHopperBlock.isOutgoingConnected(level, ourPos, ourConnection);
                VertexType vertexType = isOutgoingConnected ? VertexType.INNER : VertexType.SINK;
                return (BlockState)((BlockState)ourState.m_61124_(VERTEX_TYPE, (Comparable)((Object)vertexType))).m_61124_(CONNECTION, (Comparable)((Object)connection));
            }
            if (theyPullFromUs && !isUpdateFromIngoing) {
                DirectedConnection connection = ourVertexType == VertexType.SOURCE ? ourConnection : DirectedConnection.from(ourConnection.ingoing, theirConnection.ingoing.m_122424_());
                boolean isIngoingConnected = MawHopperBlock.isIngoingConnected(level, ourPos, ourConnection);
                VertexType vertexType = isIngoingConnected ? VertexType.INNER : VertexType.SOURCE;
                return (BlockState)((BlockState)ourState.m_61124_(VERTEX_TYPE, (Comparable)((Object)vertexType))).m_61124_(CONNECTION, (Comparable)((Object)connection));
            }
            return ourState;
        }
        if (isUpdateFromIngoing) {
            return this.getBlockState(ourState, ourConnection, VertexType.SOURCE);
        }
        if (isUpdateFromOutgoing) {
            if (MawHopperBlock.isIngoingConnected(level, ourPos, ourConnection)) {
                return (BlockState)ourState.m_61124_(VERTEX_TYPE, (Comparable)((Object)VertexType.SINK));
            }
            return this.getBlockState(ourState, ourConnection, VertexType.SOURCE);
        }
        return ourState;
    }

    private BlockState getBlockState(BlockState blockState, DirectedConnection connection, VertexType vertexType) {
        if (vertexType == VertexType.SOURCE && connection.isCorner()) {
            connection = DirectedConnection.from(connection.outgoing.m_122424_(), connection.outgoing);
            blockState = (BlockState)blockState.m_61124_(CONNECTION, (Comparable)((Object)connection));
        }
        return (BlockState)blockState.m_61124_(VERTEX_TYPE, (Comparable)((Object)vertexType));
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity;
            if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof MawHopperBlockEntity) {
                MawHopperBlockEntity blockEntity2 = (MawHopperBlockEntity)blockEntity;
                blockEntity2.dropInventoryContents(level, pos);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (player.m_21120_(hand).m_41619_() && (blockEntity = level.m_7702_(pos)) instanceof MawHopperBlockEntity) {
            MawHopperBlockEntity blockEntity2 = (MawHopperBlockEntity)blockEntity;
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            blockEntity2.giveInventoryContentsTo(level, pos, player);
            return InteractionResult.CONSUME;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModBlockEntities.MAW_HOPPER.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : MawHopperBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.MAW_HOPPER.get()), MawHopperBlockEntity::serverTick);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (MawHopperBlock.getVertexType(state) != VertexType.SOURCE) {
            return;
        }
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof MawHopperBlockEntity) {
            MawHopperBlockEntity blockEntity = (MawHopperBlockEntity)blockentity;
            MawHopperBlockEntity.entityInside(level, pos, state, blockEntity, entity);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return MawHopperShapes.getShape(state);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_(CONNECTION, (Comparable)((Object)MawHopperBlock.getConnection(state).rotate(rotation)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_(MawHopperBlock.getConnection((BlockState)state).ingoing));
    }
}

