/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.membrane;

import com.github.elenterius.biomancy.block.FleshBlock;
import com.github.elenterius.biomancy.block.cradle.PrimalEnergyHandler;
import com.github.elenterius.biomancy.block.membrane.IgnoreEntityCollisionPredicate;
import com.github.elenterius.biomancy.block.membrane.MembraneBlock;
import com.github.elenterius.biomancy.block.veins.FleshVeinsBlock;
import com.github.elenterius.biomancy.init.ModBlocks;
import com.github.elenterius.biomancy.util.VectorUtil;
import com.github.elenterius.biomancy.world.PrimordialEcosystem;
import com.github.elenterius.biomancy.world.mound.MoundShape;
import com.github.elenterius.biomancy.world.spatial.SpatialShapeManager;
import com.github.elenterius.biomancy.world.spatial.geometry.Shape;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class SpreadingMembraneBlock
extends MembraneBlock {
    public SpreadingMembraneBlock(BlockBehaviour.Properties properties, IgnoreEntityCollisionPredicate predicate) {
        super(properties.m_60977_(), predicate);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        MoundShape mound;
        BlockEntity blockEntity;
        if (level.f_46441_.m_188501_() >= 0.5f) {
            return;
        }
        if (!level.isAreaLoaded(pos, 2)) {
            return;
        }
        BlockPos targetPos = pos.m_121955_(VectorUtil.randomOffsetInCube3i(random));
        BlockState stateAtTargetPos = level.m_8055_(targetPos);
        if (!(stateAtTargetPos.m_60795_() || stateAtTargetPos.m_60734_() instanceof FleshVeinsBlock || PrimordialEcosystem.isReplaceable(stateAtTargetPos))) {
            return;
        }
        Shape shape = SpatialShapeManager.getClosestShape(level, pos, MoundShape.class::isInstance);
        if (shape instanceof MoundShape && (blockEntity = level.getExistingBlockEntity((mound = (MoundShape)shape).getOrigin())) instanceof PrimalEnergyHandler) {
            PrimalEnergyHandler energyHandler = (PrimalEnergyHandler)blockEntity;
            if (!mound.hasChamberAt(targetPos)) {
                Direction direction;
                int nextToAnyChamberCount = 0;
                Iterator iterator = Direction.m_235667_((RandomSource)random).iterator();
                while (iterator.hasNext() && (!mound.hasChamberAt(targetPos.m_121945_(direction = (Direction)iterator.next())) || ++nextToAnyChamberCount <= 1)) {
                }
                if (energyHandler.drainPrimalEnergy(4) > 0) {
                    if (nextToAnyChamberCount > 1) {
                        level.m_7731_(targetPos, this.m_49966_(), 2);
                    } else {
                        level.m_7731_(targetPos, ((FleshBlock)((Object)ModBlocks.MALIGNANT_FLESH.get())).m_49966_(), 2);
                        PrimordialEcosystem.spreadMalignantVeinsFromSource(level, targetPos, PrimordialEcosystem.MAX_CHARGE_SUPPLIER);
                    }
                }
            }
        }
    }
}

