/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.modularlarynx;

import com.github.elenterius.biomancy.block.modularlarynx.ModularLarynxBlockEntity;
import com.github.elenterius.biomancy.block.property.BlockPropertyUtil;
import com.github.elenterius.biomancy.block.property.MobSoundType;
import com.github.elenterius.biomancy.init.ModBlockEntities;
import com.github.elenterius.biomancy.init.ModBlockProperties;
import com.github.elenterius.biomancy.styles.TextComponentUtil;
import com.github.elenterius.biomancy.util.ComponentUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ModularLarynxBlock
extends BaseEntityBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final IntegerProperty NOTE = BlockStateProperties.f_61424_;
    public static final EnumProperty<MobSoundType> MOB_SOUND_TYPE = ModBlockProperties.MOB_SOUND_TYPE;
    protected static final VoxelShape SHAPE = ModularLarynxBlock.createShape();

    public ModularLarynxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)NOTE, (Comparable)Integer.valueOf(12))).m_61124_((Property)POWERED, (Comparable)Boolean.FALSE)).m_61124_(MOB_SOUND_TYPE, (Comparable)((Object)MobSoundType.AMBIENT)));
    }

    private static VoxelShape createShape() {
        return Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), (VoxelShape)Block.m_49796_((double)3.0, (double)5.0, (double)3.0, (double)13.0, (double)15.0, (double)13.0), (BooleanOp)BooleanOp.f_82695_);
    }

    public static MobSoundType getMobSoundType(BlockState state) {
        return (MobSoundType)((Object)state.m_61143_(MOB_SOUND_TYPE));
    }

    public static boolean isPowered(BlockState state) {
        return (Boolean)state.m_61143_((Property)POWERED);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED, NOTE, MOB_SOUND_TYPE});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModBlockEntities.MODULAR_LARYNX.get()).m_155264_(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ModularLarynxBlockEntity larynx;
        BlockEntity blockEntity;
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack heldStack = player.m_21120_(hand);
        if (!heldStack.m_41619_()) {
            ModularLarynxBlockEntity larynx2;
            ItemStack remainder;
            BlockEntity blockEntity2 = level.m_7702_(pos);
            if (blockEntity2 instanceof ModularLarynxBlockEntity && (remainder = (larynx2 = (ModularLarynxBlockEntity)blockEntity2).insertItemStack(heldStack.m_41777_())).m_41613_() != heldStack.m_41613_()) {
                if (!player.m_7500_()) {
                    player.m_21008_(hand, remainder);
                }
                return InteractionResult.CONSUME;
            }
        } else if (player.m_6144_() && (blockEntity = level.m_7702_(pos)) instanceof ModularLarynxBlockEntity && !(larynx = (ModularLarynxBlockEntity)blockEntity).isInventoryEmpty()) {
            larynx.dropInventoryContents(level, pos);
            return InteractionResult.CONSUME;
        }
        state = !player.m_6144_() ? (BlockState)state.m_61122_((Property)NOTE) : (BlockState)state.m_61124_((Property)NOTE, (Comparable)BlockPropertyUtil.getPrevious(NOTE, (Integer)state.m_61143_((Property)NOTE)));
        level.m_7731_(pos, state, 3);
        this.playSound(state, level, pos);
        return InteractionResult.CONSUME;
    }

    public void m_6256_(BlockState state, Level level, BlockPos pos, Player player) {
        this.playSound(state, level, pos);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean hasSignal = level.m_276867_(pos);
        if (hasSignal != ModularLarynxBlock.isPowered(state)) {
            if (hasSignal) {
                this.playSound(state, level, pos);
            }
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(hasSignal)), 3);
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState stateBelow = context.m_43725_().m_8055_(context.m_8083_().m_7495_());
        return (BlockState)this.m_49966_().m_61124_(MOB_SOUND_TYPE, (Comparable)((Object)this.getSoundTypeFromStateBelow(stateBelow)));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (direction == Direction.DOWN) {
            return (BlockState)state.m_61124_(MOB_SOUND_TYPE, (Comparable)((Object)this.getSoundTypeFromStateBelow(neighborState)));
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    private MobSoundType getSoundTypeFromStateBelow(BlockState stateBelow) {
        if (stateBelow.m_60713_(Blocks.f_50135_) || stateBelow.m_60713_(Blocks.f_50136_)) {
            return MobSoundType.DEATH;
        }
        if (stateBelow.m_60713_(Blocks.f_50450_)) {
            return MobSoundType.HURT;
        }
        return MobSoundType.AMBIENT;
    }

    private void playSound(BlockState state, Level level, BlockPos pos) {
        if (level.f_46443_) {
            return;
        }
        if (!level.m_46859_(pos.m_7494_())) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ModularLarynxBlockEntity) {
            ModularLarynxBlockEntity larynx = (ModularLarynxBlockEntity)blockEntity;
            int note = (Integer)state.m_61143_((Property)NOTE);
            float pitch = (float)Math.pow(2.0, (double)(note - 12) / 12.0);
            larynx.playSound(3.0f, pitch);
            level.m_7696_(pos, (Block)this, 0, note);
        }
    }

    public boolean m_8133_(BlockState state, Level level, BlockPos pos, int id, int param) {
        if (id == 0) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123758_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.2, (double)pos.m_123343_() + 0.5, (double)param / 24.0, 0.0, 0.0);
        }
        return true;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileEntity;
        if (!state.m_60713_(newState.m_60734_()) && (tileEntity = level.m_7702_(pos)) instanceof ModularLarynxBlockEntity) {
            ModularLarynxBlockEntity voiceBox = (ModularLarynxBlockEntity)tileEntity;
            voiceBox.dropInventoryContents(level, pos);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, level, tooltip, flag);
        tooltip.add(ComponentUtil.emptyLine());
        tooltip.add((Component)ModularLarynxBlock.getExtraTooltip((Block)this, "1").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)ComponentUtil.literal(" ").m_7220_((Component)ModularLarynxBlock.getExtraTooltip((Block)this, "2")).m_130940_(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)ModularLarynxBlock.getExtraTooltip((Block)this, "3").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)ComponentUtil.literal(" ").m_7220_((Component)ModularLarynxBlock.getExtraTooltip((Block)this, "4")).m_130940_(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)ModularLarynxBlock.getExtraTooltip((Block)this, "5").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)ComponentUtil.literal(" ").m_7220_((Component)ModularLarynxBlock.getExtraTooltip((Block)this, "6")).m_130940_(ChatFormatting.DARK_GRAY));
    }

    public static MutableComponent getExtraTooltip(Block block, String suffix) {
        return ComponentUtil.translatable(TextComponentUtil.getItemTooltipKey(block) + "." + suffix);
    }
}

