/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.neural;

import com.github.elenterius.biomancy.util.SoundUtil;
import com.github.elenterius.biomancy.world.MobSpawnFilterShape;
import com.github.elenterius.biomancy.world.spatial.SpatialShapeManager;
import com.github.elenterius.biomancy.world.spatial.geometry.SphereShape;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class NeuralInterceptorBlock
extends HorizontalDirectionalBlock {
    protected static final VoxelShape SHAPE = NeuralInterceptorBlock.createShape();

    private static VoxelShape createShape() {
        VoxelShape a = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);
        VoxelShape b = Block.m_49796_((double)3.0, (double)8.0, (double)3.0, (double)13.0, (double)17.0, (double)13.0);
        return Shapes.m_83113_((VoxelShape)a, (VoxelShape)b, (BooleanOp)BooleanOp.f_82695_);
    }

    public NeuralInterceptorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SpatialShapeManager.getOrCreateShape(serverLevel, pos, () -> {
                SphereShape shape = new SphereShape((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 48.0f);
                return new MobSpawnFilterShape(shape);
            });
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                SpatialShapeManager.remove(serverLevel, pos);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (random.m_188503_(4) == 0) {
            int particleAmount = random.m_216339_(2, 8);
            int color = 10438006;
            double r = (double)(color >> 16 & 0xFF) / 255.0;
            double g = (double)(color >> 8 & 0xFF) / 255.0;
            double b = (double)(color & 0xFF) / 255.0;
            for (int i = 0; i < particleAmount; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123811_, (double)((float)pos.m_123341_() + (random.m_188501_() * 0.8f + 0.1f)), (double)((float)pos.m_123342_() + 0.75f), (double)((float)pos.m_123343_() + (random.m_188501_() * 0.8f + 0.1f)), r, g, b);
            }
            if (random.m_188503_(3) == 0) {
                SoundUtil.clientPlayBlockSound(level, pos, SoundEvents.f_12503_, 0.6f, 0.6f);
            }
        }
    }
}

