/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.veins;

import com.github.elenterius.biomancy.block.DirectionalSlabBlock;
import com.github.elenterius.biomancy.block.FleshBlock;
import com.github.elenterius.biomancy.block.bloom.BloomBlock;
import com.github.elenterius.biomancy.block.cradle.PrimalEnergyHandler;
import com.github.elenterius.biomancy.block.membrane.MembraneBlock;
import com.github.elenterius.biomancy.block.veins.MalignantFleshSpreaderConfig;
import com.github.elenterius.biomancy.init.ModBlockProperties;
import com.github.elenterius.biomancy.init.ModBlocks;
import com.github.elenterius.biomancy.init.ModFluids;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import com.github.elenterius.biomancy.init.tags.ModBlockTags;
import com.github.elenterius.biomancy.util.ArrayUtil;
import com.github.elenterius.biomancy.util.Bit32Set;
import com.github.elenterius.biomancy.util.EnhancedIntegerProperty;
import com.github.elenterius.biomancy.util.LevelUtil;
import com.github.elenterius.biomancy.util.random.CellularNoise;
import com.github.elenterius.biomancy.world.PrimordialEcosystem;
import com.github.elenterius.biomancy.world.mound.MoundChamber;
import com.github.elenterius.biomancy.world.mound.MoundShape;
import com.github.elenterius.biomancy.world.mound.decorator.ChamberDecorator;
import com.github.elenterius.biomancy.world.mound.decorator.ChamberSpecialDecorator;
import com.github.elenterius.biomancy.world.spatial.SpatialShapeManager;
import com.github.elenterius.biomancy.world.spatial.geometry.HasRadius;
import com.github.elenterius.biomancy.world.spatial.geometry.Shape;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FleshVeinsBlock
extends MultifaceBlock
implements SimpleWaterloggedBlock {
    public static final Predicate<BlockState> BLOCKS_TO_AVOID_PREDICATE = blockState -> blockState.m_60713_((Block)ModBlocks.PRIMAL_BLOOM.get());
    protected static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final EnhancedIntegerProperty CHARGE = ModBlockProperties.CHARGE;
    private final MultifaceSpreader spreader = new MultifaceSpreader((MultifaceSpreader.SpreadConfig)new MalignantFleshSpreaderConfig(this));

    public FleshVeinsBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60977_().m_278183_());
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CHARGE.get(), (Comparable)Integer.valueOf(CHARGE.getMin())));
    }

    public static boolean convert(BlockState state, ServerLevel level, BlockPos pos, int directNeighbors, @Nullable MoundShape mound, float nearBoundingCenterPct, @Nullable PrimalEnergyHandler energyHandler) {
        MoundChamber chamber;
        Bit32Set facesSet = new Bit32Set();
        facesSet.set(5, FleshVeinsBlock.m_153900_((BlockState)state, (Direction)Direction.DOWN));
        facesSet.set(4, FleshVeinsBlock.m_153900_((BlockState)state, (Direction)Direction.UP));
        facesSet.set(3, FleshVeinsBlock.m_153900_((BlockState)state, (Direction)Direction.NORTH));
        facesSet.set(2, FleshVeinsBlock.m_153900_((BlockState)state, (Direction)Direction.SOUTH));
        facesSet.set(1, FleshVeinsBlock.m_153900_((BlockState)state, (Direction)Direction.WEST));
        facesSet.set(0, FleshVeinsBlock.m_153900_((BlockState)state, (Direction)Direction.EAST));
        if (mound != null && (chamber = mound.getChamberAt(pos)) != null && chamber.contains(pos)) {
            return FleshVeinsBlock.convertInsideChamber(level, pos, directNeighbors, mound, chamber, nearBoundingCenterPct, facesSet, energyHandler);
        }
        return FleshVeinsBlock.convertNormal(level, pos, mound, nearBoundingCenterPct, directNeighbors, facesSet);
    }

    protected static boolean convertNormal(ServerLevel level, BlockPos pos, @Nullable MoundShape mound, float nearBoundingCenterPct, int directNeighbors, Bit32Set facesSet) {
        int numFaces = facesSet.cardinality();
        boolean hasAnyBlockToAvoidNearby = LevelUtil.isBlockNearby(level, pos, 2, BLOCKS_TO_AVOID_PREDICATE);
        if (numFaces == 1) {
            CellularNoise cellularNoise = PrimordialEcosystem.getCellularNoise(level);
            float noiseValue = cellularNoise.getValueAtCenter(pos);
            Direction axisDirection = Direction.m_122376_((int)(5 - facesSet.nextSetBit(0)));
            boolean hasConvertedAnyOtherBlocks = FleshVeinsBlock.convertDirectNeighborBlock(level, pos, axisDirection, directNeighbors, cellularNoise, noiseValue);
            if (!hasConvertedAnyOtherBlocks && !hasAnyBlockToAvoidNearby && directNeighbors > 2) {
                if (noiseValue >= cellularNoise.borderThreshold()) {
                    return FleshVeinsBlock.convertSelfIntoSlabBlock(level, pos, axisDirection.m_122424_());
                }
                if (noiseValue < cellularNoise.coreThreshold() && PrimordialEcosystem.getRandomWithSeed(pos).m_188501_() <= 0.3f - nearBoundingCenterPct && LevelUtil.getMaxBrightness((Level)level, pos) > 5) {
                    return FleshVeinsBlock.convertSelfIntoBloom(level, pos, axisDirection);
                }
            }
            return hasConvertedAnyOtherBlocks;
        }
        if (hasAnyBlockToAvoidNearby) {
            return false;
        }
        if (numFaces > 3) {
            return FleshVeinsBlock.convertSelfIntoFullBlock(level, pos);
        }
        return FleshVeinsBlock.convertSelfIntoStairs(level, pos, facesSet);
    }

    protected static boolean convertInsideChamber(ServerLevel level, BlockPos pos, int directNeighbors, MoundShape mound, MoundChamber chamber, float nearBoundingCenterPct, Bit32Set facesSet, @Nullable PrimalEnergyHandler energyHandler) {
        Object[] axisDirections = (Direction[])Arrays.stream(facesSet.getIndices()).mapToObj(i -> Direction.m_122376_((int)(5 - i))).toArray(Direction[]::new);
        ArrayUtil.shuffle(axisDirections, level.f_46441_);
        for (Object axisDirection : axisDirections) {
            MoundChamber farChamber;
            BlockPos closeOffsetPos = pos.m_121945_((Direction)axisDirection);
            BlockState closeOffsetState = level.m_8055_(closeOffsetPos);
            if (PrimordialEcosystem.isReplaceable(closeOffsetState)) {
                return FleshVeinsBlock.destroyBlockAndConvertIntoEnergy(level, closeOffsetPos, energyHandler, 15);
            }
            if (!PrimordialEcosystem.FULL_FLESH_BLOCKS.contains(closeOffsetState.m_60734_())) continue;
            ChamberDecorator chamberDecorator = chamber.getDecorator();
            boolean chamberContainsCloseOffsetPos = chamber.contains(closeOffsetPos);
            if (chamberContainsCloseOffsetPos && !closeOffsetState.m_60713_((Block)ModBlocks.BLOOMLIGHT.get())) {
                ChamberDecorator.PartOfDecorationResult result = chamberDecorator.isBlockPartOfDecoration(chamber, (Level)level, closeOffsetPos, closeOffsetState);
                if (result.positionIsValid && !result.materialIsValid) {
                    return FleshVeinsBlock.destroyBlockAndConvertIntoEnergy(level, closeOffsetPos, energyHandler, 30);
                }
            }
            if (chamberDecorator.canPlace(chamber, (Level)level, pos, (Direction)axisDirection)) {
                return chamberDecorator.place(chamber, (Level)level, pos, (Direction)axisDirection);
            }
            BlockPos farOffsetPos = pos.m_5484_((Direction)axisDirection, 2);
            BlockState farOffsetState = level.m_8055_(farOffsetPos);
            if (!chamberContainsCloseOffsetPos && !mound.hasChamberAt(closeOffsetPos) && (farChamber = mound.getChamberAt(farOffsetPos)) != null && farChamber != chamber) {
                return level.m_7731_(closeOffsetPos, ((MembraneBlock)ModBlocks.PRIMAL_PERMEABLE_MEMBRANE.get()).m_49966_(), 2);
            }
            if (ChamberSpecialDecorator.BLOOMLIGHT.canDecorate(chamber, (Level)level, pos, (Direction)axisDirection, closeOffsetPos, closeOffsetState, farOffsetPos, farOffsetState)) {
                return ChamberSpecialDecorator.BLOOMLIGHT.decorate(chamber, (Level)level, pos, (Direction)axisDirection, closeOffsetPos, closeOffsetState, farOffsetPos, farOffsetState);
            }
            if (!PrimordialEcosystem.isReplaceable(farOffsetState) || !farOffsetState.m_60838_((BlockGetter)level, farOffsetPos)) continue;
            BlockState replacementState = level.f_46441_.m_188501_() < nearBoundingCenterPct ? (level.f_46441_.m_188501_() < 0.75f ? ((FleshBlock)((Object)ModBlocks.PRIMAL_FLESH.get())).m_49966_() : ((FleshBlock)((Object)ModBlocks.SMOOTH_PRIMAL_FLESH.get())).m_49966_()) : (level.f_46441_.m_188501_() < 0.75f ? ((FleshBlock)((Object)ModBlocks.MALIGNANT_FLESH.get())).m_49966_() : ((FleshBlock)((Object)ModBlocks.POROUS_PRIMAL_FLESH.get())).m_49966_());
            return level.m_7731_(farOffsetPos, replacementState, 2);
        }
        return false;
    }

    protected static boolean destroyBlockAndConvertIntoEnergy(ServerLevel level, BlockPos pos, @Nullable PrimalEnergyHandler energyHandler, int amount) {
        if (level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2)) {
            if (energyHandler != null) {
                energyHandler.fillPrimalEnergy(amount);
            }
            return true;
        }
        return false;
    }

    protected static boolean convertDirectNeighborBlock(ServerLevel level, BlockPos pos, Direction axisDirection, int directNeighbors, CellularNoise cellularNoise, float noiseValue) {
        BlockPos posRelative = pos.m_121945_(axisDirection);
        BlockState stateRelative = level.m_8055_(posRelative);
        BlockState replacementState = null;
        if (directNeighbors > 2) {
            if (stateRelative.m_60734_() == ModBlocks.PRIMAL_FLESH.get() || stateRelative.m_60734_() == ModBlocks.MALIGNANT_FLESH.get()) {
                posRelative = pos.m_5484_(axisDirection, 2);
                stateRelative = level.m_8055_(posRelative);
                return PrimordialEcosystem.tryToReplaceBlock(level, posRelative, stateRelative, ((FleshBlock)((Object)ModBlocks.PRIMAL_FLESH.get())).m_49966_());
            }
            replacementState = ((FleshBlock)((Object)ModBlocks.MALIGNANT_FLESH.get())).m_49966_();
        }
        if (PrimordialEcosystem.isReplaceableLog(stateRelative)) {
            if (noiseValue < cellularNoise.coreThreshold()) {
                if (stateRelative.m_61138_((Property)RotatedPillarBlock.f_55923_)) {
                    Direction.Axis axis = (Direction.Axis)stateRelative.m_61143_((Property)RotatedPillarBlock.f_55923_);
                    replacementState = (BlockState)Blocks.f_50453_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)axis);
                } else {
                    replacementState = ((WallBlock)ModBlocks.PRIMAL_FLESH_WALL.get()).m_49966_();
                }
            } else {
                replacementState = ((FleshBlock)((Object)ModBlocks.PRIMAL_FLESH.get())).m_49966_();
            }
        }
        if (replacementState != null) {
            return PrimordialEcosystem.tryToReplaceBlock(level, posRelative, stateRelative, replacementState);
        }
        return false;
    }

    protected static boolean convertSelfIntoBloom(ServerLevel level, BlockPos pos, Direction direction) {
        BlockState stateBelow;
        BlockPos posBelow;
        BloomBlock bloomBlock = (BloomBlock)((Object)ModBlocks.PRIMAL_BLOOM.get());
        boolean mayPlace = bloomBlock.mayPlaceOn((BlockGetter)level, posBelow = pos.m_121945_(direction), stateBelow = level.m_8055_(posBelow), Direction.UP);
        if (mayPlace && !LevelUtil.isBlockNearby(level, pos, 4, blockState -> blockState.m_60713_((Block)bloomBlock)) && bloomBlock.hasUnobstructedAim((BlockGetter)level, pos, direction.m_122424_())) {
            BlockState stateForPlacement = bloomBlock.getStateForPlacement((BlockGetter)level, pos, direction.m_122424_());
            return level.m_7731_(pos, stateForPlacement, 2);
        }
        return false;
    }

    protected static boolean convertSelfIntoSlabBlock(ServerLevel level, BlockPos pos, Direction direction) {
        BlockState stateForPlacement = ((DirectionalSlabBlock)((Object)ModBlocks.MALIGNANT_FLESH_SLAB.get())).getStateForPlacement((BlockGetter)level, pos, direction);
        return level.m_7731_(pos, stateForPlacement, 2);
    }

    protected static boolean convertSelfIntoFullBlock(ServerLevel level, BlockPos pos) {
        return level.m_7731_(pos, ((FleshBlock)((Object)ModBlocks.MALIGNANT_FLESH.get())).m_49966_(), 2);
    }

    protected static boolean convertSelfIntoStairs(ServerLevel level, BlockPos pos, Bit32Set facesSet) {
        int mask = facesSet.getBits();
        if (mask == 40) {
            BlockState blockState = (BlockState)((BlockState)((BlockState)((StairBlock)ModBlocks.MALIGNANT_FLESH_STAIRS.get()).m_49966_().m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.BOTTOM)).m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.NORTH)).m_61124_((Property)StairBlock.f_56843_, (Comparable)StairsShape.STRAIGHT);
            return level.m_7731_(pos, blockState, 2);
        }
        if (mask == 36) {
            BlockState blockState = (BlockState)((BlockState)((BlockState)((StairBlock)ModBlocks.MALIGNANT_FLESH_STAIRS.get()).m_49966_().m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.BOTTOM)).m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.SOUTH)).m_61124_((Property)StairBlock.f_56843_, (Comparable)StairsShape.STRAIGHT);
            return level.m_7731_(pos, blockState, 2);
        }
        if (mask == 34) {
            BlockState blockState = (BlockState)((BlockState)((BlockState)((StairBlock)ModBlocks.MALIGNANT_FLESH_STAIRS.get()).m_49966_().m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.BOTTOM)).m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.WEST)).m_61124_((Property)StairBlock.f_56843_, (Comparable)StairsShape.STRAIGHT);
            return level.m_7731_(pos, blockState, 2);
        }
        if (mask == 33) {
            BlockState blockState = (BlockState)((BlockState)((BlockState)((StairBlock)ModBlocks.MALIGNANT_FLESH_STAIRS.get()).m_49966_().m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.BOTTOM)).m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.EAST)).m_61124_((Property)StairBlock.f_56843_, (Comparable)StairsShape.STRAIGHT);
            return level.m_7731_(pos, blockState, 2);
        }
        if (mask == 41) {
            BlockState blockState = (BlockState)((BlockState)((BlockState)((StairBlock)ModBlocks.MALIGNANT_FLESH_STAIRS.get()).m_49966_().m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.BOTTOM)).m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.NORTH)).m_61124_((Property)StairBlock.f_56843_, (Comparable)StairsShape.INNER_RIGHT);
            return level.m_7731_(pos, blockState, 2);
        }
        if (mask == 42) {
            BlockState blockState = (BlockState)((BlockState)((BlockState)((StairBlock)ModBlocks.MALIGNANT_FLESH_STAIRS.get()).m_49966_().m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.BOTTOM)).m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.WEST)).m_61124_((Property)StairBlock.f_56843_, (Comparable)StairsShape.INNER_RIGHT);
            return level.m_7731_(pos, blockState, 2);
        }
        if (mask == 38) {
            BlockState blockState = (BlockState)((BlockState)((BlockState)((StairBlock)ModBlocks.MALIGNANT_FLESH_STAIRS.get()).m_49966_().m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.BOTTOM)).m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.SOUTH)).m_61124_((Property)StairBlock.f_56843_, (Comparable)StairsShape.INNER_RIGHT);
            return level.m_7731_(pos, blockState, 2);
        }
        if (mask == 37) {
            BlockState blockState = (BlockState)((BlockState)((BlockState)((StairBlock)ModBlocks.MALIGNANT_FLESH_STAIRS.get()).m_49966_().m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.BOTTOM)).m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.EAST)).m_61124_((Property)StairBlock.f_56843_, (Comparable)StairsShape.INNER_RIGHT);
            return level.m_7731_(pos, blockState, 2);
        }
        if (mask == 25) {
            BlockState blockState = (BlockState)((BlockState)((BlockState)((StairBlock)ModBlocks.MALIGNANT_FLESH_STAIRS.get()).m_49966_().m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.TOP)).m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.NORTH)).m_61124_((Property)StairBlock.f_56843_, (Comparable)StairsShape.INNER_RIGHT);
            return level.m_7731_(pos, blockState, 2);
        }
        if (mask == 22) {
            BlockState blockState = (BlockState)((BlockState)((BlockState)((StairBlock)ModBlocks.MALIGNANT_FLESH_STAIRS.get()).m_49966_().m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.TOP)).m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.SOUTH)).m_61124_((Property)StairBlock.f_56843_, (Comparable)StairsShape.INNER_RIGHT);
            return level.m_7731_(pos, blockState, 2);
        }
        if (mask == 21) {
            BlockState blockState = (BlockState)((BlockState)((BlockState)((StairBlock)ModBlocks.MALIGNANT_FLESH_STAIRS.get()).m_49966_().m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.TOP)).m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.EAST)).m_61124_((Property)StairBlock.f_56843_, (Comparable)StairsShape.INNER_RIGHT);
            return level.m_7731_(pos, blockState, 2);
        }
        if (mask == 26) {
            BlockState blockState = (BlockState)((BlockState)((BlockState)((StairBlock)ModBlocks.MALIGNANT_FLESH_STAIRS.get()).m_49966_().m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.TOP)).m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.WEST)).m_61124_((Property)StairBlock.f_56843_, (Comparable)StairsShape.INNER_RIGHT);
            return level.m_7731_(pos, blockState, 2);
        }
        if (mask == 24) {
            BlockState blockState = (BlockState)((BlockState)((BlockState)((StairBlock)ModBlocks.MALIGNANT_FLESH_STAIRS.get()).m_49966_().m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.TOP)).m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.NORTH)).m_61124_((Property)StairBlock.f_56843_, (Comparable)StairsShape.STRAIGHT);
            return level.m_7731_(pos, blockState, 2);
        }
        if (mask == 20) {
            BlockState blockState = (BlockState)((BlockState)((BlockState)((StairBlock)ModBlocks.MALIGNANT_FLESH_STAIRS.get()).m_49966_().m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.TOP)).m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.SOUTH)).m_61124_((Property)StairBlock.f_56843_, (Comparable)StairsShape.STRAIGHT);
            return level.m_7731_(pos, blockState, 2);
        }
        if (mask == 18) {
            BlockState blockState = (BlockState)((BlockState)((BlockState)((StairBlock)ModBlocks.MALIGNANT_FLESH_STAIRS.get()).m_49966_().m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.TOP)).m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.WEST)).m_61124_((Property)StairBlock.f_56843_, (Comparable)StairsShape.STRAIGHT);
            return level.m_7731_(pos, blockState, 2);
        }
        if (mask == 17) {
            BlockState blockState = (BlockState)((BlockState)((BlockState)((StairBlock)ModBlocks.MALIGNANT_FLESH_STAIRS.get()).m_49966_().m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.TOP)).m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.EAST)).m_61124_((Property)StairBlock.f_56843_, (Comparable)StairsShape.STRAIGHT);
            return level.m_7731_(pos, blockState, 2);
        }
        return false;
    }

    protected static BlockState m_153897_(BlockState state, BooleanProperty face) {
        BlockState blockstate = (BlockState)state.m_61124_((Property)face, (Comparable)Boolean.FALSE);
        return FleshVeinsBlock.m_153960_((BlockState)blockstate) ? blockstate : Blocks.f_50016_.m_49966_();
    }

    public static boolean canVeinsAttachTo(BlockGetter level, Direction direction, BlockPos pos, BlockState state) {
        if (state.m_204336_(ModBlockTags.DISALLOW_VEINS_TO_ATTACH)) {
            return false;
        }
        if (state.m_204336_(ModBlockTags.ALLOW_VEINS_TO_ATTACH)) {
            return true;
        }
        return Block.m_49918_((VoxelShape)state.m_60816_(level, pos), (Direction)direction.m_122424_()) || Block.m_49918_((VoxelShape)state.m_60812_(level, pos), (Direction)direction.m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATERLOGGED, CHARGE.get()});
    }

    public boolean m_6724_(BlockState state) {
        return this.getCharge(state) > 0;
    }

    protected int getCharge(BlockState state) {
        return CHARGE.getValue(state);
    }

    protected void setCharge(Level level, BlockPos pos, BlockState state, int amount) {
        if (!state.m_60713_((Block)this)) {
            return;
        }
        BlockState newState = CHARGE.setValue(state, amount);
        if (newState == state) {
            return;
        }
        level.m_7731_(pos, newState, 2);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (Boolean.TRUE.equals(state.m_61143_((Property)WATERLOGGED))) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (!FleshVeinsBlock.m_153960_((BlockState)state)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (FleshVeinsBlock.m_153900_((BlockState)state, (Direction)direction) && !FleshVeinsBlock.canVeinsAttachTo((BlockGetter)level, direction, neighborPos, neighborState)) {
            return FleshVeinsBlock.m_153897_(state, FleshVeinsBlock.m_153933_((Direction)direction));
        }
        return state;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        boolean flag = false;
        for (Direction direction : f_153806_) {
            if (!FleshVeinsBlock.m_153900_((BlockState)state, (Direction)direction)) continue;
            BlockPos blockpos = pos.m_121945_(direction);
            if (!FleshVeinsBlock.canVeinsAttachTo((BlockGetter)level, direction, blockpos, level.m_8055_(blockpos))) {
                return false;
            }
            flag = true;
        }
        return flag;
    }

    public boolean m_221571_(BlockGetter level, BlockState state, BlockPos pos, Direction direction) {
        if (!(!this.m_153920_(direction) || state.m_60713_((Block)this) && FleshVeinsBlock.m_153900_((BlockState)state, (Direction)direction))) {
            BlockPos blockPos = pos.m_121945_(direction);
            return FleshVeinsBlock.canVeinsAttachTo(level, direction, blockPos, level.m_8055_(blockPos));
        }
        return false;
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return !useContext.m_43722_().m_150930_(this.m_5456_()) || super.m_6864_(state, useContext);
    }

    public boolean m_5946_(BlockState state, Fluid fluid) {
        return fluid.getFluidType() == ModFluids.ACID_TYPE.get() || state.m_247087_() || !state.m_280296_();
    }

    public FluidState m_5888_(BlockState state) {
        return Boolean.TRUE.equals(state.m_61143_((Property)WATERLOGGED)) ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_60819_().m_76178_();
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (level.f_46443_) {
            return;
        }
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            int charge = CHARGE.getValue(state);
            if (charge >= CHARGE.getMax()) {
                return;
            }
            ItemStack stack = itemEntity.m_32055_();
            if (stack.m_41614_()) {
                int nutrition = Optional.ofNullable(stack.getFoodProperties(null)).filter(FoodProperties::m_38746_).map(FoodProperties::m_38744_).orElse(0);
                if (nutrition <= 0) {
                    return;
                }
                Vec3 motion = new Vec3(((double)level.f_46441_.m_188501_() - 0.5) * 0.1, (double)level.f_46441_.m_188501_() * 0.1 + 0.15, ((double)level.f_46441_.m_188501_() - 0.5) * 0.1);
                ((ServerLevel)level).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), 8, motion.f_82479_, motion.f_82480_, motion.f_82481_, (double)0.05f);
                int optimalAmount = Mth.m_14167_((float)(((float)CHARGE.getMax() - (float)charge) / (float)nutrition));
                int amount = Math.min(stack.m_41613_(), optimalAmount);
                stack.m_41774_(amount);
                this.setCharge(level, pos, state, charge += amount * nutrition);
                level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.DECOMPOSER_EAT.get(), SoundSource.BLOCKS, 0.6f, 0.15f + level.f_46441_.m_188501_() * 0.5f);
            }
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int charge;
        if (level.f_46441_.m_188501_() >= 0.5f) {
            return;
        }
        if (!level.isAreaLoaded(pos, 2)) {
            return;
        }
        PrimalEnergyHandler energyHandler = null;
        MoundShape mound = null;
        float nearBoundingCenterPct = 0.0f;
        Shape shape = SpatialShapeManager.getClosestShape(level, pos, MoundShape.class::isInstance);
        if (shape instanceof MoundShape) {
            Shape boundingShape;
            MoundShape moundShape = (MoundShape)shape;
            mound = moundShape;
            BlockPos origin = mound.getOrigin();
            BlockEntity existingBlockEntity = level.getExistingBlockEntity(origin);
            if (existingBlockEntity instanceof PrimalEnergyHandler) {
                PrimalEnergyHandler peh;
                energyHandler = peh = (PrimalEnergyHandler)existingBlockEntity;
            }
            if ((boundingShape = mound.getBoundingShapeAt(pos)) != null) {
                double d;
                if (boundingShape instanceof HasRadius) {
                    HasRadius sphere = (HasRadius)((Object)boundingShape);
                    d = sphere.getRadius();
                } else {
                    d = boundingShape.getAABB().m_82309_() / 2.0;
                }
                double radius = d;
                double radiusSqr = radius * radius;
                double distSqr = boundingShape.distanceToSqr((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
                nearBoundingCenterPct = Mth.m_14036_((float)((float)(1.0 - distSqr / radiusSqr)), (float)0.0f, (float)1.0f);
            }
        }
        if ((charge = this.getCharge(state)) < 2) {
            if (energyHandler != null && energyHandler.drainPrimalEnergy(1) > 0) {
                this.setCharge((Level)level, pos, state, charge + 1);
            }
            return;
        }
        int directNeighbors = 0;
        for (BlockEntity direction : Direction.values()) {
            BlockState neighborState = level.m_8055_(pos.m_121945_((Direction)direction));
            directNeighbors += neighborState.m_60713_((Block)this) ? 1 : 0;
        }
        float populationPct = (float)directNeighbors / (float)Direction.values().length;
        float conversionChance = (float)charge / ((float)CHARGE.getMax() + 5.0f) + populationPct * 0.5f;
        if (random.m_188501_() < conversionChance && FleshVeinsBlock.convert(state, level, pos, directNeighbors, mound, nearBoundingCenterPct, energyHandler)) {
            level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.FLESH_BLOCK_STEP.get(), SoundSource.BLOCKS, 0.8f, 0.15f + random.m_188501_() * 0.5f);
        }
        if (charge > 4) {
            int growthAmount = (int)Mth.m_14036_((float)this.m_213612_().m_221657_(state, (LevelAccessor)level, pos, false), (float)0.0f, (float)CHARGE.getMax());
            if (growthAmount > 0) {
                charge -= growthAmount * 2;
                state = level.m_8055_(pos);
                level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.FLESH_BLOCK_STEP.get(), SoundSource.BLOCKS, 0.6f, 0.15f + random.m_188501_() * 0.5f);
            }
        } else if (this.m_213612_().m_221619_(state, (LevelAccessor)level, pos, random).isPresent()) {
            charge -= 2;
            state = level.m_8055_(pos);
            level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.FLESH_BLOCK_STEP.get(), SoundSource.BLOCKS, 0.6f, 0.15f + random.m_188501_() * 0.5f);
        }
        if (energyHandler != null) {
            int primalEnergy = Math.max(charge, Math.round((float)CHARGE.getMax() * nearBoundingCenterPct) / 2);
            if (energyHandler.getPrimalEnergy() > primalEnergy && energyHandler.drainPrimalEnergy(primalEnergy) >= primalEnergy) {
                this.increaseChargeAroundPos(level, pos, random, primalEnergy * 2);
            } else if (charge > 1) {
                int usedCharge;
                for (int i = usedCharge = this.increaseChargeAroundPos(level, pos, random, charge); i > 0; --i) {
                    if (!(random.m_188501_() < 0.75f)) continue;
                    --charge;
                }
                charge = Math.max(charge, 1);
            }
            this.setCharge((Level)level, pos, state, charge);
        } else {
            if (charge > 1) {
                charge -= this.increaseChargeAroundPos(level, pos, random, charge);
            }
            this.setCharge((Level)level, pos, state, charge);
        }
    }

    public int increaseChargeAroundPos(ServerLevel level, BlockPos pos, RandomSource random, int availableCharge) {
        if (availableCharge <= 0) {
            return 0;
        }
        Object[] positions = new BlockPos[26];
        int i = 0;
        for (int y = -1; y <= 1; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    positions[i++] = pos.m_7918_(x, y, z);
                }
            }
        }
        ArrayUtil.shuffle(positions, random);
        int amount = Math.max(availableCharge / 2, 1);
        int usedCharge = 0;
        for (Object neighborPos : positions) {
            BlockState neighborState;
            if (availableCharge - (usedCharge += this.increaseCharge(level, (BlockPos)neighborPos, neighborState = level.m_8055_((BlockPos)neighborPos), amount)) <= 0) break;
        }
        return usedCharge;
    }

    public int increaseCharge(ServerLevel level, BlockPos pos, BlockState state, int amount) {
        if (!state.m_60713_((Block)this)) {
            return 0;
        }
        int currentCharge = this.getCharge(state);
        if (currentCharge < CHARGE.getMax()) {
            int usedCharge = Math.min(amount, CHARGE.getMax() - currentCharge);
            this.setCharge((Level)level, pos, state, usedCharge);
            return usedCharge;
        }
        return 0;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockState currentState, BlockGetter level, BlockPos pos, Direction lookingDirection, int charge) {
        BlockState stateForPlacement = this.m_153940_(currentState, level, pos, lookingDirection);
        if (stateForPlacement != null) {
            return CHARGE.setValue(stateForPlacement, charge);
        }
        return null;
    }

    public MultifaceSpreader m_213612_() {
        return this.spreader;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return Boolean.TRUE.equals(state.m_61143_((Property)WATERLOGGED)) ? 0 : 100;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return Boolean.TRUE.equals(state.m_61143_((Property)WATERLOGGED)) ? 0 : 15;
    }
}

