/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.client.gui.tooltip;

import com.github.elenterius.biomancy.api.nutrients.Nutrients;
import com.github.elenterius.biomancy.client.gui.tooltip.HrTooltipClientComponent;
import com.github.elenterius.biomancy.client.gui.tooltip.ScreenNutrientFuelConsumer;
import com.github.elenterius.biomancy.client.gui.tooltip.ScreenTooltipStyleProvider;
import com.github.elenterius.biomancy.init.ModRarities;
import com.github.elenterius.biomancy.item.ItemTooltipStyleProvider;
import com.github.elenterius.biomancy.styles.TextStyles;
import com.github.elenterius.biomancy.tooltip.EmptyLineTooltipComponent;
import com.github.elenterius.biomancy.tooltip.TooltipContents;
import com.github.elenterius.biomancy.util.ComponentUtil;
import com.github.elenterius.biomancy.util.FleshTongue;
import com.mojang.datafixers.util.Either;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="biomancy", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public final class TooltipHandler {
    private static final EmptyLineTooltipComponent EMPTY_LINE = new EmptyLineTooltipComponent();

    private TooltipHandler() {
    }

    @SubscribeEvent
    public static void onRenderTooltipColor(RenderTooltipEvent.Color tooltipEvent) {
        Screen screen;
        ItemStack stack = tooltipEvent.getItemStack();
        if (stack.m_41619_() && (screen = Minecraft.m_91087_().f_91080_) instanceof ScreenTooltipStyleProvider) {
            ScreenTooltipStyleProvider screenStyleProvider = (ScreenTooltipStyleProvider)screen;
            screenStyleProvider.getTooltipStyle().applyColorTo(tooltipEvent);
        } else {
            screen = stack.m_41720_();
            if (screen instanceof ItemTooltipStyleProvider) {
                ItemTooltipStyleProvider itemStyleProvider = (ItemTooltipStyleProvider)screen;
                itemStyleProvider.getTooltipStyle().applyColorTo(tooltipEvent);
            }
        }
    }

    @SubscribeEvent
    public static void onGetTooltipLines(ItemTooltipEvent event) {
        if (event.getEntity() == null) {
            return;
        }
        List<Component> fleshTongue = FleshTongue.getItemComment(event.getItemStack().m_41720_());
        if (fleshTongue != null) {
            event.getToolTip().addAll(1, fleshTongue);
        }
    }

    @SubscribeEvent
    public static void onGatherTooltipComponents(RenderTooltipEvent.GatherComponents event) {
        ItemStack stack = event.getItemStack();
        boolean isTooltip = stack.m_41720_() instanceof ItemTooltipStyleProvider;
        List tooltipElements = event.getTooltipElements();
        int i = 0;
        while (i < tooltipElements.size()) {
            Either either = (Either)tooltipElements.get(i);
            int index = i++;
            either.ifLeft(formattedText -> {
                if (formattedText instanceof Component) {
                    Component component = (Component)formattedText;
                    ComponentContents componentContents = component.m_214077_();
                    if (componentContents instanceof TooltipContents) {
                        TooltipContents contents = (TooltipContents)componentContents;
                        tooltipElements.set(index, Either.right((Object)contents.component()));
                    } else if (isTooltip && component == CommonComponents.f_237098_) {
                        tooltipElements.set(index, Either.right((Object)EMPTY_LINE));
                    }
                }
            });
        }
        if (Minecraft.m_91087_().f_91080_ instanceof ScreenNutrientFuelConsumer) {
            int fuelValue = Nutrients.getFuelValue(stack);
            int repairValue = Nutrients.getRepairValue(stack);
            if (fuelValue > 0 || repairValue > 0) {
                tooltipElements.add(Either.right((Object)EMPTY_LINE));
                tooltipElements.add(Either.left((Object)ComponentUtil.translatable("tooltip.biomancy.nutrients_fuel").m_130948_(TextStyles.NUTRIENTS)));
                if (fuelValue > 0) {
                    tooltipElements.add(Either.left((Object)ComponentUtil.literal(" +" + fuelValue + " Fuel").m_130948_(TextStyles.GRAY)));
                }
                if (repairValue > 0) {
                    tooltipElements.add(Either.left((Object)ComponentUtil.literal(" +" + repairValue + " Repair").m_130948_(TextStyles.GRAY)));
                }
            }
        }
    }

    public static void onPostRenderTooltip(ItemStack stack, List<ClientTooltipComponent> components, Font font, GuiGraphics guiGraphics, int posX, int posY, int tooltipWidth, int tooltipHeight) {
        if (!components.isEmpty()) {
            int n;
            Item item = stack.m_41720_();
            if (item instanceof ItemTooltipStyleProvider) {
                ItemTooltipStyleProvider provider = (ItemTooltipStyleProvider)item;
                n = provider.getTooltipColorWithAlpha(stack);
            } else {
                n = ModRarities.getARGBColor(stack);
            }
            int color = n;
            int y = posY;
            for (int i = 0; i < components.size(); ++i) {
                ClientTooltipComponent clientComponent = components.get(i);
                if (clientComponent instanceof HrTooltipClientComponent) {
                    HrTooltipClientComponent hrComponent = (HrTooltipClientComponent)clientComponent;
                    hrComponent.renderLine(guiGraphics, posX, y, tooltipWidth, i, color);
                }
                y += clientComponent.m_142103_() + (i == 0 ? 2 : 0);
            }
        }
    }
}

