/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.client.render.entity.mob;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.entity.mob.FleshChicken;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.molang.MolangParser;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;

public class FleshChickenModel<T extends FleshChicken>
extends DefaultedEntityGeoModel<T> {
    public FleshChickenModel() {
        super(BiomancyMod.createRL("mob/flesh_chicken"), true);
    }

    public void setCustomAnimations(T chicken, long instanceId, AnimationState<T> animationState) {
        CoreGeoBone wing1;
        super.setCustomAnimations(chicken, instanceId, animationState);
        float wingRotation = this.getWingRotation(chicken, animationState.getPartialTick());
        CoreGeoBone wing0 = this.getAnimationProcessor().getBone("wing0");
        if (wing0 != null) {
            wing0.setRotZ(wingRotation);
        }
        if ((wing1 = this.getAnimationProcessor().getBone("wing1")) != null) {
            wing1.setRotZ(-wingRotation);
        }
    }

    protected float getWingRotation(T chicken, float partialTicks) {
        float flapProgress = Mth.m_14179_((float)partialTicks, (float)((FleshChicken)((Object)chicken)).f_28229_, (float)((FleshChicken)((Object)chicken)).f_28226_);
        float flapSpeed = Mth.m_14179_((float)partialTicks, (float)((FleshChicken)((Object)chicken)).f_28228_, (float)((FleshChicken)((Object)chicken)).f_28227_);
        return (Mth.m_14031_((float)flapProgress) + 1.0f) * flapSpeed;
    }

    public void applyMolangQueries(T animatable, double animTime) {
        super.applyMolangQueries(animatable, animTime);
        MolangParser parser = MolangParser.INSTANCE;
        parser.setMemoizedValue("custom_query.limb_swing", () -> {
            boolean shouldSit = animatable.m_20159_() && animatable.m_20202_() != null && animatable.m_20202_().shouldRiderSit();
            float limbSwing = 0.0f;
            if (!shouldSit && animatable.m_6084_()) {
                limbSwing = animatable.f_267362_.m_267590_(Minecraft.m_91087_().getPartialTick());
                if (animatable.m_6162_()) {
                    limbSwing *= 3.0f;
                }
            }
            return limbSwing;
        });
        parser.setMemoizedValue("custom_query.limb_swing_amount", () -> {
            boolean shouldSit = animatable.m_20159_() && animatable.m_20202_() != null && animatable.m_20202_().shouldRiderSit();
            float limbSwingAmount = 0.0f;
            if (!shouldSit && animatable.m_6084_() && (limbSwingAmount = animatable.f_267362_.m_267711_(Minecraft.m_91087_().getPartialTick())) > 1.0f) {
                limbSwingAmount = 1.0f;
            }
            return limbSwingAmount;
        });
    }
}

