/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.client.render.item.injector;

import com.github.elenterius.biomancy.client.render.item.injector.InjectorModel;
import com.github.elenterius.biomancy.item.injector.InjectorItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;

public class InjectorRenderer
extends GeoItemRenderer<InjectorItem> {
    private ItemDisplayContext currentTransformType;
    private int serumColor = -1;

    public InjectorRenderer() {
        super((GeoModel)new InjectorModel());
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        this.currentTransformType = displayContext;
        super.m_108829_(stack, displayContext, poseStack, buffer, packedLight, packedOverlay);
    }

    public void preRender(PoseStack poseStack, InjectorItem item, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.serumColor = item.getSerum(this.getCurrentItemStack()).getColor();
        super.preRender(poseStack, (Item)item, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void renderRecursively(PoseStack poseStack, InjectorItem item, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (bone.getName().equals("_serum_core")) {
            this.renderSerumBone(poseStack, item, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, alpha);
        } else {
            super.renderRecursively(poseStack, (Item)item, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        }
    }

    private void renderSerumBone(PoseStack poseStack, InjectorItem item, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float alpha) {
        if (this.serumColor == -1) {
            return;
        }
        float r = (float)FastColor.ARGB32.m_13665_((int)this.serumColor) / 255.0f;
        float g = (float)FastColor.ARGB32.m_13667_((int)this.serumColor) / 255.0f;
        float b = (float)FastColor.ARGB32.m_13669_((int)this.serumColor) / 255.0f;
        super.renderRecursively(poseStack, (Item)item, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, r, g, b, alpha);
    }

    public long getInstanceId(InjectorItem item) {
        if (this.currentTransformType == ItemDisplayContext.GUI) {
            return -1L;
        }
        return super.getInstanceId((Item)((InjectorItem)this.animatable));
    }
}

