/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.client.util;

import com.github.elenterius.biomancy.init.client.ClientSetupHandler;
import com.github.elenterius.biomancy.item.ItemTooltipStyleProvider;
import com.github.elenterius.biomancy.styles.TextComponentUtil;
import com.github.elenterius.biomancy.styles.TextStyles;
import com.github.elenterius.biomancy.util.ComponentUtil;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class ClientTextUtil {
    private static final MutableComponent CTRL_KEY_TEXT = ComponentUtil.translatable("keyboard.biomancy.ctrl");
    private static final MutableComponent ALT_KEY_TEXT = ComponentUtil.translatable("keyboard.biomancy.alt");
    private static final MutableComponent SHIFT_KEY_TEXT = ComponentUtil.translatable("keyboard.biomancy.shift");
    private static final MutableComponent RIGHT_MOUSE_KEY_TEXT = ComponentUtil.translatable("keyboard.biomancy.right_mouse");
    private static final MutableComponent SHOW_INFO = ComponentUtil.translatable("tooltip.biomancy.action.show_info");
    private static DecimalFormat decimalFormat = null;
    private static String prevPattern = "";
    private static Locale prevLocale = null;

    private ClientTextUtil() {
    }

    private static MutableComponent getItemTooltip(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof ItemTooltipStyleProvider) {
            ItemTooltipStyleProvider iTooltip = (ItemTooltipStyleProvider)item;
            return iTooltip.getTooltipText(stack);
        }
        return TextComponentUtil.getItemTooltip(item);
    }

    public static List<Component> getItemInfoTooltip(ItemStack stack) {
        if (Screen.m_96637_()) {
            return ClientTextUtil.splitLinesByNewLine((Component)ClientTextUtil.getItemTooltip(stack).m_130948_(TextStyles.LORE));
        }
        return List.of(ClientTextUtil.pressButtonTo(CTRL_KEY_TEXT.m_6879_(), SHOW_INFO).m_130948_(TextStyles.LORE));
    }

    public static boolean showExtraInfo(List<Component> tooltip) {
        boolean flag = Screen.m_96639_();
        if (!flag) {
            tooltip.add((Component)ClientTextUtil.pressButtonTo(ALT_KEY_TEXT.m_6879_(), SHOW_INFO).m_130948_(TextStyles.LORE));
        }
        return flag;
    }

    public static MutableComponent pressButtonTo(MutableComponent key, Object action) {
        return ComponentUtil.translatable(TextComponentUtil.getTranslationKey("tooltip", "press_button_to"), key.m_130948_(TextStyles.KEYBOARD_INPUT), action);
    }

    public static MutableComponent getAltKey() {
        return ALT_KEY_TEXT.m_6879_();
    }

    public static MutableComponent getCtrlKey() {
        return CTRL_KEY_TEXT.m_6879_();
    }

    public static MutableComponent getShiftKey() {
        return SHIFT_KEY_TEXT.m_6879_();
    }

    public static MutableComponent getRightMouseKey() {
        return RIGHT_MOUSE_KEY_TEXT.m_6879_();
    }

    public static MutableComponent getDefaultKey() {
        return ComponentUtil.keybind(ClientSetupHandler.ITEM_DEFAULT_KEY_BINDING);
    }

    public static String tryToGetPlayerNameOnClientSide(UUID uuid) {
        Player player;
        if (Minecraft.m_91087_().f_91073_ != null && (player = Minecraft.m_91087_().f_91073_.m_46003_(uuid)) != null) {
            return player.m_36316_().getName();
        }
        return uuid.toString();
    }

    public static List<Component> splitLinesByNewLine(Component component) {
        Locale locale = Minecraft.m_91087_().getLocale();
        String text = component.getString();
        Style style = component.m_7383_();
        return ComponentUtil.splitLines(locale, text, style);
    }

    public static List<Component> splitLinesByNewLine(String text, Style style) {
        Locale locale = Minecraft.m_91087_().getLocale();
        return ComponentUtil.splitLines(locale, text, style);
    }

    public static List<Component> splitLines(Component component, int maxLength) {
        Locale locale = Minecraft.m_91087_().getLocale();
        String text = component.getString();
        Style style = component.m_7383_();
        return ComponentUtil.splitLines(locale, text, maxLength, style);
    }

    public static List<Component> splitLines(String text, int maxLength, Style style) {
        Locale locale = Minecraft.m_91087_().getLocale();
        return ComponentUtil.splitLines(locale, text, maxLength, style);
    }

    public static String format(String format, Object ... objects) {
        return String.format(Minecraft.m_91087_().getLocale(), format, objects);
    }

    private static void setDFPattern(String pattern) {
        Locale locale = Minecraft.m_91087_().getLocale();
        if (decimalFormat == null || !pattern.equals(prevPattern) || !locale.equals(prevLocale)) {
            decimalFormat = new DecimalFormat(pattern, DecimalFormatSymbols.getInstance(locale));
            prevPattern = pattern;
            prevLocale = locale;
        }
    }

    public static String formatNumber(String pattern, double value) {
        ClientTextUtil.setDFPattern(pattern);
        return decimalFormat.format(value);
    }

    public static DecimalFormat getDecimalFormatter(String pattern) {
        ClientTextUtil.setDFPattern(pattern);
        return decimalFormat;
    }
}

