/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.crafting.recipe;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.crafting.recipe.IngredientStack;
import com.github.elenterius.biomancy.crafting.recipe.RecipeUtil;
import com.github.elenterius.biomancy.init.ModBioForgeTabs;
import com.github.elenterius.biomancy.init.ModItems;
import com.github.elenterius.biomancy.init.ModRecipes;
import com.github.elenterius.biomancy.menu.BioForgeTab;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class BioForgeRecipe
implements Recipe<Container> {
    public static final byte DEFAULT_CRAFTING_COST_NUTRIENTS = 1;
    public static final int MAX_INGREDIENTS = 5;
    private final ResourceLocation registryKey;
    private final BioForgeTab tab;
    private final List<IngredientStack> ingredients;
    private final ItemStack result;
    private final NonNullList<Ingredient> vanillaIngredients;
    private final int cost;

    public BioForgeRecipe(ResourceLocation id, BioForgeTab tab, ItemStack result, List<IngredientStack> ingredients, int craftingCostNutrients) {
        this.registryKey = id;
        this.tab = tab;
        this.result = result;
        this.ingredients = ingredients;
        List<Ingredient> flatIngredients = RecipeUtil.flattenIngredientStacks(ingredients);
        this.vanillaIngredients = NonNullList.m_182647_((int)flatIngredients.size());
        this.vanillaIngredients.addAll(flatIngredients);
        this.cost = craftingCostNutrients;
    }

    public static boolean areRecipesEqual(BioForgeRecipe recipeA, BioForgeRecipe recipeB) {
        return recipeA.isRecipeEqual(recipeB);
    }

    public ResourceLocation m_6423_() {
        return this.registryKey;
    }

    public int getCraftingCostNutrients() {
        return this.cost;
    }

    public boolean isRecipeEqual(BioForgeRecipe other) {
        return this.registryKey.equals((Object)other.m_6423_());
    }

    public boolean isCraftable(StackedContents itemCounter) {
        for (IngredientStack ingredientStack : this.ingredients) {
            if (ingredientStack.hasSufficientCount(itemCounter)) continue;
            return false;
        }
        return true;
    }

    public boolean m_5818_(Container inv, Level level) {
        int[] countedIngredients = new int[this.ingredients.size()];
        block0: for (int idx = 0; idx < inv.m_6643_(); ++idx) {
            ItemStack stack = inv.m_8020_(idx);
            if (stack.m_41619_()) continue;
            for (int i = 0; i < this.ingredients.size(); ++i) {
                if (!this.ingredients.get(i).testItem(stack)) continue;
                int n = i;
                countedIngredients[n] = countedIngredients[n] + stack.m_41613_();
                continue block0;
            }
        }
        for (int i = 0; i < this.ingredients.size(); ++i) {
            if (countedIngredients[i] >= this.ingredients.get(i).count()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 0;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.vanillaIngredients;
    }

    public List<IngredientStack> getIngredientQuantities() {
        return this.ingredients;
    }

    public BioForgeTab getTab() {
        return this.tab;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.BIO_FORGING_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipes.BIO_FORGING_RECIPE_TYPE.get();
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModItems.BIO_FORGE.get());
    }

    public static class Serializer
    implements RecipeSerializer<BioForgeRecipe> {
        public BioForgeRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            List<IngredientStack> ingredients = RecipeUtil.readIngredientStacks(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for recipe");
            }
            if (ingredients.size() > 5) {
                throw new JsonParseException("Too many ingredients for recipe. The maximum is 5");
            }
            ItemStack resultStack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            int cost = GsonHelper.m_13824_((JsonObject)json, (String)"nutrientsCost", (int)1);
            BioForgeTab tab = BioForgeTab.fromJson(json);
            if (tab == null) {
                String tabId = BioForgeTab.getTabId(json);
                if (tabId.equals("biomancy:weapons")) {
                    tab = (BioForgeTab)ModBioForgeTabs.TOOLS.get();
                    BiomancyMod.LOGGER.warn("Recipe {} uses the deprecated \"biomancy:weapons\" bio-forge tab instead of \"biomancy:tools\". Using \"biomancy:tools\" fallback, please update your recipe.", (Object)recipeId);
                } else {
                    throw new JsonSyntaxException("Unknown Bio-Forge tab '%s'".formatted(tabId));
                }
            }
            return new BioForgeRecipe(recipeId, tab, resultStack, ingredients, cost);
        }

        @Nullable
        public BioForgeRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ItemStack resultStack = buffer.m_130267_();
            int ingredientCount = buffer.m_130242_();
            ArrayList<IngredientStack> ingredients = new ArrayList<IngredientStack>();
            for (int i = 0; i < ingredientCount; ++i) {
                ingredients.add(IngredientStack.fromNetwork(buffer));
            }
            int craftingCost = buffer.m_130242_();
            BioForgeTab tab = BioForgeTab.fromNetwork(buffer);
            return new BioForgeRecipe(recipeId, tab, resultStack, ingredients, craftingCost);
        }

        public void toNetwork(FriendlyByteBuf buffer, BioForgeRecipe recipe) {
            buffer.m_130055_(recipe.result);
            buffer.m_130130_(recipe.ingredients.size());
            for (IngredientStack ingredientStack : recipe.ingredients) {
                ingredientStack.toNetwork(buffer);
            }
            buffer.m_130130_(recipe.getCraftingCostNutrients());
            recipe.tab.toNetwork(buffer);
        }
    }
}

