/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.crafting.recipe;

import com.github.elenterius.biomancy.crafting.recipe.IngredientStack;
import com.github.elenterius.biomancy.crafting.recipe.VariableProductionOutput;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.IdMap;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public final class RecipeUtil {
    private RecipeUtil() {
    }

    public static void writeItem(FriendlyByteBuf buffer, @Nullable Item item) {
        if (item == null || item == Items.f_41852_) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.m_236818_((IdMap)BuiltInRegistries.f_257033_, (Object)item);
        }
    }

    @Nullable
    public static Item readItem(FriendlyByteBuf buffer) {
        return !buffer.readBoolean() ? null : (Item)buffer.m_236816_((IdMap)BuiltInRegistries.f_257033_);
    }

    public static Ingredient readIngredient(JsonObject json, String memberName) {
        return Ingredient.m_43917_((JsonElement)(GsonHelper.m_13885_((JsonObject)json, (String)memberName) ? GsonHelper.m_13933_((JsonObject)json, (String)memberName) : GsonHelper.m_13930_((JsonObject)json, (String)memberName)));
    }

    public static NonNullList<Ingredient> readIngredients(JsonArray jsonArray) {
        NonNullList list = NonNullList.m_122779_();
        for (int i = 0; i < jsonArray.size(); ++i) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonArray.get(i));
            if (ingredient.m_43947_()) continue;
            list.add((Object)ingredient);
        }
        return list;
    }

    public static List<VariableProductionOutput> readVariableProductionOutputs(JsonArray jsonArray) {
        ArrayList<VariableProductionOutput> list = new ArrayList<VariableProductionOutput>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            list.add(VariableProductionOutput.deserialize(jsonArray.get(i).getAsJsonObject()));
        }
        return list;
    }

    public static List<IngredientStack> readIngredientStacks(JsonArray jsonArray) {
        ArrayList<IngredientStack> list = new ArrayList<IngredientStack>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            IngredientStack ingredientStack = IngredientStack.fromJson(jsonArray.get(i).getAsJsonObject());
            if (ingredientStack.ingredient().m_43947_()) continue;
            list.add(ingredientStack);
        }
        return list;
    }

    public static List<Ingredient> flattenIngredientStacks(List<IngredientStack> ingredients) {
        ArrayList<Ingredient> flatIngredients = new ArrayList<Ingredient>();
        for (IngredientStack ingredientStack : ingredients) {
            Ingredient ingredient = ingredientStack.ingredient();
            for (int i = 0; i < ingredientStack.count(); ++i) {
                flatIngredients.add(ingredient);
            }
        }
        return flatIngredients;
    }
}

