/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.crafting.recipe;

import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SimpleRecipeType<T extends Recipe<?>>
implements RecipeType<T> {
    private final String identifier;

    public SimpleRecipeType(String identifier) {
        this.identifier = identifier;
    }

    public String getId() {
        return this.identifier;
    }

    public String toString() {
        return this.identifier;
    }

    public static class ItemStackRecipeType<R extends Recipe<Container>>
    extends SimpleRecipeType<R> {
        public ItemStackRecipeType(String identifier) {
            super(identifier);
        }

        public Optional<R> getRecipeById(Level level, ResourceLocation id) {
            RecipeManager recipeManager = level.m_7465_();
            return Optional.ofNullable(this.castRecipe((Recipe<Container>)((Recipe)recipeManager.m_44054_((RecipeType)this).get(id))));
        }

        public Optional<R> getRecipeFromContainer(Level level, Container inputInventory) {
            RecipeManager recipeManager = level.m_7465_();
            return recipeManager.m_44015_((RecipeType)this, inputInventory, level);
        }

        @Nullable
        private R castRecipe(@Nullable Recipe<Container> recipe) {
            return (R)recipe;
        }

        public Optional<R> getRecipeForIngredient(Level level, ItemStack stack) {
            RecipeManager recipeManager = level.m_7465_();
            return recipeManager.m_44054_((RecipeType)this).values().stream().filter(recipe -> {
                for (Ingredient ingredient : recipe.m_7527_()) {
                    if (!ingredient.test(stack)) continue;
                    return true;
                }
                return false;
            }).findFirst().map(this::castRecipe);
        }
    }
}

