/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.datagen.recipes.builder;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.crafting.recipe.IngredientStack;
import com.github.elenterius.biomancy.crafting.recipe.ItemCountRange;
import com.github.elenterius.biomancy.crafting.recipe.VariableProductionOutput;
import com.github.elenterius.biomancy.datagen.recipes.builder.DatagenIngredient;
import com.github.elenterius.biomancy.datagen.recipes.builder.RecipeBuilder;
import com.github.elenterius.biomancy.datagen.recipes.builder.RecipeCostUtil;
import com.github.elenterius.biomancy.init.ModItems;
import com.github.elenterius.biomancy.init.ModRecipes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.ConditionalAdvancement;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public final class DecomposerRecipeBuilder
implements RecipeBuilder {
    public static final String RECIPE_SUB_FOLDER = ModRecipes.DECOMPOSING_RECIPE_TYPE.getId().m_135815_();
    public static final String SUFFIX = "_decomposing";
    private final List<VariableProductionOutput> outputs = new ArrayList<VariableProductionOutput>();
    private final Advancement.Builder advancement = Advancement.Builder.m_285878_();
    private final List<ICondition> conditions = new ArrayList<ICondition>();
    private ResourceLocation recipeId = BiomancyMod.createRL("unknown");
    private IngredientStack ingredientStack = null;
    private int craftingTimeTicks = -1;
    private int craftingCostNutrients = -1;
    @Nullable
    private String group;

    private DecomposerRecipeBuilder() {
    }

    public static DecomposerRecipeBuilder create() {
        return new DecomposerRecipeBuilder();
    }

    private static ResourceLocation getRegistryKey(ItemLike itemLike) {
        return Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)itemLike.m_5456_()));
    }

    public DecomposerRecipeBuilder ifModLoaded(String modId) {
        return this.withCondition((ICondition)new ModLoadedCondition(modId));
    }

    public DecomposerRecipeBuilder ifModMissing(String modId) {
        return this.withCondition((ICondition)new NotCondition((ICondition)new ModLoadedCondition(modId)));
    }

    public DecomposerRecipeBuilder withCondition(ICondition condition) {
        this.conditions.add(condition);
        return this;
    }

    public DecomposerRecipeBuilder setCraftingTime(int time) {
        if (time < 0) {
            throw new IllegalArgumentException("Invalid crafting time: " + time);
        }
        this.craftingTimeTicks = time;
        return this;
    }

    public DecomposerRecipeBuilder setCraftingCost(int costNutrients) {
        if (costNutrients < 0) {
            throw new IllegalArgumentException("Invalid crafting cost: " + costNutrients);
        }
        this.craftingCostNutrients = costNutrients;
        return this;
    }

    public DecomposerRecipeBuilder setIngredient(TagKey<Item> tagKey) {
        return this.setIngredient(tagKey, 1);
    }

    public DecomposerRecipeBuilder setIngredient(TagKey<Item> tagKey, int quantity) {
        return this.setIngredient(Ingredient.m_204132_(tagKey), quantity, BiomancyMod.createRL(tagKey.f_203868_().m_179910_() + SUFFIX));
    }

    public DecomposerRecipeBuilder setIngredient(RegistryObject<? extends Item> itemHolder) {
        return this.setIngredient((ItemLike)itemHolder.get(), 1);
    }

    public DecomposerRecipeBuilder setIngredient(ItemLike itemIn) {
        return this.setIngredient(itemIn, 1);
    }

    public DecomposerRecipeBuilder setIngredient(Ingredient ingredient, ResourceLocation recipeId) {
        return this.setIngredient(ingredient, 1, recipeId);
    }

    public DecomposerRecipeBuilder setIngredient(ItemLike itemLike, int quantity) {
        this.setIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike}), quantity, BiomancyMod.createRL(DecomposerRecipeBuilder.getRegistryKey(itemLike).m_135815_() + SUFFIX));
        return this;
    }

    public DecomposerRecipeBuilder setIngredient(DatagenIngredient ingredient) {
        this.setIngredient(ingredient, 1, BiomancyMod.createRL(ingredient.resourceLocation.m_135827_() + "_" + ingredient.resourceLocation.m_135815_() + SUFFIX));
        return this;
    }

    public DecomposerRecipeBuilder setIngredient(Ingredient ingredient, int count, ResourceLocation recipeId) {
        if (this.ingredientStack != null) {
            throw new IllegalStateException("Ingredient is already set");
        }
        this.ingredientStack = new IngredientStack(ingredient, count);
        this.recipeId = new ResourceLocation(recipeId.m_135827_(), RECIPE_SUB_FOLDER + "/" + recipeId.m_135815_());
        return this;
    }

    public DecomposerRecipeBuilder addOutput(ItemLike resultIn) {
        return this.addOutput(resultIn, 1);
    }

    public DecomposerRecipeBuilder addOutput(ItemLike resultIn, int count) {
        return this.addOutput(new VariableProductionOutput(resultIn, count));
    }

    public DecomposerRecipeBuilder addOutput(ItemLike resultIn, int min, int max) {
        return this.addOutput(new VariableProductionOutput(resultIn, min, max));
    }

    public DecomposerRecipeBuilder addOutput(VariableProductionOutput output) {
        this.outputs.add(output);
        return this;
    }

    public DecomposerRecipeBuilder addOutputs(VariableProductionOutput ... outputsIn) {
        this.outputs.addAll(Arrays.asList(outputsIn));
        return this;
    }

    @Override
    public DecomposerRecipeBuilder unlockedBy(String name, CriterionTriggerInstance criterionTrigger) {
        this.advancement.m_138386_(name, criterionTrigger);
        return this;
    }

    public DecomposerRecipeBuilder setGroup(@Nullable String name) {
        this.group = name;
        return this;
    }

    @Override
    public void save(Consumer<FinishedRecipe> consumer, @Nullable RecipeCategory category) {
        this.validate();
        if (this.craftingTimeTicks < 0) {
            this.craftingTimeTicks = CraftingTimeUtil.getTotalTicks(this.outputs);
        }
        if (this.craftingCostNutrients < 0) {
            this.craftingCostNutrients = RecipeCostUtil.getCost(1, this.craftingTimeTicks);
        }
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)this.recipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)this.recipeId)).m_138360_(RequirementsStrategy.f_15979_);
        String folderName = RecipeBuilder.getRecipeFolderName(category, "biomancy");
        ResourceLocation advancementId = new ResourceLocation(this.recipeId.m_135827_(), "recipes/%s/%s".formatted(folderName, this.recipeId.m_135815_()));
        consumer.accept(new RecipeResult(this, advancementId));
    }

    private void validate() {
        if (this.recipeId.m_135815_().equals("unknown")) {
            throw new IllegalStateException("Invalid recipe id: " + this.recipeId);
        }
        if (this.ingredientStack == null) {
            throw new IllegalStateException("No Ingredient was provided.");
        }
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe %s because Criteria are empty.".formatted(this.recipeId));
        }
    }

    public static class CraftingTimeUtil {
        static final Map<Item, Float> TICK_MULTIPLIERS = new HashMap<Item, Float>();
        static final float BASE_TICKS = 20.0f;

        private CraftingTimeUtil() {
        }

        public static float getTicks(Item item, int maxAmount) {
            return 20.0f * TICK_MULTIPLIERS.getOrDefault(item, Float.valueOf(1.0f)).floatValue() * (float)Math.max(1, maxAmount);
        }

        public static int getTotalTicks(List<VariableProductionOutput> outputs) {
            float ticks = 0.0f;
            for (VariableProductionOutput output : outputs) {
                ticks += CraftingTimeUtil.getTicks(output.getItem(), CraftingTimeUtil.getMaxAmount(output));
            }
            return Math.round(ticks);
        }

        static int getMaxAmount(VariableProductionOutput output) {
            ItemCountRange countRange = output.getCountRange();
            if (countRange instanceof ItemCountRange.UniformRange) {
                ItemCountRange.UniformRange uniform = (ItemCountRange.UniformRange)countRange;
                return uniform.max();
            }
            if (countRange instanceof ItemCountRange.ConstantValue) {
                ItemCountRange.ConstantValue constant = (ItemCountRange.ConstantValue)countRange;
                return constant.value();
            }
            if (countRange instanceof ItemCountRange.BinomialRange) {
                ItemCountRange.BinomialRange binomialRange = (ItemCountRange.BinomialRange)countRange;
                return binomialRange.n();
            }
            return 1;
        }

        static {
            TICK_MULTIPLIERS.put((Item)ModItems.FLESH_BITS.get(), Float.valueOf(0.9f));
            TICK_MULTIPLIERS.put((Item)ModItems.BONE_FRAGMENTS.get(), Float.valueOf(1.25f));
            TICK_MULTIPLIERS.put((Item)ModItems.TOUGH_FIBERS.get(), Float.valueOf(1.5f));
            TICK_MULTIPLIERS.put((Item)ModItems.ELASTIC_FIBERS.get(), Float.valueOf(0.5f));
            TICK_MULTIPLIERS.put((Item)ModItems.STONE_POWDER.get(), Float.valueOf(1.5f));
            TICK_MULTIPLIERS.put((Item)ModItems.MINERAL_FRAGMENT.get(), Float.valueOf(2.0f));
            TICK_MULTIPLIERS.put((Item)ModItems.GEM_FRAGMENTS.get(), Float.valueOf(2.5f));
            TICK_MULTIPLIERS.put((Item)ModItems.EXOTIC_DUST.get(), Float.valueOf(2.5f));
            TICK_MULTIPLIERS.put((Item)ModItems.BIO_LUMENS.get(), Float.valueOf(1.1f));
            TICK_MULTIPLIERS.put((Item)ModItems.BILE.get(), Float.valueOf(1.0f));
            TICK_MULTIPLIERS.put((Item)ModItems.TOXIN_EXTRACT.get(), Float.valueOf(1.0f));
            TICK_MULTIPLIERS.put((Item)ModItems.VOLATILE_FLUID.get(), Float.valueOf(1.25f));
            TICK_MULTIPLIERS.put((Item)ModItems.HORMONE_SECRETION.get(), Float.valueOf(1.0f));
            TICK_MULTIPLIERS.put((Item)ModItems.WITHERING_OOZE.get(), Float.valueOf(1.25f));
            TICK_MULTIPLIERS.put((Item)ModItems.REGENERATIVE_FLUID.get(), Float.valueOf(1.75f));
        }
    }

    public static class RecipeResult
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final IngredientStack ingredientStack;
        private final List<VariableProductionOutput> outputs;
        private final int craftingTime;
        private final int craftingCost;
        private final List<ICondition> conditions;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementId;

        public RecipeResult(DecomposerRecipeBuilder builder, ResourceLocation advancementId) {
            this.id = builder.recipeId;
            this.group = builder.group == null ? "" : builder.group;
            this.ingredientStack = builder.ingredientStack;
            this.craftingTime = builder.craftingTimeTicks;
            this.craftingCost = builder.craftingCostNutrients;
            this.outputs = builder.outputs;
            this.conditions = builder.conditions;
            this.advancementBuilder = builder.advancement;
            this.advancementId = advancementId;
        }

        public void m_7917_(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.add("ingredient", (JsonElement)this.ingredientStack.toJson());
            JsonArray jsonArray = new JsonArray();
            for (VariableProductionOutput output : this.outputs) {
                jsonArray.add((JsonElement)output.serialize());
            }
            json.add("results", (JsonElement)jsonArray);
            json.addProperty("processingTime", (Number)this.craftingTime);
            json.addProperty("nutrientsCost", (Number)this.craftingCost);
            if (!this.conditions.isEmpty()) {
                JsonArray array = new JsonArray();
                this.conditions.forEach(c -> array.add((JsonElement)CraftingHelper.serialize((ICondition)c)));
                json.add("conditions", (JsonElement)array);
            }
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipes.DECOMPOSING_SERIALIZER.get();
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            if (this.conditions.isEmpty()) {
                return this.advancementBuilder.m_138400_();
            }
            ConditionalAdvancement.Builder conditionalBuilder = ConditionalAdvancement.builder();
            this.conditions.forEach(arg_0 -> ((ConditionalAdvancement.Builder)conditionalBuilder).addCondition(arg_0));
            conditionalBuilder.addAdvancement(this.advancementBuilder);
            return conditionalBuilder.write();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

