/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.datagen.recipes.builder;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.datagen.recipes.builder.ItemData;
import com.github.elenterius.biomancy.datagen.recipes.builder.RecipeBuilder;
import com.github.elenterius.biomancy.datagen.recipes.builder.RecipeCostUtil;
import com.github.elenterius.biomancy.init.ModItems;
import com.github.elenterius.biomancy.init.ModRecipes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.ConditionalAdvancement;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;

public final class DigesterRecipeBuilder
implements RecipeBuilder {
    public static final String RECIPE_SUB_FOLDER = ModRecipes.DIGESTING_RECIPE_TYPE.getId().m_135815_();
    public static final String SUFFIX = "_from_" + RECIPE_SUB_FOLDER;
    public static final short DEFAULT_CRAFTING_COST_NUTRIENTS = 1;
    private final ResourceLocation recipeId;
    private final List<ICondition> conditions = new ArrayList<ICondition>();
    private final ItemData recipeResult;
    private final Advancement.Builder advancement = Advancement.Builder.m_285878_();
    private Ingredient recipeIngredient;
    private int craftingTimeTicks = -1;
    private int craftingCostNutrients = -1;
    @Nullable
    private String group;

    private DigesterRecipeBuilder(ResourceLocation recipeId, ItemData result) {
        this.recipeId = new ResourceLocation(recipeId.m_135827_(), RECIPE_SUB_FOLDER + "/" + recipeId.m_135815_());
        this.recipeResult = result;
        if (this.recipeResult.getRegistryName().equals((Object)ModItems.NUTRIENT_PASTE.getId())) {
            this.craftingTimeTicks = Mth.m_14165_((double)(200.0 + 190.0 * Math.log(this.recipeResult.getCount())));
        } else if (this.recipeResult.getRegistryName().equals((Object)ModItems.NUTRIENT_BAR.getId())) {
            this.craftingTimeTicks = Mth.m_14165_((double)(200.0 + 190.0 * Math.log((double)this.recipeResult.getCount() * 9.0)));
        }
    }

    public static DigesterRecipeBuilder create(ResourceLocation recipeId, ItemData result) {
        return new DigesterRecipeBuilder(recipeId, result);
    }

    public static DigesterRecipeBuilder create(String modId, String outputName, ItemData result) {
        ResourceLocation rl = new ResourceLocation(modId, outputName + SUFFIX);
        return new DigesterRecipeBuilder(rl, result);
    }

    public static DigesterRecipeBuilder create(String outputName, ItemData result) {
        ResourceLocation rl = BiomancyMod.createRL(outputName + SUFFIX);
        return new DigesterRecipeBuilder(rl, result);
    }

    public static DigesterRecipeBuilder create(ItemData result) {
        ResourceLocation rl = BiomancyMod.createRL(result.getItemPath() + SUFFIX);
        return new DigesterRecipeBuilder(rl, result);
    }

    public static DigesterRecipeBuilder create(ItemData result, String postSuffix) {
        ResourceLocation rl = BiomancyMod.createRL(result.getItemPath() + SUFFIX + "_" + postSuffix);
        return new DigesterRecipeBuilder(rl, result);
    }

    public static DigesterRecipeBuilder create(ItemStack stack) {
        return DigesterRecipeBuilder.create(new ItemData(stack));
    }

    public static DigesterRecipeBuilder create(ItemLike item) {
        return DigesterRecipeBuilder.create(new ItemData(item));
    }

    public static DigesterRecipeBuilder create(ItemLike item, int count) {
        return DigesterRecipeBuilder.create(new ItemData(item, count));
    }

    public static DigesterRecipeBuilder create(ItemLike item, int count, String postSuffix) {
        return DigesterRecipeBuilder.create(new ItemData(item, count), postSuffix);
    }

    public DigesterRecipeBuilder ifModLoaded(String modId) {
        return this.withCondition((ICondition)new ModLoadedCondition(modId));
    }

    public DigesterRecipeBuilder ifModMissing(String modId) {
        return this.withCondition((ICondition)new NotCondition((ICondition)new ModLoadedCondition(modId)));
    }

    public DigesterRecipeBuilder withCondition(ICondition condition) {
        this.conditions.add(condition);
        return this;
    }

    public DigesterRecipeBuilder modifyCraftingTime(IntUnaryOperator func) {
        this.craftingTimeTicks = func.applyAsInt(this.craftingTimeTicks);
        return this;
    }

    public DigesterRecipeBuilder setCraftingCost(int costNutrients) {
        if (costNutrients < 0) {
            throw new IllegalArgumentException("Invalid crafting cost: " + costNutrients);
        }
        this.craftingCostNutrients = costNutrients;
        return this;
    }

    public DigesterRecipeBuilder setIngredient(ItemLike item) {
        return this.setIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public DigesterRecipeBuilder setIngredient(TagKey<Item> tag) {
        return this.setIngredient(Ingredient.m_204132_(tag));
    }

    public DigesterRecipeBuilder setIngredient(ItemStack stack) {
        return this.setIngredient(Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}));
    }

    public DigesterRecipeBuilder setIngredient(Ingredient ingredient) {
        this.recipeIngredient = ingredient;
        return this;
    }

    @Override
    public DigesterRecipeBuilder unlockedBy(String name, CriterionTriggerInstance criterionTrigger) {
        this.advancement.m_138386_(name, criterionTrigger);
        return this;
    }

    public DigesterRecipeBuilder setGroup(@Nullable String name) {
        this.group = name;
        return this;
    }

    @Override
    public void save(Consumer<FinishedRecipe> consumer, @Nullable RecipeCategory category) {
        this.validateCriteria();
        if (this.craftingTimeTicks < 0) {
            throw new IllegalArgumentException("Invalid crafting time: " + this.craftingTimeTicks);
        }
        if (this.craftingCostNutrients < 0) {
            this.craftingCostNutrients = RecipeCostUtil.getCost(1, this.craftingTimeTicks);
        }
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)this.recipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)this.recipeId)).m_138360_(RequirementsStrategy.f_15979_);
        String folderName = RecipeBuilder.getRecipeFolderName(category, "biomancy");
        ResourceLocation advancementId = new ResourceLocation(this.recipeId.m_135827_(), "recipes/%s/%s".formatted(folderName, this.recipeId.m_135815_()));
        consumer.accept(new Result(this, advancementId));
    }

    private void validateCriteria() {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe %s because Criteria are empty.".formatted(this.recipeId));
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final Ingredient ingredient;
        private final ItemData recipeResult;
        private final int craftingTime;
        private final int craftingCost;
        private final List<ICondition> conditions;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementId;

        public Result(DigesterRecipeBuilder builder, ResourceLocation advancementId) {
            this.id = builder.recipeId;
            this.group = builder.group == null ? "" : builder.group;
            this.ingredient = builder.recipeIngredient;
            this.recipeResult = builder.recipeResult;
            this.craftingTime = builder.craftingTimeTicks;
            this.craftingCost = builder.craftingCostNutrients;
            this.conditions = builder.conditions;
            this.advancementBuilder = builder.advancement;
            this.advancementId = advancementId;
        }

        public void m_7917_(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.add("ingredient", this.ingredient.m_43942_());
            json.add("result", (JsonElement)this.recipeResult.toJson());
            json.addProperty("processingTime", (Number)this.craftingTime);
            json.addProperty("nutrientsCost", (Number)this.craftingCost);
            if (!this.conditions.isEmpty()) {
                JsonArray array = new JsonArray();
                this.conditions.forEach(c -> array.add((JsonElement)CraftingHelper.serialize((ICondition)c)));
                json.add("conditions", (JsonElement)array);
            }
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipes.DIGESTING_SERIALIZER.get();
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            if (this.conditions.isEmpty()) {
                return this.advancementBuilder.m_138400_();
            }
            ConditionalAdvancement.Builder conditionalBuilder = ConditionalAdvancement.builder();
            this.conditions.forEach(arg_0 -> ((ConditionalAdvancement.Builder)conditionalBuilder).addCondition(arg_0));
            conditionalBuilder.addAdvancement(this.advancementBuilder);
            return conditionalBuilder.write();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

