/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.datagen.recipes.builder;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface RecipeBuilder {
    public static String getRecipeFolderName(@Nullable RecipeCategory category, String modId) {
        return category != null ? category.m_247710_() : modId;
    }

    private InventoryChangeTrigger.TriggerInstance has(ItemLike itemLike) {
        return this.inventoryTrigger(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{itemLike}).m_45077_());
    }

    private InventoryChangeTrigger.TriggerInstance has(TagKey<Item> tag) {
        return this.inventoryTrigger(ItemPredicate.Builder.m_45068_().m_204145_(tag).m_45077_());
    }

    private InventoryChangeTrigger.TriggerInstance inventoryTrigger(ItemPredicate ... predicates) {
        return new InventoryChangeTrigger.TriggerInstance(ContextAwarePredicate.f_285567_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, predicates);
    }

    private String getItemName(ItemLike itemLike) {
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)itemLike.m_5456_());
        return key != null ? key.m_135815_() : "unknown";
    }

    private String getTagName(TagKey<Item> tag) {
        return tag.f_203868_().m_135815_();
    }

    public RecipeBuilder unlockedBy(String var1, CriterionTriggerInstance var2);

    default public RecipeBuilder unlockedBy(String name, ItemPredicate predicate) {
        return this.unlockedBy(name, (CriterionTriggerInstance)this.inventoryTrigger(predicate));
    }

    default public RecipeBuilder unlockedBy(ItemLike itemLike, CriterionTriggerInstance criterionTrigger) {
        return this.unlockedBy("has_" + this.getItemName(itemLike), criterionTrigger);
    }

    default public RecipeBuilder unlockedBy(ItemLike itemLike) {
        return this.unlockedBy("has_" + this.getItemName(itemLike), (CriterionTriggerInstance)this.has(itemLike));
    }

    default public RecipeBuilder unlockedBy(RegistryObject<? extends Item> itemHolder) {
        Item item = (Item)itemHolder.get();
        return this.unlockedBy("has_" + this.getItemName((ItemLike)item), (CriterionTriggerInstance)this.has((ItemLike)item));
    }

    default public RecipeBuilder unlockedBy(TagKey<Item> tag, CriterionTriggerInstance criterionTrigger) {
        return this.unlockedBy("has_" + this.getTagName(tag), criterionTrigger);
    }

    default public RecipeBuilder unlockedBy(TagKey<Item> tag) {
        return this.unlockedBy("has_" + this.getTagName(tag), (CriterionTriggerInstance)this.has(tag));
    }

    default public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, null);
    }

    public void save(Consumer<FinishedRecipe> var1, @Nullable RecipeCategory var2);
}

