/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.entity.mob;

import com.github.elenterius.biomancy.ownable.OwnableMob;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.Team;

public abstract class OwnablePathfinderMob
extends PathfinderMob
implements OwnableMob {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.m_135353_(OwnablePathfinderMob.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private BlockPos targetBlockPos;

    protected OwnablePathfinderMob(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER_UNIQUE_ID, Optional.empty());
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.getOptionalOwnerUUID().ifPresent(value -> compound.m_128362_("OwnerUUID", value));
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128403_("OwnerUUID")) {
            this.setOwner(compound.m_128342_("OwnerUUID"));
        } else {
            this.removeOwner();
        }
    }

    @Override
    public Optional<UUID> getOptionalOwnerUUID() {
        return (Optional)this.f_19804_.m_135370_(OWNER_UNIQUE_ID);
    }

    @Override
    public void setOwner(UUID uuid) {
        this.f_19804_.m_135381_(OWNER_UNIQUE_ID, Optional.of(uuid));
    }

    @Override
    public void removeOwner() {
        this.f_19804_.m_135381_(OWNER_UNIQUE_ID, Optional.empty());
    }

    @Override
    public Optional<Player> getOwnerAsPlayer() {
        return this.getOptionalOwnerUUID().map(value -> this.m_9236_().m_46003_(value));
    }

    @Override
    public Optional<LivingEntity> getOwnerAsEntity() {
        return this.getOptionalOwnerUUID().map(value -> this.m_9236_().m_46003_(value));
    }

    public Team m_5647_() {
        return this.getOwnerAsPlayer().map(Entity::m_5647_).orElseGet(() -> super.m_5647_());
    }

    public boolean m_7307_(Entity entityIn) {
        Optional<Player> optional = this.getOwnerAsPlayer();
        if (optional.isPresent()) {
            if (optional.get() == entityIn) {
                return true;
            }
            return optional.get().m_7307_(entityIn);
        }
        return super.m_7307_(entityIn);
    }

    public void m_6667_(DamageSource cause) {
        Optional<Player> optional;
        if (!this.m_9236_().f_46443_ && this.m_9236_().m_46469_().m_46207_(GameRules.f_46142_) && (optional = this.getOwnerAsPlayer()).isPresent() && optional.get() instanceof ServerPlayer) {
            optional.get().m_213846_(this.m_21231_().m_19293_());
        }
        super.m_6667_(cause);
    }

    public boolean m_6573_(Player player) {
        return !this.m_21523_() && player == this.getOwnerAsPlayer().orElse(null);
    }

    @Nullable
    public BlockPos getTargetBlockPos() {
        return this.targetBlockPos;
    }

    public void setTargetBlockPos(@Nullable BlockPos targetPos) {
        this.targetBlockPos = targetPos;
    }
}

