/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.entity.mob.ai.goal.controllable;

import com.github.elenterius.biomancy.entity.mob.ControllableMob;
import com.github.elenterius.biomancy.ownable.OwnableMob;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class FollowOwnerGoal<T extends Mob & ControllableMob>
extends Goal {
    private final T entity;
    private LivingEntity entityOwner;
    private final LevelReader world;
    private final double speed;
    private final PathNavigation navigator;
    private final float maxDist;
    private final float minDist;
    private final boolean teleportToLeaves;
    private int pathingDelay;
    private float oldWaterCost;

    public FollowOwnerGoal(T goalOwner, double speedIn, float minDistIn, float maxDistIn, boolean teleportToLeaves) {
        this.entity = goalOwner;
        this.world = goalOwner.m_9236_();
        this.speed = speedIn;
        this.navigator = goalOwner.m_21573_();
        this.minDist = minDistIn;
        this.maxDist = maxDistIn;
        this.teleportToLeaves = teleportToLeaves;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(goalOwner.m_21573_() instanceof GroundPathNavigation) && !(goalOwner.m_21573_() instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean m_8036_() {
        if (!((ControllableMob)this.entity).canExecuteCommand() || ((ControllableMob)this.entity).getActiveCommand() != ControllableMob.Command.DEFEND_OWNER) {
            return false;
        }
        Optional<Player> optional = ((OwnableMob)this.entity).getOwnerAsPlayer();
        if (optional.isPresent()) {
            if (optional.get().m_5833_()) {
                return false;
            }
            if (this.entity.m_20280_((Entity)optional.get()) < (double)(this.minDist * this.minDist)) {
                return false;
            }
            this.entityOwner = (LivingEntity)optional.get();
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        if (!((ControllableMob)this.entity).canExecuteCommand() || ((ControllableMob)this.entity).getActiveCommand() != ControllableMob.Command.DEFEND_OWNER) {
            return false;
        }
        if (this.navigator.m_26571_()) {
            return false;
        }
        return this.entity.m_20280_((Entity)this.entityOwner) > (double)(this.maxDist * this.maxDist);
    }

    public void m_8056_() {
        this.pathingDelay = 0;
        this.oldWaterCost = this.entity.m_21439_(BlockPathTypes.WATER);
        this.entity.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.entityOwner = null;
        this.navigator.m_26573_();
        this.entity.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        this.entity.m_21563_().m_24960_((Entity)this.entityOwner, 10.0f, (float)this.entity.m_8132_());
        if (--this.pathingDelay <= 0) {
            this.pathingDelay = 10;
            if (!this.entity.m_21523_() && !this.entity.m_20159_()) {
                if (this.entity.m_20280_((Entity)this.entityOwner) >= 144.0) {
                    this.tryToTeleportNearEntity();
                    return;
                }
                this.navigator.m_5624_((Entity)this.entityOwner, this.speed);
            }
        }
    }

    private void tryToTeleportNearEntity() {
        BlockPos blockpos = this.entityOwner.m_20183_();
        for (int i = 0; i < 10; ++i) {
            int x = this.getRandomNumber(-3, 3);
            int y = this.getRandomNumber(-1, 1);
            int z = this.getRandomNumber(-3, 3);
            if (!this.tryToTeleportToLocation(blockpos.m_123341_() + x, blockpos.m_123342_() + y, blockpos.m_123343_() + z)) continue;
            return;
        }
    }

    private boolean tryToTeleportToLocation(int x, int y, int z) {
        if (Math.abs((double)x - this.entityOwner.m_20185_()) < 2.0 && Math.abs((double)z - this.entityOwner.m_20189_()) < 2.0) {
            return false;
        }
        if (!this.isTeleportFriendlyBlock(new BlockPos(x, y, z))) {
            return false;
        }
        this.entity.m_7678_((double)x + 0.5, (double)y, (double)z + 0.5, this.entity.m_146908_(), this.entity.m_146909_());
        this.navigator.m_26573_();
        return true;
    }

    private boolean isTeleportFriendlyBlock(BlockPos pos) {
        BlockPathTypes pathTypes = WalkNodeEvaluator.m_77604_((BlockGetter)this.world, (BlockPos.MutableBlockPos)pos.m_122032_());
        if (pathTypes != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockState blockstate = this.world.m_8055_(pos.m_7495_());
        if (!this.teleportToLeaves && blockstate.m_60734_() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = pos.m_121996_((Vec3i)this.entity.m_20183_());
        return this.world.m_45756_(this.entity, this.entity.m_20191_().m_82338_(blockpos));
    }

    private int getRandomNumber(int min, int max) {
        return this.entity.m_217043_().m_188503_(max - min + 1) + min;
    }
}

