/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.entity.mob.fleshblob;

import com.github.elenterius.biomancy.entity.mob.FoodEater;
import com.github.elenterius.biomancy.entity.mob.ai.goal.FindItemGoal;
import com.github.elenterius.biomancy.entity.mob.fleshblob.FleshBlob;
import java.util.function.Predicate;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.keyframe.event.CustomInstructionKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;

public abstract class EaterFleshBlob
extends FleshBlob
implements FoodEater {
    public static final Predicate<ItemEntity> ITEM_ENTITY_FILTER = itemEntity -> FindItemGoal.ITEM_ENTITY_FILTER.test((ItemEntity)itemEntity) && itemEntity.m_32055_().m_41614_();
    protected static final EntityDataAccessor<Boolean> IS_EATING = SynchedEntityData.m_135353_(EaterFleshBlob.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    protected EaterFleshBlob(EntityType<? extends EaterFleshBlob> entityType, Level level) {
        super(entityType, level);
        this.m_21553_(true);
    }

    protected static ItemStack removeOneItemFromItemEntity(ItemEntity itemEntity) {
        ItemStack stack = itemEntity.m_32055_();
        ItemStack splitStack = stack.m_41620_(1);
        if (stack.m_41619_()) {
            itemEntity.m_146870_();
        } else {
            itemEntity.m_32045_(stack);
        }
        return splitStack;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_EATING, (Object)false);
    }

    protected float getFoodHealAmount(@Nullable FoodProperties food) {
        if (food == null) {
            return 0.5f;
        }
        return (float)food.m_38744_() * (food.m_38746_() ? 1.25f : 0.75f);
    }

    protected float getGrowChance(@Nullable FoodProperties food) {
        if (food == null) {
            return 0.4f;
        }
        return 0.4f + (float)food.m_38744_() * (food.m_38746_() ? 0.5f : 0.25f) / 10.0f;
    }

    public boolean m_21531_() {
        return (this.f_19797_ + 1) % 100 == 0 && super.m_21531_();
    }

    public boolean m_7066_(ItemStack stack) {
        if (!this.m_21531_()) {
            return false;
        }
        return this.getFoodItem().m_41619_();
    }

    public boolean m_7252_(ItemStack stack) {
        ItemStack heldStack = this.getFoodItem();
        return stack.m_41614_() && (heldStack.m_41619_() || !heldStack.m_41720_().m_41472_());
    }

    protected void m_7581_(ItemEntity itemEntity) {
        ItemStack stack = itemEntity.m_32055_();
        if (this.m_7252_(stack)) {
            this.m_21053_(itemEntity);
            this.m_7938_((Entity)itemEntity, 1);
            stack = EaterFleshBlob.removeOneItemFromItemEntity(itemEntity);
            ItemStack heldStack = this.getFoodItem();
            if (!heldStack.m_41619_()) {
                this.m_19983_(heldStack);
            }
            this.setFoodItem(stack);
        }
    }

    @Override
    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.m_7252_(stack)) {
            if (this.m_9236_().f_46443_) {
                return InteractionResult.CONSUME;
            }
            ItemStack heldStack = this.getFoodItem();
            if (!heldStack.m_41619_()) {
                this.m_19983_(heldStack);
            }
            this.setFoodItem(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11912_, this.m_5720_(), 0.75f + 0.25f * (float)this.f_19796_.m_188503_(2), (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            }
            this.m_146852_(GameEvent.f_157806_, (Entity)this);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public boolean isEating() {
        return (Boolean)this.f_19804_.m_135370_(IS_EATING);
    }

    @Override
    public void setEating(boolean flag) {
        this.f_19804_.m_135381_(IS_EATING, (Object)flag);
    }

    @Override
    public void ate(@Nullable FoodProperties food) {
        float health = this.m_21223_();
        if (health < this.m_21233_()) {
            this.m_5634_(this.getFoodHealAmount(food));
        } else {
            byte blobSize = this.getBlobSize();
            if (blobSize < 10 && this.f_19796_.m_188501_() < this.getGrowChance(food)) {
                this.setBlobSize((byte)(blobSize + 1), true);
            }
        }
    }

    @Override
    public ItemStack getFoodItem() {
        return this.m_6844_(EquipmentSlot.MAINHAND);
    }

    @Override
    public void setFoodItem(ItemStack stack) {
        this.m_8061_(EquipmentSlot.MAINHAND, stack);
        this.m_21508_(EquipmentSlot.MAINHAND);
    }

    protected void spawnEatingParticles(ItemStack stack) {
        float pitch = -this.m_146909_() * ((float)Math.PI / 180);
        float yaw = -this.m_146908_() * ((float)Math.PI / 180);
        double radius = (double)this.m_6972_((Pose)this.m_20089_()).f_20377_ / 2.0;
        double x = this.m_20185_() + this.m_20154_().f_82479_ * radius;
        double y = this.m_20186_();
        double z = this.m_20189_() + this.m_20154_().f_82481_ * radius;
        for (int i = 0; i < 8; ++i) {
            Vec3 motion = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.1, (double)this.f_19796_.m_188501_() * 0.1 + 0.15, 0.0).m_82496_(pitch).m_82524_(yaw);
            this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), x, y, z, motion.f_82479_, motion.f_82480_, motion.f_82481_);
        }
    }

    protected void playEatingFX() {
        ItemStack stack = this.getFoodItem();
        if (stack.m_41619_()) {
            return;
        }
        if (stack.m_41780_() == UseAnim.DRINK) {
            this.playClientLocalSound(this.m_7838_(stack), 0.75f, this.m_9236_().f_46441_.m_188501_() * 0.1f + 0.9f);
        }
        if (stack.m_41780_() == UseAnim.EAT) {
            this.spawnEatingParticles(stack);
            SoundEvent eatingSound = this.m_7866_(stack);
            this.playClientLocalSound(eatingSound, 0.75f + 0.25f * (float)this.f_19796_.m_188503_(2), (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
        }
    }

    private void playClientLocalSound(SoundEvent soundEvent, float volume, float pitch) {
        if (!this.m_20067_()) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), soundEvent, this.m_5720_(), volume, pitch, false);
        }
    }

    protected <T extends EaterFleshBlob> PlayState handleEatingAnimation(AnimationState<T> event) {
        if (this.isEating()) {
            event.getController().setAnimation(EATING_ANIMATION);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    protected <E extends EaterFleshBlob> void onEatingSfx(CustomInstructionKeyframeEvent<E> event) {
        if (event.getKeyframeData().getInstructions().equals("eating_fx;")) {
            this.playEatingFX();
        }
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        super.registerControllers(controllers);
        AnimationController controller = new AnimationController((GeoAnimatable)this, "eat", 4, this::handleEatingAnimation);
        controller.setCustomInstructionKeyframeHandler(this::onEatingSfx);
        controllers.add(new AnimationController[]{controller});
    }
}

