/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.entity.mob.fleshblob;

import com.github.elenterius.biomancy.entity.mob.PrimordialCradleUser;
import com.github.elenterius.biomancy.entity.mob.PrimordialFleshkin;
import com.github.elenterius.biomancy.entity.mob.ai.goal.BurningOrFreezingPanicGoal;
import com.github.elenterius.biomancy.entity.mob.ai.goal.DanceNearJukeboxGoal;
import com.github.elenterius.biomancy.entity.mob.ai.goal.EatFoodItemGoal;
import com.github.elenterius.biomancy.entity.mob.ai.goal.FindItemGoal;
import com.github.elenterius.biomancy.entity.mob.ai.goal.UsePrimordialCradleGoal;
import com.github.elenterius.biomancy.entity.mob.fleshblob.EaterFleshBlob;
import com.github.elenterius.biomancy.entity.mob.fleshblob.FleshBlobSpawnData;
import com.github.elenterius.biomancy.init.ModMobEffects;
import com.github.elenterius.biomancy.util.MobUtil;
import com.github.elenterius.biomancy.world.PrimordialEcosystem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class PrimordialEaterFleshBlob
extends EaterFleshBlob
implements PrimordialFleshkin,
PrimordialCradleUser {
    public static final float BASE_MAX_HEALTH = 15.0f;
    public static final float BASE_ARMOR = 1.0f;

    public PrimordialEaterFleshBlob(EntityType<? extends PrimordialEaterFleshBlob> entityType, Level level) {
        super((EntityType<? extends EaterFleshBlob>)entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22284_, 1.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    @Override
    protected void updateBaseAttributes(byte size) {
        MobUtil.setAttributeBaseValue((LivingEntity)this, Attributes.f_22276_, (float)size * 15.0f);
        MobUtil.setAttributeBaseValue((LivingEntity)this, Attributes.f_22279_, 0.2f + 0.01f * (float)size);
        MobUtil.setAttributeBaseValue((LivingEntity)this, Attributes.f_22284_, (float)size * 1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new BurningOrFreezingPanicGoal(this, 1.5));
        this.f_21345_.m_25352_(3, (Goal)new FindItemGoal((Mob)this, 12.0f, SPECIAL_ITEM_ENTITY_FILTER));
        this.f_21345_.m_25352_(3, new EatFoodItemGoal<PrimordialEaterFleshBlob>(this, 0.05f));
        this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, AbstractGolem.class, 6.0f, (double)0.8f, (double)1.2f));
        this.f_21345_.m_25352_(4, new UsePrimordialCradleGoal<PrimordialEaterFleshBlob>(this));
        this.f_21345_.m_25352_(5, new DanceNearJukeboxGoal<PrimordialEaterFleshBlob>(this));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        if (!(spawnData instanceof FleshBlobSpawnData)) {
            spawnData = new FleshBlobSpawnData.Tumors(0);
        }
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    @Override
    public ItemStack getTributeItemForCradle() {
        return this.m_6844_(EquipmentSlot.OFFHAND);
    }

    @Override
    public boolean hasTributeForCradle() {
        ItemStack stack = this.getTributeItemForCradle();
        return SPECIAL_ITEMS_TO_HOLD.contains(stack.m_41720_());
    }

    @Override
    public boolean m_7252_(ItemStack stack) {
        if (SPECIAL_ITEMS_TO_HOLD.contains(stack.m_41720_())) {
            return this.m_6844_(EquipmentSlot.OFFHAND).m_41619_();
        }
        return super.m_7252_(stack);
    }

    @Override
    protected void m_7581_(ItemEntity itemEntity) {
        ItemStack stack = itemEntity.m_32055_();
        if (SPECIAL_ITEMS_TO_HOLD.contains(stack.m_41720_()) && this.m_6844_(EquipmentSlot.OFFHAND).m_41619_()) {
            this.m_21053_(itemEntity);
            this.m_8061_(EquipmentSlot.OFFHAND, stack);
            this.m_21508_(EquipmentSlot.OFFHAND);
            this.m_7938_((Entity)itemEntity, stack.m_41613_());
            itemEntity.m_146870_();
        } else {
            super.m_7581_(itemEntity);
        }
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        if (effectInstance.m_19544_() == ModMobEffects.PRIMORDIAL_INFESTATION.get()) {
            return false;
        }
        return super.m_7301_(effectInstance);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        Level level;
        if (reason == Entity.RemovalReason.KILLED && !this.m_9236_().f_46443_ && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.placeMalignantFleshBlocks(serverLevel);
        }
        super.m_142687_(reason);
    }

    protected void placeMalignantFleshBlocks(ServerLevel serverLevel) {
        if (!this.m_21224_()) {
            return;
        }
        if (this.m_203117_() || this.m_6060_()) {
            return;
        }
        BlockPos pos = this.m_20183_();
        if (!PrimordialEcosystem.placeMalignantBlocks(serverLevel, pos, this)) {
            BlockPos relativePos;
            for (int i = 0; i < 4 && !PrimordialEcosystem.placeMalignantBlocks(serverLevel, relativePos = pos.m_121945_(Direction.m_122407_((int)i)), this); ++i) {
            }
        }
    }
}

