/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.init;

import com.github.elenterius.biomancy.block.cauldron.AcidCauldron;
import com.github.elenterius.biomancy.fluid.TintedFluidType;
import com.github.elenterius.biomancy.init.ModBlocks;
import com.github.elenterius.biomancy.init.ModFluids;
import com.github.elenterius.biomancy.init.ModItems;
import com.github.elenterius.biomancy.init.ModPotions;
import com.github.elenterius.biomancy.init.tags.ModBlockTags;
import com.github.elenterius.biomancy.util.CombatUtil;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public final class AcidInteractions {
    public static final Map<Item, CauldronInteraction> ACID_CAULDRON = CauldronInteraction.m_175617_();
    public static final Map<Block, BlockState> NORMAL_TO_ERODED_BLOCK_CONVERSION = Map.of(Blocks.f_50440_, Blocks.f_50493_.m_49966_(), Blocks.f_50652_, Blocks.f_49994_.m_49966_(), Blocks.f_50222_, Blocks.f_50224_.m_49966_(), Blocks.f_152589_, Blocks.f_152594_.m_49966_(), Blocks.f_152559_, Blocks.f_152595_.m_49966_(), Blocks.f_50735_, Blocks.f_50736_.m_49966_(), Blocks.f_50197_, Blocks.f_50713_.m_49966_());

    private AcidInteractions() {
    }

    static void register() {
        AcidInteractions.registerCauldronInteractions();
    }

    private static void registerCauldronInteractions() {
        CauldronInteraction fillWithAcid = (state, level, pos, player, hand, stack) -> {
            SoundEvent sound = Objects.requireNonNullElse(((TintedFluidType)((Object)((Object)ModFluids.ACID_TYPE.get()))).getSound(SoundActions.BUCKET_EMPTY), SoundEvents.f_11778_);
            return CauldronInteraction.m_175618_((Level)level, (BlockPos)pos, (Player)player, (InteractionHand)hand, (ItemStack)stack, (BlockState)((BlockState)((AcidCauldron)((Object)((Object)ModBlocks.ACID_CAULDRON.get()))).m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3))), (SoundEvent)sound);
        };
        CauldronInteraction.f_175606_.put((Item)ModItems.ACID_BUCKET.get(), fillWithAcid);
        CauldronInteraction originalPotionInteraction = Objects.requireNonNull((CauldronInteraction)CauldronInteraction.f_175606_.get(Items.f_42589_));
        CauldronInteraction.f_175606_.put(Items.f_42589_, (state, level, pos, player, hand, stack) -> {
            if (PotionUtils.m_43579_((ItemStack)stack) != ModPotions.GASTRIC_JUICE.get()) {
                return originalPotionInteraction.m_175710_(state, level, pos, player, hand, stack);
            }
            if (!level.f_46443_) {
                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42590_)));
                player.m_36220_(Stats.f_12944_);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                level.m_46597_(pos, ((AcidCauldron)((Object)((Object)ModBlocks.ACID_CAULDRON.get()))).m_49966_());
                level.m_5594_(null, pos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_142346_((Entity)player, GameEvent.f_157769_, pos);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        });
        ACID_CAULDRON.put((Item)ModItems.ACID_BUCKET.get(), fillWithAcid);
        ACID_CAULDRON.put(Items.f_42446_, (state, level, pos, player, hand, stack) -> {
            SoundEvent sound = Objects.requireNonNullElse(((TintedFluidType)((Object)((Object)ModFluids.ACID_TYPE.get()))).getSound(SoundActions.BUCKET_FILL), SoundEvents.f_11781_);
            return CauldronInteraction.m_175635_((BlockState)state, (Level)level, (BlockPos)pos, (Player)player, (InteractionHand)hand, (ItemStack)stack, (ItemStack)((BucketItem)ModItems.ACID_BUCKET.get()).m_7968_(), AcidInteractions::isCauldronFull, (SoundEvent)sound);
        });
        ACID_CAULDRON.put(Items.f_42590_, (state, level, pos, player, hand, stack) -> {
            if (!level.f_46443_) {
                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)((Potion)ModPotions.GASTRIC_JUICE.get()))));
                player.m_36220_(Stats.f_12944_);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                LayeredCauldronBlock.m_153559_((BlockState)state, (Level)level, (BlockPos)pos);
                level.m_5594_(null, pos, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_142346_((Entity)player, GameEvent.f_157816_, pos);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        });
        ACID_CAULDRON.put(Items.f_42589_, (state, level, pos, player, hand, stack) -> {
            if (!AcidInteractions.isCauldronFull(state) && PotionUtils.m_43579_((ItemStack)stack) == ModPotions.GASTRIC_JUICE.get()) {
                if (!level.f_46443_) {
                    player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42590_)));
                    player.m_36220_(Stats.f_12944_);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                    level.m_46597_(pos, (BlockState)state.m_61122_((Property)LayeredCauldronBlock.f_153514_));
                    level.m_5594_(null, pos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.m_142346_((Entity)player, GameEvent.f_157769_, pos);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            return InteractionResult.PASS;
        });
    }

    private static boolean isCauldronFull(BlockState state) {
        return (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3;
    }

    @Nullable
    public static Block convertBlock(Block block) {
        if (block instanceof WeatheringCopper && WeatheringCopper.m_154904_((Block)block).isPresent()) {
            return (Block)WeatheringCopper.m_154904_((Block)block).get();
        }
        if (block.m_204297_().m_203656_(ModBlockTags.ACID_DESTRUCTIBLE)) {
            return Blocks.f_50016_;
        }
        if (NORMAL_TO_ERODED_BLOCK_CONVERSION.containsKey(block)) {
            return NORMAL_TO_ERODED_BLOCK_CONVERSION.get(block).m_60734_();
        }
        return null;
    }

    public static void handleEntityInsideAcidFluid(LivingEntity livingEntity) {
        if (livingEntity.m_5833_()) {
            return;
        }
        if (livingEntity.f_19797_ % 5 != 0) {
            return;
        }
        if (!livingEntity.isInFluidType((FluidType)ModFluids.ACID_TYPE.get())) {
            return;
        }
        AcidInteractions.handleEntityInsideAcid(livingEntity);
    }

    public static void handleEntityInsideAcid(LivingEntity livingEntity) {
        if (!livingEntity.m_9236_().f_46443_) {
            CombatUtil.applyAcidEffect(livingEntity, 4);
        } else if (livingEntity.f_19797_ % 10 == 0 && livingEntity.m_217043_().m_188501_() < 0.4f) {
            Level level = livingEntity.m_9236_();
            RandomSource random = livingEntity.m_217043_();
            Vec3 pos = livingEntity.m_20182_();
            double height = livingEntity.m_20191_().m_82376_() * 0.5;
            level.m_7785_(pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_12031_, SoundSource.BLOCKS, 0.5f, 2.6f + (random.m_188501_() - random.m_188501_()) * 0.8f, false);
            for (int i = 0; i < 4; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, pos.f_82479_ + random.m_188500_(), pos.f_82480_ + random.m_188500_() * height, pos.f_82481_ + random.m_188500_(), 0.0, 0.1, 0.0);
            }
        }
    }
}

