/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.init;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.api.serum.Serum;
import com.github.elenterius.biomancy.init.ModBlockEntities;
import com.github.elenterius.biomancy.init.ModBlocks;
import com.github.elenterius.biomancy.init.ModEntityTypes;
import com.github.elenterius.biomancy.init.ModItems;
import com.github.elenterius.biomancy.init.ModSerums;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.MissingMappingsEvent;

@Mod.EventBusSubscriber(modid="biomancy", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class MigrationHandler {
    private MigrationHandler() {
    }

    @SubscribeEvent
    public static void onMissingMappings(MissingMappingsEvent event) {
        MigrationHandler.handleMissingSerums(event.getMappings(ModSerums.SERUMS.getRegistryKey(), "biomancy"));
        MigrationHandler.handleMissingItems(event.getMappings(ModItems.ITEMS.getRegistryKey(), "biomancy"));
        MigrationHandler.handleMissingBlocks(event.getMappings(ModBlocks.BLOCKS.getRegistryKey(), "biomancy"));
        MigrationHandler.handleMissingBlockEntityTypes(event.getMappings(ForgeRegistries.BLOCK_ENTITY_TYPES.getRegistryKey(), "biomancy"));
        MigrationHandler.handleMissingEntityTypes(event.getMappings(ForgeRegistries.ENTITY_TYPES.getRegistryKey(), "biomancy"));
    }

    private static void handleMissingSerums(List<MissingMappingsEvent.Mapping<Serum>> mappings) {
        if (mappings.isEmpty()) {
            return;
        }
        for (MissingMappingsEvent.Mapping<Serum> mapping : mappings) {
            if (mapping.getKey().m_135815_().equals("growth_serum")) {
                mapping.remap((Object)((Serum)ModSerums.AGEING_SERUM.get()));
                continue;
            }
            mapping.ignore();
        }
    }

    public static void handleMissingBlocks(List<MissingMappingsEvent.Mapping<Block>> mappings) {
        if (mappings.isEmpty()) {
            return;
        }
        BiomancyMod.LOGGER.info("found missing block mappings, attempting to remap...");
        block24: for (MissingMappingsEvent.Mapping<Block> mapping : mappings) {
            String path;
            switch (path = mapping.getKey().m_135815_()) {
                case "bio_lantern": {
                    mapping.remap((Object)((Block)ModBlocks.YELLOW_BIO_LANTERN.get()));
                    continue block24;
                }
                case "bone_spike": {
                    mapping.remap((Object)((Block)ModBlocks.FLESH_SPIKE.get()));
                    continue block24;
                }
                case "creator": {
                    mapping.remap((Object)((Block)ModBlocks.PRIMORDIAL_CRADLE.get()));
                    continue block24;
                }
                case "flesh_block": {
                    mapping.remap((Object)((Block)ModBlocks.FLESH.get()));
                    continue block24;
                }
                case "flesh_block_slab": {
                    mapping.remap((Object)((Block)ModBlocks.FLESH_SLAB.get()));
                    continue block24;
                }
                case "flesh_block_stairs": {
                    mapping.remap((Object)((Block)ModBlocks.FLESH_STAIRS.get()));
                    continue block24;
                }
                case "flesh_irisdoor": {
                    mapping.remap((Object)((Block)ModBlocks.FLESH_IRIS_DOOR.get()));
                    continue block24;
                }
                case "necrotic_flesh_block": {
                    mapping.remap((Object)((Block)ModBlocks.MALIGNANT_FLESH.get()));
                    continue block24;
                }
                case "flesh_tentacle": {
                    mapping.remap((Object)((Block)ModBlocks.MALIGNANT_FLESH_VEINS.get()));
                    continue block24;
                }
                case "corrupted_primal_flesh": {
                    mapping.remap((Object)((Block)ModBlocks.PRIMAL_FLESH.get()));
                    continue block24;
                }
            }
            mapping.ignore();
        }
    }

    private static void handleMissingEntityTypes(List<MissingMappingsEvent.Mapping<EntityType<?>>> mappings) {
        if (mappings.isEmpty()) {
            return;
        }
        BiomancyMod.LOGGER.info("found missing entity mappings, attempting to remap...");
        for (MissingMappingsEvent.Mapping<EntityType<?>> mapping : mappings) {
            String path = mapping.getKey().m_135815_();
            if (path.equals("malignant_flesh_blob")) {
                mapping.remap((Object)((EntityType)ModEntityTypes.PRIMORDIAL_HUNGRY_FLESH_BLOB.get()));
                continue;
            }
            mapping.ignore();
        }
    }

    public static void handleMissingBlockEntityTypes(List<MissingMappingsEvent.Mapping<BlockEntityType<?>>> mappings) {
        if (mappings.isEmpty()) {
            return;
        }
        for (MissingMappingsEvent.Mapping<BlockEntityType<?>> mapping : mappings) {
            String path = mapping.getKey().m_135815_();
            if (path.equals("creator")) {
                mapping.remap((Object)((BlockEntityType)ModBlockEntities.PRIMORDIAL_CRADLE.get()));
                continue;
            }
            mapping.ignore();
        }
    }

    public static void handleMissingItems(List<MissingMappingsEvent.Mapping<Item>> mappings) {
        if (mappings.isEmpty()) {
            return;
        }
        BiomancyMod.LOGGER.info("found missing item mappings, attempting to remap...");
        block55: for (MissingMappingsEvent.Mapping<Item> mapping : mappings) {
            String path;
            switch (path = mapping.getKey().m_135815_()) {
                case "long_claws": {
                    mapping.remap((Object)((Item)ModItems.RAVENOUS_CLAWS.get()));
                    continue block55;
                }
                case "mascot_pattern": 
                case "mascot_outline_pattern": 
                case "mascot_accent_pattern": {
                    mapping.remap((Object)((Item)ModItems.MASCOT_BANNER_PATTERNS.get()));
                    continue block55;
                }
                case "bio_lantern": {
                    mapping.remap((Object)((Item)ModItems.YELLOW_BIO_LANTERN.get()));
                    continue block55;
                }
                case "glass_vial": {
                    mapping.remap((Object)((Item)ModItems.VIAL.get()));
                    continue block55;
                }
                case "creator": {
                    mapping.remap((Object)((Item)ModItems.PRIMORDIAL_CRADLE.get()));
                    continue block55;
                }
                case "flesh_block": {
                    mapping.remap((Object)((Item)ModItems.FLESH_BLOCK.get()));
                    continue block55;
                }
                case "flesh_block_slab": {
                    mapping.remap((Object)((Item)ModItems.FLESH_SLAB.get()));
                    continue block55;
                }
                case "flesh_block_stairs": {
                    mapping.remap((Object)((Item)ModItems.FLESH_STAIRS.get()));
                    continue block55;
                }
                case "flesh_irisdoor": {
                    mapping.remap((Object)((Item)ModItems.FLESH_IRIS_DOOR.get()));
                    continue block55;
                }
                case "necrotic_flesh_block": {
                    mapping.remap((Object)((Item)ModItems.MALIGNANT_FLESH_BLOCK.get()));
                    continue block55;
                }
                case "flesh_tentacle": {
                    mapping.remap((Object)((Item)ModItems.MALIGNANT_FLESH_VEINS.get()));
                    continue block55;
                }
                case "corrupted_primal_flesh": {
                    mapping.remap((Object)((Item)ModItems.PRIMAL_FLESH_BLOCK.get()));
                    continue block55;
                }
                case "biometal": {
                    mapping.remap((Object)((Item)ModItems.LIVING_FLESH.get()));
                    continue block55;
                }
                case "bone_gear": {
                    mapping.remap((Object)Items.f_42500_);
                    continue block55;
                }
                case "lens": {
                    mapping.remap((Object)((Item)ModItems.GEM_FRAGMENTS.get()));
                    continue block55;
                }
                case "skin_chunk": 
                case "flesh_lump": 
                case "mended_skin": {
                    mapping.remap((Object)((Item)ModItems.FLESH_BITS.get()));
                    continue block55;
                }
                case "stomach": 
                case "artificial_stomach": {
                    mapping.remap((Object)((Item)ModItems.GENERIC_MOB_GLAND.get()));
                    continue block55;
                }
                case "bolus": {
                    mapping.remap((Object)((Item)ModItems.NUTRIENTS.get()));
                    continue block55;
                }
                case "keratin_filaments": {
                    mapping.remap((Object)((Item)ModItems.TOUGH_FIBERS.get()));
                    continue block55;
                }
                case "digestate": {
                    mapping.remap((Object)((Item)ModItems.ORGANIC_MATTER.get()));
                    continue block55;
                }
                case "oxide_powder": 
                case "silicate_paste": 
                case "bio_minerals": {
                    mapping.remap((Object)((Item)ModItems.MINERAL_FRAGMENT.get()));
                    continue block55;
                }
                case "hormone_bile": {
                    mapping.remap((Object)((Item)ModItems.HORMONE_SECRETION.get()));
                    continue block55;
                }
            }
            mapping.ignore();
        }
    }
}

