/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.init;

import com.github.elenterius.biomancy.BiomancyMod;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public final class ModBannerPatterns {
    public static final DeferredRegister<BannerPattern> BANNERS = DeferredRegister.create((ResourceKey)Registries.f_256969_, (String)"biomancy");
    public static final RegistryObject<BannerPattern> MASCOT_BASE = ModBannerPatterns.register("mascot_base");
    public static final RegistryObject<BannerPattern> MASCOT_ACCENT = ModBannerPatterns.register("mascot_accent");
    public static final RegistryObject<BannerPattern> MASCOT_OUTLINE = ModBannerPatterns.register("mascot_outline");
    public static final TagKey<BannerPattern> TAG_MASCOT = ModBannerPatterns.createTagKey("mascot");

    private ModBannerPatterns() {
    }

    private static RegistryObject<BannerPattern> register(String name) {
        return BANNERS.register(name, () -> new BannerPattern(BiomancyMod.createRLString(name)));
    }

    private static TagKey<BannerPattern> createTagKey(String name) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256969_, (ResourceLocation)BiomancyMod.createRL("pattern_item/" + name));
    }

    private static TagKey<BannerPattern> createTagKey(RegistryObject<BannerPattern> registryObject) {
        ResourceLocation registryName = registryObject.getId();
        String modId = registryName.m_135827_();
        String name = registryName.m_135815_();
        return TagKey.m_203882_((ResourceKey)Registries.f_256969_, (ResourceLocation)new ResourceLocation(modId, "pattern_item/" + name));
    }
}

