/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.init;

import com.github.elenterius.biomancy.BiomancyMod;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;

@Mod.EventBusSubscriber(modid="biomancy", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ModCapabilities {
    public static final Capability<FlagCapImpl> NO_KNOCKBACK_FLAG_CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<FlagCapImpl>(){});
    public static final Capability<IItemHandler> ITEM_HANDLER = ForgeCapabilities.ITEM_HANDLER;
    public static final Capability<IFluidHandler> FLUID_HANDLER = ForgeCapabilities.FLUID_HANDLER;

    private ModCapabilities() {
    }

    @SubscribeEvent
    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(FlagCapImpl.class);
    }

    public static class FlagCapImpl
    implements IFlagCap {
        private boolean isEnabled = false;

        @Override
        public boolean isEnabled() {
            return this.isEnabled;
        }

        @Override
        public void set(boolean enabled) {
            this.isEnabled = enabled;
        }
    }

    @Mod.EventBusSubscriber(modid="biomancy", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static final class CapabilityAttacher {
        private CapabilityAttacher() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (!(event.getObject() instanceof LivingEntity)) {
                return;
            }
            FlagCapImpl backing = new FlagCapImpl();
            final LazyOptional optionalCap = LazyOptional.of(() -> backing);
            ICapabilityProvider volatileCapProvider = new ICapabilityProvider(){

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
                    return NO_KNOCKBACK_FLAG_CAP.orEmpty(capability, optionalCap);
                }
            };
            event.addCapability(BiomancyMod.createRL("no_knockback"), volatileCapProvider);
            event.addListener(() -> ((LazyOptional)optionalCap).invalidate());
        }
    }

    public static interface IFlagCap {
        public boolean isEnabled();

        public void set(boolean var1);

        default public void enable() {
            this.set(true);
        }

        default public void disable() {
            this.set(false);
        }

        default public void toggle() {
            this.set(!this.isEnabled());
        }
    }
}

