/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.init;

import com.github.elenterius.biomancy.api.serum.Serum;
import com.github.elenterius.biomancy.init.ModArmorMaterials;
import com.github.elenterius.biomancy.init.ModBannerPatterns;
import com.github.elenterius.biomancy.init.ModBlocks;
import com.github.elenterius.biomancy.init.ModEntityTypes;
import com.github.elenterius.biomancy.init.ModFluids;
import com.github.elenterius.biomancy.init.ModFoods;
import com.github.elenterius.biomancy.init.ModRarities;
import com.github.elenterius.biomancy.init.ModSerums;
import com.github.elenterius.biomancy.init.ModTiers;
import com.github.elenterius.biomancy.item.BEWLBlockItem;
import com.github.elenterius.biomancy.item.BiometricMembraneBlockItem;
import com.github.elenterius.biomancy.item.BloomberryItem;
import com.github.elenterius.biomancy.item.BoneMarrowItem;
import com.github.elenterius.biomancy.item.ChrysalisBlockItem;
import com.github.elenterius.biomancy.item.EffectCureItem;
import com.github.elenterius.biomancy.item.EssenceItem;
import com.github.elenterius.biomancy.item.FertilizerItem;
import com.github.elenterius.biomancy.item.FleshChainBlockItem;
import com.github.elenterius.biomancy.item.FleshkinChestBlockItem;
import com.github.elenterius.biomancy.item.GiftSacItem;
import com.github.elenterius.biomancy.item.GuideBookItem;
import com.github.elenterius.biomancy.item.MaykerBannerPatternItem;
import com.github.elenterius.biomancy.item.SerumItem;
import com.github.elenterius.biomancy.item.SimpleBlockItem;
import com.github.elenterius.biomancy.item.SimpleItem;
import com.github.elenterius.biomancy.item.StorageSacBlockItem;
import com.github.elenterius.biomancy.item.UnstableCompoundItem;
import com.github.elenterius.biomancy.item.VolatileGlandItem;
import com.github.elenterius.biomancy.item.armor.AcolyteArmorItem;
import com.github.elenterius.biomancy.item.extractor.ExtractorItem;
import com.github.elenterius.biomancy.item.injector.InjectorItem;
import com.github.elenterius.biomancy.item.shield.ThornShieldItem;
import com.github.elenterius.biomancy.item.weapon.DespoilingSwordItem;
import com.github.elenterius.biomancy.item.weapon.RavenousClawsItem;
import com.github.elenterius.biomancy.item.weapon.gun.CausticGunbladeItem;
import com.github.elenterius.biomancy.item.weapon.gun.DevArmCannonItem;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class ModItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"biomancy");
    public static final RegistryObject<SimpleItem> MOB_FANG = ModItems.registerSimpleItem("mob_fang");
    public static final RegistryObject<SimpleItem> MOB_CLAW = ModItems.registerSimpleItem("mob_claw");
    public static final RegistryObject<SimpleItem> MOB_SINEW = ModItems.registerSimpleItem("mob_sinew", ModRarities.UNCOMMON);
    public static final RegistryObject<BoneMarrowItem> MOB_MARROW = ModItems.registerItem("mob_marrow", props -> new BoneMarrowItem(props.m_41489_(ModFoods.MARROW_FLUID).m_41497_(ModRarities.RARE)));
    public static final RegistryObject<BoneMarrowItem> WITHERED_MOB_MARROW = ModItems.registerItem("withered_mob_marrow", props -> new BoneMarrowItem(props.m_41489_(ModFoods.CORROSIVE_FLUID).m_41497_(ModRarities.VERY_RARE)));
    public static final RegistryObject<SimpleItem> GENERIC_MOB_GLAND = ModItems.registerItem("mob_gland", props -> new SimpleItem(props.m_41489_(ModFoods.POOR_FLESH).m_41497_(ModRarities.UNCOMMON)));
    public static final RegistryObject<SimpleItem> TOXIN_GLAND = ModItems.registerItem("toxin_gland", props -> new SimpleItem(props.m_41489_(ModFoods.TOXIN_GLAND).m_41497_(ModRarities.RARE)));
    public static final RegistryObject<VolatileGlandItem> VOLATILE_GLAND = ModItems.registerItem("volatile_gland", props -> new VolatileGlandItem(props.m_41489_(ModFoods.VOLATILE_GLAND).m_41497_(ModRarities.RARE)));
    public static final RegistryObject<SimpleItem> FLESH_BITS = ModItems.registerSimpleItem("flesh_bits");
    public static final RegistryObject<SimpleItem> BONE_FRAGMENTS = ModItems.registerSimpleItem("bone_fragments");
    public static final RegistryObject<SimpleItem> TOUGH_FIBERS = ModItems.registerSimpleItem("tough_fibers");
    public static final RegistryObject<SimpleItem> ELASTIC_FIBERS = ModItems.registerSimpleItem("elastic_fibers");
    public static final RegistryObject<SimpleItem> MINERAL_FRAGMENT = ModItems.registerSimpleItem("mineral_fragment");
    public static final RegistryObject<SimpleItem> GEM_FRAGMENTS = ModItems.registerSimpleItem("gem_fragments");
    public static final RegistryObject<SimpleItem> NUTRIENTS = ModItems.registerSimpleItem("nutrients");
    public static final RegistryObject<SimpleItem> ORGANIC_MATTER = ModItems.registerSimpleItem("organic_matter");
    public static final RegistryObject<SimpleItem> BIO_LUMENS = ModItems.registerSimpleItem("bio_lumens");
    public static final RegistryObject<SimpleItem> EXOTIC_DUST = ModItems.registerSimpleItem("exotic_dust");
    public static final RegistryObject<SimpleItem> STONE_POWDER = ModItems.registerSimpleItem("stone_powder");
    public static final RegistryObject<SimpleItem> REGENERATIVE_FLUID = ModItems.registerSimpleItem("regenerative_fluid");
    public static final RegistryObject<SimpleItem> WITHERING_OOZE = ModItems.registerSimpleItem("withering_ooze");
    public static final RegistryObject<SimpleItem> HORMONE_SECRETION = ModItems.registerSimpleItem("hormone_secretion");
    public static final RegistryObject<SimpleItem> TOXIN_EXTRACT = ModItems.registerSimpleItem("toxin_extract");
    public static final RegistryObject<SimpleItem> BILE = ModItems.registerSimpleItem("bile");
    public static final RegistryObject<SimpleItem> VOLATILE_FLUID = ModItems.registerSimpleItem("volatile_fluid");
    public static final RegistryObject<SimpleItem> VIAL = ModItems.registerSimpleItem("vial");
    public static final RegistryObject<SimpleItem> ORGANIC_COMPOUND = ModItems.registerSimpleVialItem("organic_compound");
    public static final RegistryObject<UnstableCompoundItem> UNSTABLE_COMPOUND = ModItems.registerItem("unstable_compound", UnstableCompoundItem::new);
    public static final RegistryObject<SimpleItem> GENETIC_COMPOUND = ModItems.registerSimpleVialItem("genetic_compound");
    public static final RegistryObject<SimpleItem> EXOTIC_COMPOUND = ModItems.registerSimpleVialItem("exotic_compound");
    public static final RegistryObject<SimpleItem> HEALING_ADDITIVE = ModItems.registerSimpleVialItem("healing_additive");
    public static final RegistryObject<SimpleItem> CORROSIVE_ADDITIVE = ModItems.registerSimpleVialItem("corrosive_additive");
    public static final RegistryObject<SerumItem> REJUVENATION_SERUM = ModItems.registerSerumItem(ModSerums.REJUVENATION_SERUM);
    public static final RegistryObject<SerumItem> AGEING_SERUM = ModItems.registerSerumItem(ModSerums.AGEING_SERUM);
    public static final RegistryObject<SerumItem> ENLARGEMENT_SERUM = ModItems.registerSerumItem(ModSerums.ENLARGEMENT_SERUM);
    public static final RegistryObject<SerumItem> SHRINKING_SERUM = ModItems.registerSerumItem(ModSerums.SHRINKING_SERUM);
    public static final RegistryObject<SerumItem> BREEDING_STIMULANT = ModItems.registerSerumItem(ModSerums.BREEDING_STIMULANT);
    public static final RegistryObject<SerumItem> ABSORPTION_BOOST = ModItems.registerSerumItem(ModSerums.ABSORPTION_BOOST);
    public static final RegistryObject<SerumItem> CLEANSING_SERUM = ModItems.registerSerumItem(ModSerums.CLEANSING_SERUM);
    public static final RegistryObject<SerumItem> INSOMNIA_CURE = ModItems.registerSerumItem(ModSerums.INSOMNIA_CURE);
    public static final RegistryObject<SerumItem> FRENZY_SERUM = ModItems.registerSerumItem(ModSerums.FRENZY_SERUM);
    public static final RegistryObject<SimpleItem> PRIMORDIAL_CORE = ModItems.registerSimpleItem("primordial_core", ModRarities.VERY_RARE);
    public static final RegistryObject<SimpleItem> LIVING_FLESH = ModItems.registerItem("living_flesh", props -> new SimpleItem(props.m_41489_(ModFoods.LIVING_FLESH).m_41497_(ModRarities.VERY_RARE)));
    public static final RegistryObject<EssenceItem> ESSENCE = ModItems.registerItem("essence", EssenceItem::new);
    public static final RegistryObject<GiftSacItem> GIFT_SAC = ModItems.registerItem("gift_sac", props -> new GiftSacItem(props.m_41487_(1).m_41497_(ModRarities.ULTRA_RARE)));
    public static final RegistryObject<GuideBookItem> GUIDE_BOOK = ModItems.registerItem("guide_book", props -> new GuideBookItem(props.m_41487_(1).m_41497_(ModRarities.RARE)));
    public static final RegistryObject<DespoilingSwordItem> DESPOIL_SICKLE = ModItems.registerItem("despoil_sickle", props -> SwordSmithy.forge(DespoilingSwordItem::new, (Tier)ModTiers.PRIMAL_FLESH, 12, 1.0f, props.m_41497_(ModRarities.VERY_RARE)));
    public static final RegistryObject<ExtractorItem> ESSENCE_EXTRACTOR = ModItems.registerItem("extractor", props -> new ExtractorItem(props.m_41503_(200).m_41497_(ModRarities.RARE)));
    public static final RegistryObject<InjectorItem> INJECTOR = ModItems.registerItem("injector", props -> new InjectorItem(props.m_41503_(200).m_41497_(ModRarities.RARE)));
    public static final RegistryObject<RavenousClawsItem> RAVENOUS_CLAWS = ModItems.registerItem("ravenous_claws", props -> new RavenousClawsItem((Tier)ModTiers.BIOFLESH, 3.5f, 4.0f, 250, props.m_41497_(ModRarities.VERY_RARE)));
    public static final RegistryObject<CausticGunbladeItem> CAUSTIC_GUNBLADE = ModItems.registerItem("caustic_gunblade", props -> new CausticGunbladeItem(200, props.m_41487_(1).m_41497_(ModRarities.VERY_RARE)));
    public static final RegistryObject<DevArmCannonItem> DEV_ARM_CANNON = ModItems.registerItem("dev_arm_cannon", props -> new DevArmCannonItem(props.m_41487_(1).m_41503_(ModTiers.BIOFLESH.m_6609_()).m_41497_(ModRarities.ULTRA_RARE)));
    public static final RegistryObject<ThornShieldItem> THORN_SHIELD = ModItems.registerItem("thorn_shield", props -> new ThornShieldItem(250, props.m_41487_(1).m_41497_(ModRarities.VERY_RARE)));
    public static final RegistryObject<AcolyteArmorItem> ACOLYTE_ARMOR_HELMET = ModItems.registerLivingArmorHelmet("acolyte_armor", ModArmorMaterials.ACOLYTE, 200, AcolyteArmorItem::new);
    public static final RegistryObject<AcolyteArmorItem> ACOLYTE_ARMOR_CHESTPLATE = ModItems.registerLivingArmorChestplate("acolyte_armor", ModArmorMaterials.ACOLYTE, 250, AcolyteArmorItem::new);
    public static final RegistryObject<AcolyteArmorItem> ACOLYTE_ARMOR_LEGGINGS = ModItems.registerLivingArmorLeggings("acolyte_armor", ModArmorMaterials.ACOLYTE, 250, AcolyteArmorItem::new);
    public static final RegistryObject<AcolyteArmorItem> ACOLYTE_ARMOR_BOOTS = ModItems.registerLivingArmorBoots("acolyte_armor", ModArmorMaterials.ACOLYTE, 200, AcolyteArmorItem::new);
    public static final RegistryObject<EffectCureItem> NUTRIENT_PASTE = ModItems.registerItem("nutrient_paste", props -> new EffectCureItem(props.m_41489_(ModFoods.NUTRIENT_PASTE)));
    public static final RegistryObject<EffectCureItem> NUTRIENT_BAR = ModItems.registerItem("nutrient_bar", props -> new EffectCureItem(props.m_41489_(ModFoods.NUTRIENT_BAR)));
    public static final RegistryObject<BloomberryItem> BLOOMBERRY = ModItems.registerItem("bloomberry", props -> new BloomberryItem(props.m_41489_(ModFoods.NUTRIENT_PASTE)));
    public static final RegistryObject<FertilizerItem> FERTILIZER = ModItems.registerItem("fertilizer", props -> new FertilizerItem(props.m_41497_(ModRarities.UNCOMMON)));
    public static final RegistryObject<SimpleItem> CREATOR_MIX = ModItems.registerSimpleItem("creator_mix");
    public static final RegistryObject<BucketItem> ACID_BUCKET = ModItems.registerItem("acid_bucket", properties -> new BucketItem(ModFluids.ACID, properties.m_41495_(Items.f_42446_).m_41487_(1).m_41497_(Rarity.COMMON)));
    public static final RegistryObject<MaykerBannerPatternItem> MASCOT_BANNER_PATTERNS = ModItems.registerItem("mascot_patterns", props -> new MaykerBannerPatternItem(ModBannerPatterns.TAG_MASCOT, (Item.Properties)props));
    public static final RegistryObject<BEWLBlockItem> PRIMORDIAL_CRADLE = ModItems.registerBlockItem(ModBlocks.PRIMORDIAL_CRADLE, (T block) -> new BEWLBlockItem(block, ModItems.createProperties().m_41497_(ModRarities.VERY_RARE)));
    public static final RegistryObject<SimpleBlockItem> BIO_FORGE = ModItems.registerSimpleBlockItem(ModBlocks.BIO_FORGE, ModRarities.RARE);
    public static final RegistryObject<SimpleBlockItem> DECOMPOSER = ModItems.registerSimpleBlockItem(ModBlocks.DECOMPOSER, ModRarities.RARE);
    public static final RegistryObject<SimpleBlockItem> BIO_LAB = ModItems.registerSimpleBlockItem(ModBlocks.BIO_LAB, ModRarities.RARE);
    public static final RegistryObject<SimpleBlockItem> DIGESTER = ModItems.registerSimpleBlockItem(ModBlocks.DIGESTER, ModRarities.RARE);
    public static final RegistryObject<SimpleBlockItem> TONGUE = ModItems.registerSimpleBlockItem(ModBlocks.TONGUE, ModRarities.UNCOMMON);
    public static final RegistryObject<SimpleBlockItem> MAW_HOPPER = ModItems.registerSimpleBlockItem(ModBlocks.MAW_HOPPER, ModRarities.UNCOMMON);
    public static final RegistryObject<FleshkinChestBlockItem> FLESHKIN_CHEST = ModItems.registerBlockItem(ModBlocks.FLESHKIN_CHEST, FleshkinChestBlockItem::new, ModRarities.UNCOMMON);
    public static final RegistryObject<StorageSacBlockItem> STORAGE_SAC = ModItems.registerBlockItem(ModBlocks.STORAGE_SAC, (T block) -> new StorageSacBlockItem((Block)block, ModItems.createProperties().m_41487_(1)));
    public static final RegistryObject<SimpleBlockItem> VIAL_HOLDER = ModItems.registerSimpleBlockItem(ModBlocks.VIAL_HOLDER);
    public static final RegistryObject<ChrysalisBlockItem> CHRYSALIS = ModItems.registerBlockItem(ModBlocks.CHRYSALIS, ChrysalisBlockItem::new, ModRarities.VERY_RARE);
    public static final RegistryObject<SimpleBlockItem> MODULAR_LARYNX = ModItems.registerSimpleBlockItem(ModBlocks.MODULAR_LARYNX);
    public static final RegistryObject<SimpleBlockItem> FLESH_SPIKE = ModItems.registerSimpleBlockItem(ModBlocks.FLESH_SPIKE);
    public static final RegistryObject<SimpleBlockItem> FLESHKIN_PRESSURE_PLATE = ModItems.registerSimpleBlockItem(ModBlocks.FLESHKIN_PRESSURE_PLATE);
    public static final RegistryObject<SimpleBlockItem> FLESH_IRIS_DOOR = ModItems.registerSimpleBlockItem(ModBlocks.FLESH_IRIS_DOOR);
    public static final RegistryObject<SimpleBlockItem> FLESH_DOOR = ModItems.registerSimpleBlockItem(ModBlocks.FLESH_DOOR);
    public static final RegistryObject<SimpleBlockItem> FULL_FLESH_DOOR = ModItems.registerSimpleBlockItem(ModBlocks.FULL_FLESH_DOOR);
    public static final RegistryObject<FleshChainBlockItem> TENDON_CHAIN = ModItems.registerBlockItem(ModBlocks.TENDON_CHAIN, FleshChainBlockItem::new);
    public static final RegistryObject<SimpleBlockItem> FLESH_LADDER = ModItems.registerSimpleBlockItem(ModBlocks.FLESH_LADDER);
    public static final RegistryObject<SimpleBlockItem> FLESH_FENCE = ModItems.registerSimpleBlockItem(ModBlocks.FLESH_FENCE);
    public static final RegistryObject<SimpleBlockItem> FLESH_FENCE_GATE = ModItems.registerSimpleBlockItem(ModBlocks.FLESH_FENCE_GATE);
    public static final RegistryObject<SimpleBlockItem> YELLOW_BIO_LANTERN = ModItems.registerSimpleBlockItem(ModBlocks.YELLOW_BIO_LANTERN);
    public static final RegistryObject<SimpleBlockItem> BLUE_BIO_LANTERN = ModItems.registerSimpleBlockItem(ModBlocks.BLUE_BIO_LANTERN);
    public static final RegistryObject<SimpleBlockItem> PRIMORDIAL_BIO_LANTERN = ModItems.registerSimpleBlockItem(ModBlocks.PRIMORDIAL_BIO_LANTERN);
    public static final RegistryObject<SimpleBlockItem> BIOMETRIC_MEMBRANE = ModItems.registerBlockItem(ModBlocks.BIOMETRIC_MEMBRANE, BiometricMembraneBlockItem::new, ModRarities.VERY_RARE);
    public static final RegistryObject<SimpleBlockItem> IMPERMEABLE_MEMBRANE = ModItems.registerSimpleBlockItem(ModBlocks.IMPERMEABLE_MEMBRANE);
    public static final RegistryObject<SimpleBlockItem> IMPERMEABLE_MEMBRANE_PANE = ModItems.registerSimpleBlockItem(ModBlocks.IMPERMEABLE_MEMBRANE_PANE);
    public static final RegistryObject<SimpleBlockItem> BABY_PERMEABLE_MEMBRANE = ModItems.registerSimpleBlockItem(ModBlocks.BABY_PERMEABLE_MEMBRANE);
    public static final RegistryObject<SimpleBlockItem> BABY_PERMEABLE_MEMBRANE_PANE = ModItems.registerSimpleBlockItem(ModBlocks.BABY_PERMEABLE_MEMBRANE_PANE);
    public static final RegistryObject<SimpleBlockItem> ADULT_PERMEABLE_MEMBRANE = ModItems.registerSimpleBlockItem(ModBlocks.ADULT_PERMEABLE_MEMBRANE);
    public static final RegistryObject<SimpleBlockItem> ADULT_PERMEABLE_MEMBRANE_PANE = ModItems.registerSimpleBlockItem(ModBlocks.ADULT_PERMEABLE_MEMBRANE_PANE);
    public static final RegistryObject<SimpleBlockItem> PRIMAL_PERMEABLE_MEMBRANE = ModItems.registerSimpleBlockItem(ModBlocks.PRIMAL_PERMEABLE_MEMBRANE);
    public static final RegistryObject<SimpleBlockItem> PRIMAL_PERMEABLE_MEMBRANE_PANE = ModItems.registerSimpleBlockItem(ModBlocks.PRIMAL_PERMEABLE_MEMBRANE_PANE);
    public static final RegistryObject<SimpleBlockItem> UNDEAD_PERMEABLE_MEMBRANE = ModItems.registerSimpleBlockItem(ModBlocks.UNDEAD_PERMEABLE_MEMBRANE);
    public static final RegistryObject<SimpleBlockItem> UNDEAD_PERMEABLE_MEMBRANE_PANE = ModItems.registerSimpleBlockItem(ModBlocks.UNDEAD_PERMEABLE_MEMBRANE_PANE);
    public static final RegistryObject<SimpleBlockItem> FLESH_BLOCK = ModItems.registerSimpleBlockItem(ModBlocks.FLESH);
    public static final RegistryObject<SimpleBlockItem> FLESH_SLAB = ModItems.registerSimpleBlockItem(ModBlocks.FLESH_SLAB);
    public static final RegistryObject<SimpleBlockItem> FLESH_STAIRS = ModItems.registerSimpleBlockItem(ModBlocks.FLESH_STAIRS);
    public static final RegistryObject<SimpleBlockItem> FLESH_WALL = ModItems.registerSimpleBlockItem(ModBlocks.FLESH_WALL);
    public static final RegistryObject<SimpleBlockItem> PACKED_FLESH_BLOCK = ModItems.registerSimpleBlockItem(ModBlocks.PACKED_FLESH);
    public static final RegistryObject<SimpleBlockItem> PACKED_FLESH_SLAB = ModItems.registerSimpleBlockItem(ModBlocks.PACKED_FLESH_SLAB);
    public static final RegistryObject<SimpleBlockItem> PACKED_FLESH_STAIRS = ModItems.registerSimpleBlockItem(ModBlocks.PACKED_FLESH_STAIRS);
    public static final RegistryObject<SimpleBlockItem> PACKED_FLESH_WALL = ModItems.registerSimpleBlockItem(ModBlocks.PACKED_FLESH_WALL);
    public static final RegistryObject<SimpleBlockItem> FIBROUS_FLESH_BLOCK = ModItems.registerSimpleBlockItem(ModBlocks.FIBROUS_FLESH);
    public static final RegistryObject<SimpleBlockItem> FIBROUS_FLESH_SLAB = ModItems.registerSimpleBlockItem(ModBlocks.FIBROUS_FLESH_SLAB);
    public static final RegistryObject<SimpleBlockItem> FIBROUS_FLESH_STAIRS = ModItems.registerSimpleBlockItem(ModBlocks.FIBROUS_FLESH_STAIRS);
    public static final RegistryObject<SimpleBlockItem> FIBROUS_FLESH_WALL = ModItems.registerSimpleBlockItem(ModBlocks.FIBROUS_FLESH_WALL);
    public static final RegistryObject<SimpleBlockItem> FLESH_PILLAR = ModItems.registerSimpleBlockItem(ModBlocks.FLESH_PILLAR);
    public static final RegistryObject<SimpleBlockItem> CHISELED_FLESH_BLOCK = ModItems.registerSimpleBlockItem(ModBlocks.CHISELED_FLESH);
    public static final RegistryObject<SimpleBlockItem> ORNATE_FLESH_BLOCK = ModItems.registerSimpleBlockItem(ModBlocks.ORNATE_FLESH);
    public static final RegistryObject<SimpleBlockItem> ORNATE_FLESH_SLAB = ModItems.registerSimpleBlockItem(ModBlocks.ORNATE_FLESH_SLAB);
    public static final RegistryObject<SimpleBlockItem> TUBULAR_FLESH_BLOCK = ModItems.registerSimpleBlockItem(ModBlocks.TUBULAR_FLESH_BLOCK);
    public static final RegistryObject<SimpleBlockItem> PRIMAL_FLESH_BLOCK = ModItems.registerSimpleBlockItem(ModBlocks.PRIMAL_FLESH);
    public static final RegistryObject<SimpleBlockItem> PRIMAL_FLESH_SLAB = ModItems.registerSimpleBlockItem(ModBlocks.PRIMAL_FLESH_SLAB);
    public static final RegistryObject<SimpleBlockItem> PRIMAL_FLESH_STAIRS = ModItems.registerSimpleBlockItem(ModBlocks.PRIMAL_FLESH_STAIRS);
    public static final RegistryObject<SimpleBlockItem> PRIMAL_FLESH_WALL = ModItems.registerSimpleBlockItem(ModBlocks.PRIMAL_FLESH_WALL);
    public static final RegistryObject<SimpleBlockItem> SMOOTH_PRIMAL_FLESH_BLOCK = ModItems.registerSimpleBlockItem(ModBlocks.SMOOTH_PRIMAL_FLESH);
    public static final RegistryObject<SimpleBlockItem> SMOOTH_PRIMAL_FLESH_SLAB = ModItems.registerSimpleBlockItem(ModBlocks.SMOOTH_PRIMAL_FLESH_SLAB);
    public static final RegistryObject<SimpleBlockItem> SMOOTH_PRIMAL_FLESH_STAIRS = ModItems.registerSimpleBlockItem(ModBlocks.SMOOTH_PRIMAL_FLESH_STAIRS);
    public static final RegistryObject<SimpleBlockItem> SMOOTH_PRIMAL_FLESH_WALL = ModItems.registerSimpleBlockItem(ModBlocks.SMOOTH_PRIMAL_FLESH_WALL);
    public static final RegistryObject<SimpleBlockItem> POROUS_PRIMAL_FLESH_BLOCK = ModItems.registerSimpleBlockItem(ModBlocks.POROUS_PRIMAL_FLESH);
    public static final RegistryObject<SimpleBlockItem> POROUS_PRIMAL_FLESH_SLAB = ModItems.registerSimpleBlockItem(ModBlocks.POROUS_PRIMAL_FLESH_SLAB);
    public static final RegistryObject<SimpleBlockItem> POROUS_PRIMAL_FLESH_STAIRS = ModItems.registerSimpleBlockItem(ModBlocks.POROUS_PRIMAL_FLESH_STAIRS);
    public static final RegistryObject<SimpleBlockItem> POROUS_PRIMAL_FLESH_WALL = ModItems.registerSimpleBlockItem(ModBlocks.POROUS_PRIMAL_FLESH_WALL);
    public static final RegistryObject<SimpleBlockItem> MALIGNANT_FLESH_BLOCK = ModItems.registerSimpleBlockItem(ModBlocks.MALIGNANT_FLESH);
    public static final RegistryObject<SimpleBlockItem> MALIGNANT_FLESH_SLAB = ModItems.registerSimpleBlockItem(ModBlocks.MALIGNANT_FLESH_SLAB);
    public static final RegistryObject<SimpleBlockItem> MALIGNANT_FLESH_STAIRS = ModItems.registerSimpleBlockItem(ModBlocks.MALIGNANT_FLESH_STAIRS);
    public static final RegistryObject<SimpleBlockItem> MALIGNANT_FLESH_WALL = ModItems.registerSimpleBlockItem(ModBlocks.MALIGNANT_FLESH_WALL);
    public static final RegistryObject<SimpleBlockItem> MALIGNANT_FLESH_VEINS = ModItems.registerSimpleBlockItem(ModBlocks.MALIGNANT_FLESH_VEINS);
    public static final RegistryObject<SimpleBlockItem> PRIMAL_BLOOM = ModItems.registerSimpleBlockItem(ModBlocks.PRIMAL_BLOOM);
    public static final RegistryObject<SimpleBlockItem> BLOOMLIGHT = ModItems.registerSimpleBlockItem(ModBlocks.BLOOMLIGHT);
    public static final RegistryObject<SimpleBlockItem> PRIMAL_ORIFICE = ModItems.registerSimpleBlockItem(ModBlocks.PRIMAL_ORIFICE);
    public static final RegistryObject<ForgeSpawnEggItem> HUNGRY_FLESH_BLOB_SPAWN_EGG = ModItems.registerSpawnEgg(ModEntityTypes.HUNGRY_FLESH_BLOB, 15308410, 16175814);
    public static final RegistryObject<ForgeSpawnEggItem> FLESH_BLOB_SPAWN_EGG = ModItems.registerSpawnEgg(ModEntityTypes.FLESH_BLOB, 15308410, 16175814);
    public static final RegistryObject<ForgeSpawnEggItem> LEGACY_FLESH_BLOB_SPAWN_EGG = ModItems.registerSpawnEgg(ModEntityTypes.LEGACY_FLESH_BLOB, 15648218, 16761035);
    public static final RegistryObject<ForgeSpawnEggItem> PRIMORDIAL_FLESH_BLOB_SPAWN_EGG = ModItems.registerSpawnEgg(ModEntityTypes.PRIMORDIAL_FLESH_BLOB, 14573684, 12796926);
    public static final RegistryObject<ForgeSpawnEggItem> PRIMORDIAL_HUNGRY_FLESH_BLOB_SPAWN_EGG = ModItems.registerSpawnEgg(ModEntityTypes.PRIMORDIAL_HUNGRY_FLESH_BLOB, 7676228, 7676228);
    public static final RegistryObject<ForgeSpawnEggItem> FLESH_COW_SPAWN_EGG = ModItems.registerSpawnEgg(ModEntityTypes.FLESH_COW, 15308410, 10319218);
    public static final RegistryObject<ForgeSpawnEggItem> FLESH_SHEEP_SPAWN_EGG = ModItems.registerSpawnEgg(ModEntityTypes.FLESH_SHEEP, 15308410, 16366548);
    public static final RegistryObject<ForgeSpawnEggItem> FLESH_PIG_SPAWN_EGG = ModItems.registerSpawnEgg(ModEntityTypes.FLESH_PIG, 15308410, 15562372);
    public static final RegistryObject<ForgeSpawnEggItem> FLESH_CHICKEN_SPAWN_EGG = ModItems.registerSpawnEgg(ModEntityTypes.FLESH_CHICKEN, 15308410, 13520485);
    public static final RegistryObject<ForgeSpawnEggItem> CHROMA_SHEEP_SPAWN_EGG = ModItems.registerSpawnEgg(ModEntityTypes.CHROMA_SHEEP, 15308410, 16366548);
    public static final RegistryObject<ForgeSpawnEggItem> THICK_FUR_SHEEP_SPAWN_EGG = ModItems.registerSpawnEgg(ModEntityTypes.THICK_FUR_SHEEP, 15308410, 16366548);

    private ModItems() {
    }

    public static <T extends Item> Stream<T> findItems(Class<T> clazz) {
        return ITEMS.getEntries().stream().map(RegistryObject::get).filter(clazz::isInstance).map(clazz::cast);
    }

    public static <T extends Item> Stream<RegistryObject<T>> findEntries(Class<T> clazz) {
        return ITEMS.getEntries().stream().filter(registryObject -> clazz.isInstance(registryObject.get())).map(registryObject -> registryObject);
    }

    private static <T extends Item> RegistryObject<T> registerItem(String name, Function<Item.Properties, T> factory) {
        return ITEMS.register(name, () -> (Item)factory.apply(ModItems.createProperties()));
    }

    private static <T extends Block> RegistryObject<SimpleBlockItem> registerSimpleBlockItem(RegistryObject<T> blockHolder) {
        return ITEMS.register(blockHolder.getId().m_135815_(), () -> new SimpleBlockItem((Block)blockHolder.get(), ModItems.createProperties()));
    }

    private static <T extends Block> RegistryObject<SimpleBlockItem> registerSimpleBlockItem(RegistryObject<T> blockHolder, Rarity rarity) {
        return ModItems.registerSimpleBlockItem(blockHolder, () -> ModItems.createProperties().m_41497_(rarity));
    }

    private static <T extends Block> RegistryObject<SimpleBlockItem> registerSimpleBlockItem(RegistryObject<T> blockHolder, Supplier<Item.Properties> properties) {
        return ITEMS.register(blockHolder.getId().m_135815_(), () -> new SimpleBlockItem((Block)blockHolder.get(), (Item.Properties)properties.get()));
    }

    private static <T extends Block, I extends BlockItem> RegistryObject<I> registerBlockItem(RegistryObject<T> blockHolder, Function<T, I> factory) {
        return ITEMS.register(blockHolder.getId().m_135815_(), () -> (BlockItem)factory.apply((Block)blockHolder.get()));
    }

    private static <T extends Block, I extends BlockItem> RegistryObject<I> registerBlockItem(RegistryObject<T> blockHolder, IBlockItemFactory<T, I> factory) {
        return ITEMS.register(blockHolder.getId().m_135815_(), () -> factory.create((Block)blockHolder.get(), ModItems.createProperties()));
    }

    private static <T extends Block, I extends BlockItem> RegistryObject<I> registerBlockItem(RegistryObject<T> blockHolder, IBlockItemFactory<T, I> factory, Rarity rarity) {
        return ITEMS.register(blockHolder.getId().m_135815_(), () -> factory.create((Block)blockHolder.get(), ModItems.createProperties().m_41497_(rarity)));
    }

    private static <M extends ArmorMaterial, I extends ArmorItem> RegistryObject<I> registerArmorHelmet(String name, M material, ArmorFactory<M, ArmorItem.Type, I> factory) {
        return ModItems.registerArmor(name + "_helmet", material, ArmorItem.Type.HELMET, factory);
    }

    private static <M extends ArmorMaterial, I extends ArmorItem> RegistryObject<I> registerArmorChestplate(String name, M material, ArmorFactory<M, ArmorItem.Type, I> factory) {
        return ModItems.registerArmor(name + "_chestplate", material, ArmorItem.Type.CHESTPLATE, factory);
    }

    private static <M extends ArmorMaterial, I extends ArmorItem> RegistryObject<I> registerArmorLeggings(String name, M material, ArmorFactory<M, ArmorItem.Type, I> factory) {
        return ModItems.registerArmor(name + "_leggings", material, ArmorItem.Type.LEGGINGS, factory);
    }

    private static <M extends ArmorMaterial, I extends ArmorItem> RegistryObject<I> registerArmorBoots(String name, M material, ArmorFactory<M, ArmorItem.Type, I> factory) {
        return ModItems.registerArmor(name + "_boots", material, ArmorItem.Type.BOOTS, factory);
    }

    private static <M extends ArmorMaterial, T extends ArmorItem.Type, I extends ArmorItem> RegistryObject<I> registerArmor(String name, M material, T type, ArmorFactory<M, T, I> factory) {
        return ITEMS.register(name, () -> factory.create(material, type, ModItems.createProperties()));
    }

    private static <M extends ArmorMaterial, I extends ArmorItem> RegistryObject<I> registerLivingArmorHelmet(String name, M material, int maxNutrients, LivingArmorFactory<M, ArmorItem.Type, I> factory) {
        return ModItems.registerLivingArmor(name + "_helmet", material, ArmorItem.Type.HELMET, maxNutrients, factory);
    }

    private static <M extends ArmorMaterial, I extends ArmorItem> RegistryObject<I> registerLivingArmorChestplate(String name, M material, int maxNutrients, LivingArmorFactory<M, ArmorItem.Type, I> factory) {
        return ModItems.registerLivingArmor(name + "_chestplate", material, ArmorItem.Type.CHESTPLATE, maxNutrients, factory);
    }

    private static <M extends ArmorMaterial, I extends ArmorItem> RegistryObject<I> registerLivingArmorLeggings(String name, M material, int maxNutrients, LivingArmorFactory<M, ArmorItem.Type, I> factory) {
        return ModItems.registerLivingArmor(name + "_leggings", material, ArmorItem.Type.LEGGINGS, maxNutrients, factory);
    }

    private static <M extends ArmorMaterial, I extends ArmorItem> RegistryObject<I> registerLivingArmorBoots(String name, M material, int maxNutrients, LivingArmorFactory<M, ArmorItem.Type, I> factory) {
        return ModItems.registerLivingArmor(name + "_boots", material, ArmorItem.Type.BOOTS, maxNutrients, factory);
    }

    private static <M extends ArmorMaterial, T extends ArmorItem.Type, I extends ArmorItem> RegistryObject<I> registerLivingArmor(String name, M material, T type, int maxNutrients, LivingArmorFactory<M, T, I> factory) {
        return ITEMS.register(name, () -> factory.create(material, type, maxNutrients, ModItems.createProperties().m_41497_(ModRarities.VERY_RARE)));
    }

    private static <T extends EntityType<? extends Mob>> RegistryObject<ForgeSpawnEggItem> registerSpawnEgg(RegistryObject<T> mobHolder, int primaryColor, int accentColor) {
        return ITEMS.register(mobHolder.getId().m_135815_() + "_spawn_egg", () -> new ForgeSpawnEggItem((Supplier)mobHolder, primaryColor, accentColor, ModItems.createProperties()));
    }

    private static <T extends Serum> RegistryObject<SerumItem> registerSerumItem(RegistryObject<T> registryObject) {
        return ITEMS.register(registryObject.getId().m_135815_(), () -> new SerumItem(ModItems.createProperties().m_41487_(8).m_41497_(ModRarities.UNCOMMON), (Supplier<? extends Serum>)registryObject));
    }

    private static RegistryObject<SimpleItem> registerSimpleVialItem(String name) {
        return ITEMS.register(name, () -> new SimpleItem(ModItems.createProperties()));
    }

    private static RegistryObject<SimpleItem> registerSimpleItem(String name) {
        return ITEMS.register(name, () -> new SimpleItem(ModItems.createProperties()));
    }

    private static RegistryObject<SimpleItem> registerSimpleItem(String name, Rarity rarity) {
        return ModItems.registerSimpleItem(name, () -> ModItems.createProperties().m_41497_(rarity));
    }

    private static Item.Properties createProperties() {
        return new Item.Properties().m_41497_(ModRarities.COMMON);
    }

    private static RegistryObject<SimpleItem> registerSimpleItem(String name, Supplier<Item.Properties> properties) {
        return ITEMS.register(name, () -> new SimpleItem((Item.Properties)properties.get()));
    }

    static interface IBlockItemFactory<T extends Block, I extends BlockItem> {
        public I create(T var1, Item.Properties var2);
    }

    static interface ArmorFactory<M extends ArmorMaterial, T extends ArmorItem.Type, I extends ArmorItem> {
        public I create(M var1, T var2, Item.Properties var3);
    }

    static interface LivingArmorFactory<M extends ArmorMaterial, T extends ArmorItem.Type, I extends ArmorItem> {
        public I create(M var1, T var2, int var3, Item.Properties var4);
    }

    private static interface SwordSmithy<T extends SwordItem> {
        public static final AttributeSupplier PLAYER_ATTRIBUTES = Player.m_36340_().m_22265_();

        public static <T extends SwordItem> T forge(SwordSmithy<T> smithy, Tier tier, int attackDamage, float attackSpeed, Item.Properties properties) {
            int attackDamageModifier = Mth.m_14107_((double)((double)attackDamage - (PLAYER_ATTRIBUTES.m_22245_(Attributes.f_22281_) + (double)tier.m_6631_())));
            float attackSpeedModifier = attackSpeed - (float)PLAYER_ATTRIBUTES.m_22245_(Attributes.f_22283_);
            return smithy.forge(tier, attackDamageModifier, attackSpeedModifier, properties);
        }

        public T forge(Tier var1, int var2, float var3, Item.Properties var4);
    }
}

