/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.init;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.crafting.recipe.AnyFoodIngredient;
import com.github.elenterius.biomancy.crafting.recipe.BioForgeRecipe;
import com.github.elenterius.biomancy.crafting.recipe.BioLabRecipe;
import com.github.elenterius.biomancy.crafting.recipe.BiometricMembraneRecipe;
import com.github.elenterius.biomancy.crafting.recipe.CradleCleansingRecipe;
import com.github.elenterius.biomancy.crafting.recipe.DecomposerRecipe;
import com.github.elenterius.biomancy.crafting.recipe.DigestingRecipe;
import com.github.elenterius.biomancy.crafting.recipe.FoodDigestingRecipe;
import com.github.elenterius.biomancy.crafting.recipe.SimpleRecipeType;
import com.github.elenterius.biomancy.crafting.recipe.StaticDigestingRecipe;
import com.github.elenterius.biomancy.init.ModItems;
import com.github.elenterius.biomancy.init.ModPotions;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.StrictNBTIngredient;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class ModRecipes {
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"biomancy");
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((ResourceKey)Registries.f_256954_, (String)"biomancy");
    public static final RegistryObject<SimpleRecipeType.ItemStackRecipeType<DecomposerRecipe>> DECOMPOSING_RECIPE_TYPE = ModRecipes.registerItemStackRecipeType("decomposing");
    public static final RegistryObject<RecipeSerializer<DecomposerRecipe>> DECOMPOSING_SERIALIZER = ModRecipes.registerRecipeSerializer(DECOMPOSING_RECIPE_TYPE, DecomposerRecipe.Serializer::new);
    public static final RegistryObject<SimpleRecipeType.ItemStackRecipeType<BioLabRecipe>> BIO_BREWING_RECIPE_TYPE = ModRecipes.registerItemStackRecipeType("bio_brewing");
    public static final RegistryObject<RecipeSerializer<BioLabRecipe>> BIO_BREWING_SERIALIZER = ModRecipes.registerRecipeSerializer(BIO_BREWING_RECIPE_TYPE, BioLabRecipe.Serializer::new);
    public static final RegistryObject<SimpleRecipeType.ItemStackRecipeType<BioForgeRecipe>> BIO_FORGING_RECIPE_TYPE = ModRecipes.registerItemStackRecipeType("bio_forging");
    public static final RegistryObject<RecipeSerializer<BioForgeRecipe>> BIO_FORGING_SERIALIZER = ModRecipes.registerRecipeSerializer(BIO_FORGING_RECIPE_TYPE, BioForgeRecipe.Serializer::new);
    public static final RegistryObject<SimpleRecipeType.ItemStackRecipeType<DigestingRecipe>> DIGESTING_RECIPE_TYPE = ModRecipes.registerItemStackRecipeType("digesting");
    public static final RegistryObject<RecipeSerializer<StaticDigestingRecipe>> DIGESTING_SERIALIZER = ModRecipes.registerRecipeSerializer(DIGESTING_RECIPE_TYPE, StaticDigestingRecipe.Serializer::new);
    public static final RegistryObject<RecipeSerializer<FoodDigestingRecipe>> FOOD_DIGESTING_SERIALIZER = ModRecipes.registerDynamicRecipeSerializer(DIGESTING_RECIPE_TYPE, "food", FoodDigestingRecipe.Serializer::new);
    public static final RegistryObject<RecipeSerializer<BiometricMembraneRecipe>> BIOMETRIC_MEMBRANE_CRAFTING_SERIALIZER = ModRecipes.registerDynamicCraftingRecipeSerializer(RecipeType.f_44107_, "biometric_membrane", () -> new SimpleCraftingRecipeSerializer(BiometricMembraneRecipe::new));
    public static final RegistryObject<RecipeSerializer<CradleCleansingRecipe>> CRADLE_CLEANSING_SERIALIZER = ModRecipes.registerDynamicCraftingRecipeSerializer(RecipeType.f_44107_, "cradle_cleansing", () -> new SimpleCraftingRecipeSerializer(CradleCleansingRecipe::new));

    private ModRecipes() {
    }

    public static void registerComposterRecipes() {
        ComposterBlock.f_51914_.putIfAbsent((Object)((ItemLike)ModItems.ORGANIC_MATTER.get()), 0.25f);
    }

    public static void registerBrewingRecipes() {
        ModRecipes.registerBrewingRecipe((Item)ModItems.TOXIN_EXTRACT.get(), Potions.f_43602_, Potions.f_43584_);
        ModRecipes.registerBrewingRecipe((Item)ModItems.TOXIN_GLAND.get(), Potions.f_43600_, Potions.f_43585_);
        ModRecipes.registerBrewingRecipe((Item)ModItems.TOXIN_GLAND.get(), Potions.f_43601_, Potions.f_43586_);
        ModRecipes.registerBrewingRecipe((Item)ModItems.WITHERING_OOZE.get(), Potions.f_43584_, Potions.f_43582_);
        ModRecipes.registerBrewingRecipe((Item)ModItems.WITHERING_OOZE.get(), Potions.f_43586_, Potions.f_43583_);
        ModRecipes.registerBrewingRecipe((Item)ModItems.BLOOMBERRY.get(), Potions.f_43600_, (Potion)ModPotions.PRIMORDIAL_INFESTATION.get());
        ModRecipes.registerBrewingRecipe(Items.f_42451_, (Potion)ModPotions.PRIMORDIAL_INFESTATION.get(), (Potion)ModPotions.LONG_PRIMORDIAL_INFESTATION.get());
    }

    private static void registerBrewingRecipe(Item reactant, Potion potionBase, Potion potionResult) {
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new BrewingRecipe(ModRecipes.createPotionIngredient(potionBase), Ingredient.m_43929_((ItemLike[])new ItemLike[]{reactant}), ModRecipes.createPotionStack(potionResult)));
    }

    private static ItemStack createPotionStack(Supplier<Potion> supplier) {
        return ModRecipes.createPotionStack(supplier.get());
    }

    private static ItemStack createPotionStack(Potion potion) {
        return PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)potion);
    }

    private static Ingredient createPotionIngredient(Potion potion) {
        return StrictNBTIngredient.of((ItemStack)ModRecipes.createPotionStack(potion));
    }

    public static void registerIngredientSerializers() {
        CraftingHelper.register((ResourceLocation)BiomancyMod.createRL("food_nutrition"), (IIngredientSerializer)AnyFoodIngredient.Serializer.INSTANCE);
    }

    private static <T extends RecipeType<?>, R extends Recipe<Container>> RegistryObject<RecipeSerializer<R>> registerRecipeSerializer(RegistryObject<T> recipeType, Supplier<RecipeSerializer<R>> serializerSupplier) {
        return RECIPE_SERIALIZERS.register(recipeType.getId().m_135815_(), serializerSupplier);
    }

    private static <T extends RecipeType<?>, R extends Recipe<Container>> RegistryObject<RecipeSerializer<R>> registerDynamicRecipeSerializer(RegistryObject<T> recipeType, String name, Supplier<RecipeSerializer<R>> serializerSupplier) {
        String prefix = recipeType.getId().m_135815_() + "_dynamic_";
        return RECIPE_SERIALIZERS.register(prefix + name, serializerSupplier);
    }

    private static <T extends CraftingRecipe, R extends CraftingRecipe> RegistryObject<RecipeSerializer<R>> registerDynamicCraftingRecipeSerializer(RecipeType<T> recipeType, String name, Supplier<RecipeSerializer<R>> serializerSupplier) {
        String prefix = Objects.requireNonNull(ResourceLocation.m_135820_((String)recipeType.toString())).m_135815_() + "_dynamic_";
        return RECIPE_SERIALIZERS.register(prefix + name, serializerSupplier);
    }

    private static <R extends CraftingRecipe> RegistryObject<RecipeSerializer<R>> registerCraftingRecipeSerializer(String name, Supplier<RecipeSerializer<R>> serializer) {
        return RECIPE_SERIALIZERS.register(name, serializer);
    }

    private static <T extends Recipe<Container>> RegistryObject<SimpleRecipeType.ItemStackRecipeType<T>> registerItemStackRecipeType(String namespacedId) {
        return RECIPE_TYPES.register(namespacedId, () -> new SimpleRecipeType.ItemStackRecipeType(BiomancyMod.createRLString(namespacedId)));
    }

    private static <T extends Recipe<Container>> RegistryObject<SimpleRecipeType<T>> createSimpleRecipeType(String namespacedId) {
        return RECIPE_TYPES.register(namespacedId, () -> new SimpleRecipeType(BiomancyMod.createRLString(namespacedId)));
    }
}

