/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.integration.create;

import com.github.elenterius.biomancy.init.ModFluids;
import com.github.elenterius.biomancy.integration.create.InteractionBehaviors;
import com.github.elenterius.biomancy.util.CombatUtil;
import com.simibubi.create.content.fluids.OpenEndedPipe;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidStack;

public final class CreateCompat {
    private CreateCompat() {
    }

    public static void onPostSetup() {
        InteractionBehaviors.register();
        OpenEndedPipe.registerEffectHandler((OpenEndedPipe.IEffectHandler)new AcidEffectHandler());
    }

    private static class AcidEffectHandler
    implements OpenEndedPipe.IEffectHandler {
        private AcidEffectHandler() {
        }

        public boolean canApplyEffects(OpenEndedPipe openEndedPipe, FluidStack fluidStack) {
            return fluidStack.getFluid().getFluidType() == ModFluids.ACID_TYPE.get();
        }

        public void applyEffects(OpenEndedPipe openEndedPipe, FluidStack fluidStack) {
            Level level = openEndedPipe.getWorld();
            if (level.m_46467_() % 5L == 0L) {
                List mobs = level.m_6443_(LivingEntity.class, openEndedPipe.getAOE(), livingEntity -> !CombatUtil.hasAcidEffect(livingEntity));
                for (LivingEntity mob : mobs) {
                    CombatUtil.applyAcidEffect(mob, 4);
                }
                BlockPos.m_121921_((AABB)openEndedPipe.getAOE()).forEach(pos -> this.corrodeCopper(level, (BlockPos)pos));
            }
        }

        private void corrodeCopper(Level level, BlockPos pos) {
            if (level.f_46441_.m_188501_() >= 0.057f) {
                return;
            }
            BlockState blockState = level.m_8055_(pos);
            Block block = blockState.m_60734_();
            if (block instanceof WeatheringCopper) {
                WeatheringCopper weatheringCopper = (WeatheringCopper)block;
                if (WeatheringCopper.m_154904_((Block)block).isPresent()) {
                    weatheringCopper.m_142123_(blockState).ifPresent(state -> level.m_46597_(pos, state));
                }
            }
        }
    }
}

