/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.integration.create;

import com.github.elenterius.biomancy.block.FleshDoorBlock;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.SimpleBlockMovingInteraction;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.Nullable;

class FleshDoorMovingInteraction
extends SimpleBlockMovingInteraction {
    FleshDoorMovingInteraction() {
    }

    protected BlockState handle(@Nullable Player player, Contraption contraption, BlockPos pos, BlockState blockState) {
        if (!(blockState.m_60734_() instanceof FleshDoorBlock)) {
            return blockState;
        }
        BlockPos otherPos = blockState.m_61143_((Property)FleshDoorBlock.f_52730_) == DoubleBlockHalf.LOWER ? pos.m_7494_() : pos.m_7495_();
        StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(otherPos);
        if (info.f_74676_().m_61138_((Property)FleshDoorBlock.f_52727_)) {
            BlockState newState = (BlockState)info.f_74676_().m_61122_((Property)FleshDoorBlock.f_52727_);
            this.setContraptionBlockData(contraption.entity, otherPos, new StructureTemplate.StructureBlockInfo(info.f_74675_(), newState, info.f_74677_()));
        }
        blockState = (BlockState)blockState.m_61122_((Property)FleshDoorBlock.f_52727_);
        if (player != null) {
            boolean isDoorOpen = Boolean.TRUE.equals(blockState.m_61143_((Property)FleshDoorBlock.f_52727_));
            SoundEvent soundEvent = isDoorOpen ? (SoundEvent)ModSoundEvents.FLESH_DOOR_OPEN.get() : (SoundEvent)ModSoundEvents.FLESH_DOOR_CLOSE.get();
            float pitch = player.m_9236_().f_46441_.m_188501_() * 0.1f + 0.9f;
            this.playSound(player, soundEvent, pitch);
        }
        return blockState;
    }

    protected boolean updateColliders() {
        return true;
    }
}

