/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.integration.jei;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.crafting.recipe.BioForgeRecipe;
import com.github.elenterius.biomancy.crafting.recipe.IngredientStack;
import com.github.elenterius.biomancy.init.ModItems;
import com.github.elenterius.biomancy.init.ModRecipes;
import com.github.elenterius.biomancy.util.ComponentUtil;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class BioForgeRecipeCategory
implements IRecipeCategory<BioForgeRecipe> {
    public static final RecipeType<BioForgeRecipe> RECIPE_TYPE = new RecipeType(ModRecipes.BIO_FORGING_RECIPE_TYPE.getId(), BioForgeRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public BioForgeRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModItems.BIO_FORGE.get()));
        ResourceLocation texture = BiomancyMod.createRL("textures/gui/jei/bio_forge_recipe.png");
        this.background = guiHelper.drawableBuilder(texture, 0, 0, 152, 32).setTextureSize(152, 32).build();
    }

    public RecipeType<BioForgeRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return ComponentUtil.translatable("jei.biomancy.recipe.bio_forge");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BioForgeRecipe recipe, IFocusGroup focuses) {
        ClientLevel level = Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        List<IngredientStack> ingredientQuantities = recipe.getIngredientQuantities();
        int y = 5;
        this.addInputSlot(builder, 1, y, ingredientQuantities, 0);
        this.addInputSlot(builder, 19, y, ingredientQuantities, 1);
        this.addInputSlot(builder, 37, y, ingredientQuantities, 2);
        this.addInputSlot(builder, 55, y, ingredientQuantities, 3);
        this.addInputSlot(builder, 73, y, ingredientQuantities, 4);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 131, y).addItemStack(recipe.m_8043_(level.m_9598_()));
    }

    private void addInputSlot(IRecipeLayoutBuilder builder, int x, int y, List<IngredientStack> ingredients, int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index must be larger or equal to zero");
        }
        if (index >= 5) {
            throw new IllegalArgumentException("index must be smaller than 5");
        }
        IRecipeSlotBuilder slotBuilder = builder.addSlot(RecipeIngredientRole.INPUT, x, y);
        if (index < ingredients.size()) {
            slotBuilder.addItemStacks(ingredients.get(index).getItemsWithCount());
        }
    }

    public void draw(BioForgeRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Font font = Minecraft.m_91087_().f_91062_;
        MutableComponent costString = ComponentUtil.literal("-" + recipe.getCraftingCostNutrients());
        Objects.requireNonNull(font);
        guiGraphics.m_280430_(font, (Component)costString, 108, 32 - 9 + 1, -1);
    }
}

