/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.integration.tetra;

import com.github.elenterius.biomancy.api.tribute.SimpleTribute;
import com.github.elenterius.biomancy.api.tribute.Tributes;
import com.github.elenterius.biomancy.integration.tetra.TetraHelper;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import se.mickelus.tetra.TetraRegistries;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.properties.IToolProvider;

public final class TetraCompat {
    private TetraCompat() {
    }

    public static void init(Consumer<TetraHelper> helperSetter) {
        helperSetter.accept(new TetraHelperImpl());
    }

    public static void onPostSetup() {
        TetraCompat.registerDragonSinewAsTribute();
    }

    private static void registerDragonSinewAsTribute() {
        ResourceLocation dragonSinewId = new ResourceLocation("tetra", "dragon_sinew");
        TetraRegistries.items.getEntries().stream().filter(registryObject -> registryObject.getId().equals((Object)dragonSinewId)).findAny().ifPresent(registryObject -> Tributes.register((Item)registryObject.get(), SimpleTribute.builder().biomass(20).lifeEnergy(25).successModifier(20).hostileModifier(20).anomalyModifier(30).build()));
    }

    static final class TetraHelperImpl
    implements TetraHelper {
        TetraHelperImpl() {
        }

        @Override
        public boolean isToolOrModularItem(Item item) {
            return item instanceof IModularItem || item instanceof IToolProvider;
        }
    }
}

