/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.inventory;

import com.github.elenterius.biomancy.inventory.Notify;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class BaseInventory<T extends IItemHandler & IItemHandlerModifiable>
implements Container,
INBTSerializable<CompoundTag> {
    protected T itemHandler;
    protected LazyOptional<IItemHandler> optionalItemHandler;
    protected Predicate<Player> canPlayerAccessInventory = x -> true;
    protected Notify markDirtyNotifier;
    protected Consumer<Player> onOpenInventory;
    protected Consumer<Player> onCloseInventory;

    BaseInventory() {
        this.markDirtyNotifier = () -> {};
        this.onOpenInventory = player -> {};
        this.onCloseInventory = player -> {};
    }

    BaseInventory(T itemHandler) {
        this.markDirtyNotifier = () -> {};
        this.onOpenInventory = player -> {};
        this.onCloseInventory = player -> {};
        this.itemHandler = itemHandler;
        this.optionalItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public T getItemHandler() {
        return this.itemHandler;
    }

    public LazyOptional<IItemHandler> getOptionalItemHandler() {
        return this.optionalItemHandler;
    }

    public void invalidate() {
        this.optionalItemHandler.invalidate();
    }

    public void revive() {
        this.optionalItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public CompoundTag serializeNBT() {
        return (CompoundTag)((INBTSerializable)this.itemHandler).serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        ((INBTSerializable)this.itemHandler).deserializeNBT((Tag)nbt);
    }

    public boolean m_6542_(Player player) {
        return this.canPlayerAccessInventory.test(player);
    }

    public void m_6596_() {
        this.markDirtyNotifier.invoke();
    }

    public void m_5856_(Player player) {
        this.onOpenInventory.accept(player);
    }

    public void m_5785_(Player player) {
        this.onCloseInventory.accept(player);
    }

    public void setCanPlayerAccessInventory(Predicate<Player> predicate) {
        this.canPlayerAccessInventory = predicate;
    }

    public void setMarkDirtyNotifier(Notify callback) {
        this.markDirtyNotifier = callback;
    }

    public void setOpenInventoryConsumer(Consumer<Player> consumer) {
        this.onOpenInventory = consumer;
    }

    public void setCloseInventoryConsumer(Consumer<Player> consumer) {
        this.onCloseInventory = consumer;
    }

    public int m_6643_() {
        return this.itemHandler.getSlots();
    }

    public int m_6893_() {
        return this.itemHandler.getSlotLimit(0);
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public boolean isFull() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (!stack.m_41619_() && stack.m_41613_() >= this.itemHandler.getSlotLimit(i)) continue;
            return false;
        }
        return true;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return this.itemHandler.isItemValid(index, stack);
    }

    public boolean doesItemStackFit(int index, ItemStack stack) {
        if (!this.itemHandler.isItemValid(index, stack)) {
            return false;
        }
        ItemStack remainder = this.itemHandler.insertItem(index, stack, true);
        return remainder.m_41619_();
    }

    public boolean doesItemStackFit(ItemStack stack) {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (!this.itemHandler.isItemValid(i, stack)) {
                return false;
            }
            if (!(stack = this.itemHandler.insertItem(i, stack, true)).m_41619_()) continue;
            return true;
        }
        return false;
    }

    public boolean doAllItemsFit(List<ItemStack> items) {
        SimulatedInventory inv = new SimulatedInventory();
        for (ItemStack stack : items) {
            if (stack.m_41619_()) continue;
            for (int i = 0; i < inv.slots; ++i) {
                stack = inv.insertAt(i, stack);
            }
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack insertItemStack(int index, ItemStack stack) {
        return this.insertItemStack(index, stack, false);
    }

    public ItemStack insertItemStack(int index, ItemStack stack, boolean simulate) {
        return this.itemHandler.insertItem(index, stack, simulate);
    }

    public ItemStack insertItemStack(ItemStack stack) {
        return this.insertItemStack(stack, false);
    }

    public ItemStack insertItemStack(ItemStack stack, boolean simulate) {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (!(stack = this.itemHandler.insertItem(i, stack, simulate)).m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return stack;
    }

    public ItemStack m_8020_(int index) {
        return this.itemHandler.getStackInSlot(index);
    }

    public ItemStack m_7407_(int index, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Invalid count: " + count);
        }
        return this.itemHandler.extractItem(index, count, false);
    }

    public ItemStack m_8016_(int index) {
        int maxStackSize = this.itemHandler.getSlotLimit(index);
        return this.itemHandler.extractItem(index, maxStackSize, false);
    }

    public void m_6836_(int index, ItemStack stack) {
        ((IItemHandlerModifiable)this.itemHandler).setStackInSlot(index, stack);
    }

    public void m_6211_() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ((IItemHandlerModifiable)this.itemHandler).setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    private class SimulatedInventory {
        int slots;
        int[] availableSlotSpace;
        ItemStack[] itemInSlot;

        public SimulatedInventory() {
            this.slots = BaseInventory.this.itemHandler.getSlots();
            this.availableSlotSpace = new int[this.slots];
            this.itemInSlot = new ItemStack[this.slots];
            for (int i = 0; i < this.slots; ++i) {
                ItemStack stack;
                this.itemInSlot[i] = stack = BaseInventory.this.itemHandler.getStackInSlot(i);
                this.availableSlotSpace[i] = BaseInventory.this.itemHandler.getSlotLimit(i) - stack.m_41613_();
            }
        }

        boolean canInsertAt(int index, ItemStack stack) {
            if (stack.m_41619_() || this.availableSlotSpace[index] <= 0) {
                return false;
            }
            if (!BaseInventory.this.itemHandler.isItemValid(index, stack)) {
                return false;
            }
            if (this.itemInSlot[index].m_41619_()) {
                return true;
            }
            return ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)this.itemInSlot[index]);
        }

        ItemStack insertAt(int index, ItemStack stack) {
            if (!this.canInsertAt(index, stack)) {
                return stack;
            }
            int insertAmount = Math.min(this.availableSlotSpace[index], stack.m_41613_());
            int n = index;
            this.availableSlotSpace[n] = this.availableSlotSpace[n] - insertAmount;
            if (this.itemInSlot[index].m_41619_()) {
                this.itemInSlot[index] = stack;
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - insertAmount));
        }
    }
}

