/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.inventory;

import com.github.elenterius.biomancy.inventory.BaseInventory;
import com.github.elenterius.biomancy.inventory.Notify;
import com.github.elenterius.biomancy.inventory.itemhandler.FixedSizeItemStackHandler;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class BehavioralInventory<T extends IItemHandler & IItemHandlerModifiable>
extends BaseInventory<T> {
    private final T behavioralItemHandler;

    BehavioralInventory(int slotAmount) {
        this.itemHandler = new FixedSizeItemStackHandler(slotAmount){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                BehavioralInventory.this.m_6596_();
            }
        };
        this.behavioralItemHandler = this.itemHandler;
        this.optionalItemHandler = LazyOptional.of(() -> this.behavioralItemHandler);
    }

    BehavioralInventory(int slotAmount, UnaryOperator<T> operator) {
        FixedSizeItemStackHandler handler = new FixedSizeItemStackHandler(slotAmount){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                BehavioralInventory.this.m_6596_();
            }
        };
        this.itemHandler = handler;
        this.behavioralItemHandler = (IItemHandler)operator.apply(handler);
        this.optionalItemHandler = LazyOptional.of(() -> this.behavioralItemHandler);
    }

    BehavioralInventory(int slotAmount, UnaryOperator<T> operator, Predicate<Player> canPlayerAccessInventory, Notify markDirtyNotifier) {
        this(slotAmount, operator);
        this.canPlayerAccessInventory = canPlayerAccessInventory;
        this.markDirtyNotifier = markDirtyNotifier;
    }

    BehavioralInventory(int slotAmount, Predicate<Player> canPlayerAccessInventory, Notify markDirtyNotifier) {
        this(slotAmount);
        this.canPlayerAccessInventory = canPlayerAccessInventory;
        this.markDirtyNotifier = markDirtyNotifier;
    }

    public static <T extends IItemHandler & IItemHandlerModifiable> BehavioralInventory<T> createServerContents(int slotAmount, UnaryOperator<T> operator, Predicate<Player> canPlayerAccessInventory, Notify markDirtyNotifier) {
        return new BehavioralInventory<T>(slotAmount, operator, canPlayerAccessInventory, markDirtyNotifier);
    }

    public static <T extends IItemHandler & IItemHandlerModifiable> BehavioralInventory<T> createServerContents(int slotAmount, Predicate<Player> canPlayerAccessInventory, Notify markDirtyNotifier) {
        return new BehavioralInventory<T>(slotAmount, canPlayerAccessInventory, markDirtyNotifier);
    }

    public static <T extends IItemHandler & IItemHandlerModifiable> BehavioralInventory<T> createClientContents(int slotAmount) {
        return new BehavioralInventory<T>(slotAmount);
    }

    public T getItemHandlerWithBehavior() {
        return this.behavioralItemHandler;
    }

    @Override
    public void revive() {
        this.optionalItemHandler = LazyOptional.of(() -> this.behavioralItemHandler);
    }
}

