/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.inventory;

import com.github.elenterius.biomancy.api.serum.SerumContainer;
import com.github.elenterius.biomancy.inventory.BaseInventory;
import com.github.elenterius.biomancy.inventory.itemhandler.LargeSingleItemStackHandler;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class InjectorItemInventory
extends BaseInventory<LargeSingleItemStackHandler> {
    private final ItemStack cachedInventoryHost;

    private InjectorItemInventory(short maxSlotSize, ItemStack inventoryHost) {
        this.itemHandler = new LargeSingleItemStackHandler(maxSlotSize){

            @Override
            public boolean isItemValid(ItemStack stack) {
                return stack.m_41720_() instanceof SerumContainer;
            }

            @Override
            protected void onContentsChanged() {
                InjectorItemInventory.this.m_6596_();
            }
        };
        this.optionalItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.cachedInventoryHost = inventoryHost;
    }

    private void serializeToHost() {
        this.cachedInventoryHost.m_41784_().m_128365_("inventory", (Tag)((LargeSingleItemStackHandler)this.itemHandler).serializeNBT());
    }

    private void deserializeFromHost() {
        this.deserializeNBT(this.cachedInventoryHost.m_41784_().m_128469_("inventory"));
    }

    @Override
    public void m_6596_() {
        this.serializeToHost();
        super.m_6596_();
    }

    @Override
    public boolean m_6542_(Player player) {
        if (this.cachedInventoryHost.m_41619_()) {
            return false;
        }
        return super.m_6542_(player);
    }

    @Override
    public int m_6893_() {
        return ((LargeSingleItemStackHandler)this.itemHandler).getMaxAmount();
    }

    @Override
    public boolean m_7983_() {
        return ((LargeSingleItemStackHandler)this.itemHandler).isEmpty();
    }

    @Override
    public boolean isFull() {
        return ((LargeSingleItemStackHandler)this.itemHandler).isFull();
    }

    @Override
    public boolean doesItemStackFit(ItemStack stack) {
        ItemStack remainder = ((LargeSingleItemStackHandler)this.itemHandler).insertItem(0, stack, true);
        return remainder.m_41619_();
    }

    @Override
    public ItemStack insertItemStack(ItemStack stack) {
        return ((LargeSingleItemStackHandler)this.itemHandler).insertItem(0, stack, false);
    }

    @Override
    public ItemStack m_8016_(int index) {
        return ((LargeSingleItemStackHandler)this.itemHandler).extractItem(index, ((LargeSingleItemStackHandler)this.itemHandler).getMaxAmount(), false);
    }

    @Override
    public void m_6211_() {
        ((LargeSingleItemStackHandler)this.itemHandler).setStackInSlot(0, ItemStack.f_41583_);
    }

    @Override
    public LargeSingleItemStackHandler getItemHandler() {
        this.deserializeFromHost();
        return (LargeSingleItemStackHandler)super.getItemHandler();
    }

    @Override
    public LazyOptional<IItemHandler> getOptionalItemHandler() {
        this.deserializeFromHost();
        return super.getOptionalItemHandler();
    }

    public static InjectorItemInventory createServerContents(short maxSlotSize, ItemStack inventoryHost) {
        InjectorItemInventory inventory = new InjectorItemInventory(maxSlotSize, inventoryHost);
        inventory.deserializeFromHost();
        return inventory;
    }

    public static InjectorItemInventory createClientContents(short maxSlotSize, ItemStack inventoryHost) {
        return new InjectorItemInventory(maxSlotSize, inventoryHost);
    }
}

