/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.inventory.itemhandler;

import com.github.elenterius.biomancy.inventory.itemhandler.Forwarding;
import java.util.function.Predicate;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

interface TransferOperations
extends Forwarding<IItemHandler> {
    default public ItemStack insertItem(ItemStack stack) {
        return this.insertItem(stack, false);
    }

    default public ItemStack insertItem(ItemStack stack, boolean simulate) {
        if (stack.m_41619_()) {
            return stack;
        }
        for (int i = 0; i < ((IItemHandler)this.inner()).getSlots(); ++i) {
            stack = ((IItemHandler)this.inner()).insertItem(i, stack, simulate);
            if (!stack.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return stack;
    }

    default public ItemStack insertItemOnExistingFirst(ItemStack stack) {
        return this.insertItemOnExistingFirst(stack, false);
    }

    default public ItemStack insertItemOnExistingFirst(ItemStack stack, boolean simulate) {
        if (stack.m_41619_()) {
            return stack;
        }
        for (int i = 0; i < ((IItemHandler)this.inner()).getSlots(); ++i) {
            if (((IItemHandler)this.inner()).getStackInSlot(i).m_41619_() || !(stack = ((IItemHandler)this.inner()).insertItem(i, stack, simulate)).m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return this.insertItem(stack, simulate);
    }

    default public ItemStack extractItemFirstFound() {
        return this.extractItemFirstFound(false);
    }

    default public ItemStack extractItemFirstFound(boolean simulate) {
        return this.extractItemFirstFound(Integer.MAX_VALUE, simulate);
    }

    default public ItemStack extractItemFirstFound(int maxAmount, boolean simulate) {
        for (int i = 0; i < ((IItemHandler)this.inner()).getSlots(); ++i) {
            ItemStack stackInSlot = ((IItemHandler)this.inner()).getStackInSlot(i);
            if (stackInSlot.m_41619_()) continue;
            int amount = Math.min(stackInSlot.m_41741_(), maxAmount);
            ItemStack stack = ((IItemHandler)this.inner()).extractItem(i, amount, simulate);
            if (stack.m_41619_()) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    default public ItemStack extractItemFirstMatch(Predicate<ItemStack> predicate) {
        return this.extractItemFirstMatch(predicate, false);
    }

    default public ItemStack extractItemFirstMatch(Predicate<ItemStack> predicate, boolean simulate) {
        return this.extractItemFirstMatch(predicate, Integer.MAX_VALUE, simulate);
    }

    default public ItemStack extractItemFirstMatch(Predicate<ItemStack> predicate, int maxAmount, boolean simulate) {
        for (int i = 0; i < ((IItemHandler)this.inner()).getSlots(); ++i) {
            int amount = Math.min(maxAmount, ((IItemHandler)this.inner()).getStackInSlot(i).m_41741_());
            ItemStack stack = ((IItemHandler)this.inner()).extractItem(i, amount, true);
            if (stack.m_41619_() || !predicate.test(stack)) continue;
            if (!simulate) {
                return ((IItemHandler)this.inner()).extractItem(i, amount, false);
            }
            return stack;
        }
        return ItemStack.f_41583_;
    }

    default public ItemStack extractItemAny(int targetAmount, boolean simulate) {
        ItemStack extracted = ItemStack.f_41583_;
        for (int i = 0; i < ((IItemHandler)this.inner()).getSlots(); ++i) {
            int amount;
            ItemStack stackInSlot = ((IItemHandler)this.inner()).getStackInSlot(i);
            if (stackInSlot.m_41619_()) continue;
            if (extracted.m_41619_()) {
                amount = Math.min(stackInSlot.m_41741_(), targetAmount);
                extracted = ((IItemHandler)this.inner()).extractItem(i, amount, simulate);
                if (!extracted.m_41619_()) {
                    targetAmount = Math.min(extracted.m_41741_(), targetAmount);
                }
                if (extracted.m_41613_() < targetAmount) continue;
                return extracted;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stackInSlot, (ItemStack)extracted)) continue;
            amount = Math.min(stackInSlot.m_41741_(), targetAmount - extracted.m_41613_());
            ItemStack result = ((IItemHandler)this.inner()).extractItem(i, amount, simulate);
            if (!result.m_41619_()) {
                extracted.m_41769_(result.m_41613_());
            }
            if (extracted.m_41613_() < targetAmount) continue;
            return extracted;
        }
        return extracted;
    }
}

