/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.item;

import com.github.elenterius.biomancy.block.chrysalis.Chrysalis;
import com.github.elenterius.biomancy.init.ModBlockEntities;
import com.github.elenterius.biomancy.item.SimpleBlockItem;
import com.github.elenterius.biomancy.styles.TextComponentUtil;
import com.github.elenterius.biomancy.styles.TextStyles;
import com.github.elenterius.biomancy.util.ComponentUtil;
import com.github.elenterius.biomancy.util.MobUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.Vec3;

public class ChrysalisBlockItem
extends SimpleBlockItem {
    public ChrysalisBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public void m_142023_(ItemEntity itemEntity) {
        if (itemEntity.m_9236_().f_46443_) {
            return;
        }
        CompoundTag compoundTag = BlockItem.m_186336_((ItemStack)itemEntity.m_32055_());
        if (compoundTag == null || !compoundTag.m_128441_("entity_info")) {
            return;
        }
        CompoundTag entityTag = compoundTag.m_128469_("entity_info");
        Chrysalis.spawnEntity((ServerLevel)itemEntity.m_9236_(), itemEntity.m_146892_(), entityTag);
    }

    public boolean isEmpty(ItemStack stack) {
        CompoundTag compoundTag = BlockItem.m_186336_((ItemStack)stack);
        return compoundTag == null || !compoundTag.m_128441_("entity_info");
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        boolean isValidTarget;
        if (player.m_9236_().m_5776_()) {
            return InteractionResult.PASS;
        }
        if (!this.isEmpty(stack)) {
            player.m_5661_((Component)TextComponentUtil.getFailureMsgText("already_full"), true);
            return InteractionResult.PASS;
        }
        boolean bl = isValidTarget = Chrysalis.isValidEntity((Entity)interactionTarget) && (!MobUtil.isBoss(interactionTarget) || player.m_7500_());
        if (!isValidTarget) {
            player.m_5661_((Component)TextComponentUtil.getFailureMsgText("mob_too_old"), true);
            return InteractionResult.PASS;
        }
        if (stack.m_41613_() > 1) {
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(1);
            CompoundTag compoundTag = new CompoundTag();
            if (Chrysalis.storeEntity(compoundTag, (Entity)interactionTarget, true)) {
                BlockItem.m_186338_((ItemStack)copy, (BlockEntityType)((BlockEntityType)ModBlockEntities.CHRYSALIS.get()), (CompoundTag)compoundTag);
                this.playInsertSound(player);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                if (!player.m_150109_().m_36054_(copy)) {
                    player.m_36176_(copy, true);
                }
                return InteractionResult.SUCCESS;
            }
            player.m_5661_((Component)TextComponentUtil.getFailureMsgText("failed_to_store_mob"), true);
            return InteractionResult.PASS;
        }
        CompoundTag compoundTag = new CompoundTag();
        if (Chrysalis.storeEntity(compoundTag, (Entity)interactionTarget, true)) {
            BlockItem.m_186338_((ItemStack)stack, (BlockEntityType)((BlockEntityType)ModBlockEntities.CHRYSALIS.get()), (CompoundTag)compoundTag);
            this.playInsertSound(player);
            if (player.m_7500_()) {
                player.m_21008_(usedHand, stack);
            }
            return InteractionResult.SUCCESS;
        }
        player.m_5661_((Component)TextComponentUtil.getFailureMsgText("failed_to_store_mob"), true);
        return InteractionResult.PASS;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null || !player.m_36341_()) {
            return InteractionResult.PASS;
        }
        CompoundTag compoundTag = BlockItem.m_186336_((ItemStack)stack);
        if (compoundTag == null || !compoundTag.m_128441_("entity_info")) {
            return InteractionResult.PASS;
        }
        Level level = context.m_43725_();
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (level.m_7966_(player, context.m_8083_()) && player.m_36204_(context.m_8083_(), context.m_43719_(), stack)) {
            CompoundTag entityTag = compoundTag.m_128469_("entity_info");
            if (this.spawnEntity((ServerLevel)level, context, entityTag)) {
                compoundTag.m_128473_("entity_info");
                BlockItem.m_186338_((ItemStack)stack, (BlockEntityType)((BlockEntityType)ModBlockEntities.CHRYSALIS.get()), (CompoundTag)compoundTag);
                this.playRemoveSound(player);
                return InteractionResult.CONSUME;
            }
            MutableComponent entityName = ComponentUtil.translatable(entityTag.m_128461_("name"));
            player.m_5661_((Component)TextComponentUtil.getFailureMsgText("failed_to_spawn_mob", entityName), true);
            return InteractionResult.FAIL;
        }
        player.m_5661_((Component)TextComponentUtil.getFailureMsgText("item_interaction_not_allowed"), true);
        return InteractionResult.FAIL;
    }

    private boolean spawnEntity(ServerLevel level, UseOnContext context, CompoundTag entityTag) {
        Entity entityToSpawn = EntityType.m_20645_((CompoundTag)entityTag.m_128469_("data"), (Level)level, entity -> {
            Vec3 pos = MobUtil.getAdjustedSpawnPositionFor(context.m_8083_(), context.m_43720_(), context.m_43719_(), entity);
            entity.m_7678_(pos.f_82479_, pos.f_82480_, pos.f_82481_, Mth.m_14177_((float)(level.f_46441_.m_188501_() * 360.0f)), 0.0f);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.f_20885_ = living.m_146908_();
                living.f_20883_ = living.m_146908_();
            }
            entity.m_20334_(0.0, 0.0, 0.0);
            entity.f_19789_ = 0.0f;
            return entity;
        });
        if (entityToSpawn != null) {
            if (!MobUtil.isEntityIdUnique(level, entityToSpawn)) {
                MobUtil.randomizeUUID(entityToSpawn);
            }
            return level.m_7967_(entityToSpawn);
        }
        return false;
    }

    private void playRemoveSound(Player player) {
        this.playSound(player, SoundEvents.f_215694_);
    }

    private void playInsertSound(Player player) {
        this.playSound(player, SoundEvents.f_215692_);
    }

    private void playSound(Player player, SoundEvent soundEvent) {
        player.m_5496_(soundEvent, 0.9f, 0.3f + player.m_9236_().m_213780_().m_188501_() * 0.25f);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        CompoundTag compoundTag = BlockItem.m_186336_((ItemStack)stack);
        if (compoundTag == null || !compoundTag.m_128441_("entity_info")) {
            return;
        }
        CompoundTag tag = compoundTag.m_128469_("entity_info");
        MutableComponent entityName = ComponentUtil.translatable(tag.m_128461_("name"));
        tooltip.add(ComponentUtil.emptyLine());
        tooltip.add((Component)TextComponentUtil.getTooltipText("contains", entityName).m_130948_(TextStyles.ITALIC_GRAY));
        float volume = tag.m_128457_("volume");
        tooltip.add((Component)ComponentUtil.literal(String.format("%.1f m\u00b3", Float.valueOf(volume))).m_130940_(ChatFormatting.DARK_GRAY));
    }

    public Component m_7626_(ItemStack stack) {
        Component itemName = super.m_7626_(stack);
        MutableComponent entityName = this.getEntityTypeName(stack);
        if (entityName == null) {
            return itemName;
        }
        return entityName.m_130946_(" ").m_7220_(itemName);
    }

    @Nullable
    private MutableComponent getEntityTypeName(ItemStack stack) {
        CompoundTag compoundTag = BlockItem.m_186336_((ItemStack)stack);
        if (compoundTag == null || !compoundTag.m_128441_("entity_info")) {
            return null;
        }
        CompoundTag tag = compoundTag.m_128469_("entity_info");
        return ComponentUtil.translatable(tag.m_128461_("name"));
    }
}

