/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.item;

import com.github.elenterius.biomancy.block.property.BlockPropertyUtil;
import com.github.elenterius.biomancy.item.SimpleItem;
import com.github.elenterius.biomancy.util.PillarPlantUtil;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.ChorusFlowerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.IPlantable;

public class FertilizerItem
extends SimpleItem {
    public FertilizerItem(Item.Properties properties) {
        super(properties);
    }

    public boolean m_5812_(ItemStack stack) {
        return true;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos clickedPos = context.m_8083_();
        ItemStack stack = context.m_43722_();
        if (FertilizerItem.applyFertilizer(stack, level, clickedPos)) {
            if (!level.f_46443_) {
                stack.m_41774_(1);
                level.m_46796_(1505, clickedPos, 0);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public static boolean applyFertilizer(ItemStack stack, Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof BonemealableBlock) {
            BonemealableBlock bonemealableBlock = (BonemealableBlock)block;
            return FertilizerItem.growBonmealableBlock(level, pos, state, bonemealableBlock);
        }
        if (block == Blocks.f_50493_) {
            return FertilizerItem.growDirtIntoGrassBlock(level, pos);
        }
        if (block instanceof ChorusFlowerBlock) {
            return FertilizerItem.growChorusFlower(level, pos, state);
        }
        if (PillarPlantUtil.isPillarPlant(block)) {
            return PillarPlantUtil.applyMegaGrowthBoost(level, pos, state, block);
        }
        if (block instanceof IPlantable) {
            return FertilizerItem.growPlantableBlock(level, pos, state, block);
        }
        return false;
    }

    private static boolean growChorusFlower(Level level, BlockPos pos, BlockState state) {
        boolean isAttachedToChorusPlant;
        if ((Integer)state.m_61143_((Property)ChorusFlowerBlock.f_51647_) >= 5) {
            return false;
        }
        BlockState stateBelow = level.m_8055_(pos.m_7495_());
        if (stateBelow.m_60713_(Blocks.f_50259_)) {
            if (!level.m_5776_()) {
                ChorusFlowerBlock.m_220962_((LevelAccessor)level, (BlockPos)pos, (RandomSource)level.f_46441_, (int)8);
            }
            return true;
        }
        boolean bl = isAttachedToChorusPlant = stateBelow.m_60713_(Blocks.f_50490_) || level.m_8055_(pos.m_122012_()).m_60713_(Blocks.f_50490_) || level.m_8055_(pos.m_122019_()).m_60713_(Blocks.f_50490_) || level.m_8055_(pos.m_122024_()).m_60713_(Blocks.f_50490_) || level.m_8055_(pos.m_122029_()).m_60713_(Blocks.f_50490_);
        if (isAttachedToChorusPlant) {
            if (!level.m_5776_()) {
                ChorusFlowerBlock.m_220962_((LevelAccessor)level, (BlockPos)pos, (RandomSource)level.f_46441_, (int)8);
            }
            return true;
        }
        return false;
    }

    private static boolean growDirtIntoGrassBlock(Level level, BlockPos pos) {
        BlockState stateAbove = level.m_8055_(pos.m_7494_());
        if (!stateAbove.m_60795_()) {
            return false;
        }
        if (!level.m_5776_()) {
            level.m_46597_(pos, Blocks.f_50440_.m_49966_());
            level.m_46796_(2005, pos, 5);
        }
        return true;
    }

    private static boolean growPlantableBlock(Level level, BlockPos pos, BlockState state, Block block) {
        Optional<IntegerProperty> property = BlockPropertyUtil.getAgeProperty(state);
        if (property.isPresent()) {
            int maxAge;
            IntegerProperty ageProperty = property.get();
            int age = (Integer)state.m_61143_((Property)ageProperty);
            if (age < (maxAge = BlockPropertyUtil.getMaxAge(ageProperty))) {
                if (!level.m_5776_()) {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)ageProperty, (Comparable)Integer.valueOf(maxAge)), 2);
                    level.m_46796_(2005, pos, 5);
                }
                return true;
            }
        } else if (block.m_6724_(state) && !level.m_183326_().m_183588_(pos, (Object)block)) {
            if (!level.m_5776_()) {
                level.m_186460_(pos, block, 2);
                level.m_46796_(2005, pos, 5);
            }
            return true;
        }
        return false;
    }

    private static boolean growBonmealableBlock(Level level, BlockPos pos, BlockState state, BonemealableBlock block) {
        if (!block.m_7370_((LevelReader)level, pos, state, level.f_46443_)) {
            return false;
        }
        Optional<IntegerProperty> property = BlockPropertyUtil.getAgeProperty(state);
        if (property.isPresent()) {
            int maxAge;
            IntegerProperty ageProperty = property.get();
            int age = (Integer)state.m_61143_((Property)ageProperty);
            if (age < (maxAge = BlockPropertyUtil.getMaxAge(ageProperty))) {
                if (!level.m_5776_()) {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)ageProperty, (Comparable)Integer.valueOf(maxAge)), 2);
                    level.m_46796_(2005, pos, 5);
                }
                return true;
            }
        } else {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                block.m_214148_(serverLevel, level.f_46441_, pos, state);
            }
            return true;
        }
        return false;
    }
}

