/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.item;

import com.github.elenterius.biomancy.block.FleshChainBlock;
import com.github.elenterius.biomancy.item.BlockPlaceContextWrapper;
import com.github.elenterius.biomancy.item.SimpleBlockItem;
import com.github.elenterius.biomancy.util.ComponentUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FleshChainBlockItem
extends SimpleBlockItem {
    public FleshChainBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public static Direction getDirection(UseOnContext context, BlockPos pos, BlockState state) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)FleshChainBlock.f_55923_);
        if (axis.m_122478_()) {
            return FleshChainBlockItem.getYDirection(pos, context.m_43720_());
        }
        if (axis == Direction.Axis.X) {
            return FleshChainBlockItem.getXDirection(pos, context.m_43720_());
        }
        if (axis == Direction.Axis.Z) {
            return FleshChainBlockItem.getZDirection(pos, context.m_43720_());
        }
        return Direction.UP;
    }

    private static Direction getZDirection(BlockPos pos, Vec3 click) {
        return click.f_82481_ - (double)pos.m_123343_() > 0.5 ? Direction.SOUTH : Direction.NORTH;
    }

    private static Direction getXDirection(BlockPos pos, Vec3 click) {
        return click.f_82479_ - (double)pos.m_123341_() > 0.5 ? Direction.EAST : Direction.WEST;
    }

    private static Direction getYDirection(BlockPos pos, Vec3 click) {
        return click.f_82480_ - (double)pos.m_123342_() > 0.5 ? Direction.UP : Direction.DOWN;
    }

    protected static BlockPos getClickedPos(UseOnContext context) {
        if (context instanceof BlockPlaceContextWrapper) {
            BlockPlaceContextWrapper contextWrapper = (BlockPlaceContextWrapper)context;
            context = contextWrapper.getOriginalUseContext();
        }
        return context.m_8083_();
    }

    public InteractionResult m_6225_(UseOnContext context) {
        InteractionResult placeResult = this.m_40576_(new BlockPlaceContextWrapper(context));
        if (!placeResult.m_19077_() && this.m_41472_() && context.m_43723_() != null) {
            InteractionResult result = this.m_7203_(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_();
            return result == InteractionResult.CONSUME ? InteractionResult.CONSUME_PARTIAL : result;
        }
        return placeResult;
    }

    @Nullable
    public BlockPlaceContext m_7732_(BlockPlaceContext context) {
        Block block;
        BlockPos pos;
        Level level = context.m_43725_();
        BlockState state = level.m_8055_(pos = FleshChainBlockItem.getClickedPos((UseOnContext)context));
        if (!state.m_60713_(block = this.m_40614_())) {
            return context;
        }
        if (context.m_7078_()) {
            return context;
        }
        Direction direction = FleshChainBlockItem.getDirection((UseOnContext)context, pos, state);
        BlockPos.MutableBlockPos mutablePos = pos.m_122032_().m_122173_(direction);
        for (int blocks = 0; blocks < 7; ++blocks) {
            if (!level.f_46443_ && !level.m_46739_((BlockPos)mutablePos)) {
                Player player = context.m_43723_();
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    int maxBuildHeight = level.m_151558_();
                    if (mutablePos.m_123342_() >= maxBuildHeight) {
                        serverPlayer.m_240418_((Component)ComponentUtil.translatable("build.tooHigh", maxBuildHeight - 1).m_130940_(ChatFormatting.RED), true);
                    }
                }
                return null;
            }
            state = level.m_8055_((BlockPos)mutablePos);
            if (!state.m_60713_(block)) {
                return state.m_60629_(context) ? BlockPlaceContext.m_43644_((BlockPlaceContext)context, (BlockPos)mutablePos, (Direction)direction) : null;
            }
            mutablePos.m_122173_(direction);
        }
        return null;
    }

    protected boolean m_6652_() {
        return false;
    }
}

