/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.item;

import com.github.elenterius.biomancy.client.util.ClientTextUtil;
import com.github.elenterius.biomancy.init.ModCapabilities;
import com.github.elenterius.biomancy.inventory.ItemStackInventory;
import com.github.elenterius.biomancy.inventory.itemhandler.EnhancedItemHandler;
import com.github.elenterius.biomancy.item.ItemTooltipStyleProvider;
import com.github.elenterius.biomancy.tooltip.StorageSacTooltipComponent;
import com.github.elenterius.biomancy.util.ComponentUtil;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class StorageSacBlockItem
extends BlockItem
implements ItemTooltipStyleProvider {
    public StorageSacBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public static Optional<EnhancedItemHandler> getItemHandler(ItemStack stack) {
        return stack.getCapability(ModCapabilities.ITEM_HANDLER).map(EnhancedItemHandler::new);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new InventoryCapability(stack);
    }

    public boolean m_142095_() {
        return false;
    }

    public boolean m_142207_(ItemStack stack, Slot slot, ClickAction action, Player player) {
        if (stack.m_41613_() > 1) {
            return false;
        }
        if (action != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack otherStack = slot.m_7993_();
        if (otherStack.m_41619_()) {
            Optional<EnhancedItemHandler> itemHandler = StorageSacBlockItem.getItemHandler(stack);
            ItemStack stackFromInv = itemHandler.map(h -> h.extractItemFirstFound(slot.m_6641_(), false)).orElse(ItemStack.f_41583_);
            int insertAmount = stackFromInv.m_41613_();
            ItemStack remainder = slot.m_150659_(stackFromInv);
            if (remainder.m_41613_() < insertAmount) {
                this.playRemoveFromSacSound(player);
            }
            itemHandler.ifPresent(h -> h.insertItemOnExistingFirst(remainder));
        } else if (otherStack.m_41720_().m_142095_() && !(otherStack.m_41720_() instanceof BundleItem)) {
            int prevCount = otherStack.m_41613_();
            ItemStack remainder = StorageSacBlockItem.getItemHandler(stack).map(h -> h.insertItemOnExistingFirst(slot.m_150647_(prevCount, Integer.MAX_VALUE, player))).orElse(ItemStack.f_41583_);
            slot.m_150659_(remainder);
            if (prevCount - remainder.m_41613_() > 0) {
                this.playInsertIntoSacSound(player);
            }
        }
        return true;
    }

    public boolean m_142305_(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (stack.m_41613_() > 1) {
            return false;
        }
        if (action != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return false;
        }
        if (otherStack.m_41619_()) {
            ItemStack stackFromInv = StorageSacBlockItem.getItemHandler(stack).map(rec$ -> ((EnhancedItemHandler)rec$).extractItemFirstFound()).orElse(ItemStack.f_41583_);
            if (!stackFromInv.m_41619_()) {
                this.playRemoveFromSacSound(player);
                access.m_142104_(stackFromInv);
            }
        } else if (otherStack.m_41720_().m_142095_() && !(otherStack.m_41720_() instanceof BundleItem)) {
            ItemStack remainder = StorageSacBlockItem.getItemHandler(stack).map(h -> h.insertItemOnExistingFirst(otherStack)).orElse(ItemStack.f_41583_);
            int insertedAmount = otherStack.m_41613_() - remainder.m_41613_();
            if (insertedAmount > 0) {
                this.playInsertIntoSacSound(player);
                otherStack.m_41774_(insertedAmount);
            }
        }
        return true;
    }

    public void m_142023_(ItemEntity itemEntity) {
        super.m_142023_(itemEntity);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.addAll(ClientTextUtil.getItemInfoTooltip(stack));
        tooltip.add((Component)ComponentUtil.tooltip(new StorageSacTooltipComponent(StorageSacBlockItem.getItemHandler(stack).orElse(null))));
        super.m_7373_(stack, level, tooltip, flag);
    }

    private void playRemoveFromSacSound(Player player) {
        this.playSound(player, SoundEvents.f_184216_);
    }

    private void playInsertIntoSacSound(Player player) {
        this.playSound(player, SoundEvents.f_184215_);
    }

    private void playSound(Player player, SoundEvent soundEvent) {
        player.m_5496_(soundEvent, 0.8f, 0.8f + player.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private static class InventoryCapability
    implements ICapabilityProvider {
        public static final ItemStackInventory.InventorySerializer SERIALIZER = ItemStackInventory.InventorySerializer.BLOCK_ENTITY_TAG;
        private final ItemStackInventory itemHandler;

        public InventoryCapability(ItemStack stack) {
            this.itemHandler = ItemStackInventory.createServerContents(15, 64, stack, SERIALIZER);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
            return ModCapabilities.ITEM_HANDLER.orEmpty(capability, this.itemHandler.getOptionalItemHandler());
        }
    }
}

