/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.item;

import com.github.elenterius.biomancy.init.ModItems;
import com.github.elenterius.biomancy.item.SimpleItem;
import java.util.Collection;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class VolatileGlandItem
extends SimpleItem {
    public VolatileGlandItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        return player.m_21224_() ? InteractionResultHolder.m_19100_((Object)player.m_21120_(usedHand)) : super.m_7203_(level, player, usedHand);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity livingEntity) {
        ItemStack result = livingEntity.m_5584_(level, stack);
        this.explode(level, livingEntity);
        return result;
    }

    private void explode(Level level, LivingEntity livingEntity) {
        if (level.f_46443_) {
            return;
        }
        float explosionRadius = 3.0f - livingEntity.m_21207_() * 1.5f;
        DamageSource damageSource = level.m_269111_().m_269036_((Entity)livingEntity, (Entity)livingEntity);
        level.m_254877_(null, damageSource, null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), explosionRadius, false, Level.ExplosionInteraction.MOB);
        if (!livingEntity.m_21224_()) {
            livingEntity.m_6469_(damageSource, 0.5f + livingEntity.m_21207_() * 2.5f);
        }
        if (livingEntity.m_21224_()) {
            this.spawnFleshBits(level, livingEntity.m_20185_(), livingEntity.m_20227_(0.5), livingEntity.m_20189_());
            this.spawnEffectCloud(level, livingEntity);
        }
    }

    private void spawnFleshBits(Level level, double x, double y, double z) {
        float force = 0.095f;
        int n = level.f_46441_.m_216339_(1, 7);
        for (int i = 0; i < n; ++i) {
            ItemEntity itemEntity = new ItemEntity(level, x, y, z, new ItemStack((ItemLike)ModItems.FLESH_BITS.get()));
            itemEntity.m_32060_();
            double dX = level.f_46441_.m_188583_() * (double)force;
            double dY = level.f_46441_.m_188583_() * (double)force;
            double dZ = level.f_46441_.m_188583_() * (double)force;
            itemEntity.m_20334_(dX, dY, dZ);
            level.m_7967_((Entity)itemEntity);
        }
    }

    private void spawnEffectCloud(Level level, LivingEntity livingEntity) {
        Collection activeEffects = livingEntity.m_21220_();
        if (activeEffects.isEmpty()) {
            return;
        }
        AreaEffectCloud effectCloud = new AreaEffectCloud(level, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
        effectCloud.m_19712_(2.5f);
        effectCloud.m_19732_(-0.5f);
        effectCloud.m_19740_(10);
        effectCloud.m_19734_(effectCloud.m_19748_() / 2);
        effectCloud.m_19738_(-effectCloud.m_19743_() / (float)effectCloud.m_19748_());
        for (MobEffectInstance mobeffectinstance : activeEffects) {
            effectCloud.m_19716_(new MobEffectInstance(mobeffectinstance));
        }
        level.m_7967_((Entity)effectCloud);
    }
}

