/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.item.armor;

import com.github.elenterius.biomancy.item.armor.AcolyteArmorItem;
import com.github.elenterius.biomancy.styles.TextStyles;
import com.github.elenterius.biomancy.util.ComponentUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public final class AdaptiveDamageResistanceHandler {
    private static final float[] HEALTH_GATES = new float[]{0.25f, 0.45f, 0.65f, 0.8f};
    private static final float[] ADAPTATION_EFFECTIVENESS = new float[]{0.9f, 0.8f, 0.75f, 0.7f};
    private static final float ADDITIONAL_RESISTANCE = 0.4f;
    private static final float[] DAMAGE_GATE_PERCENTAGES = new float[]{0.25f, 0.2f, 0.2f, 0.15f};
    private static final Set<String> VALID_NAMESPACES = Set.of("minecraft", "forge", "c");
    private static final String TAG_PREFIX = "is_";

    public static float absorbDamage(LivingEntity livingEntity, DamageSource damageSource, float damage, AcolyteArmorItem armor, ItemStack stack) {
        Object damageType2;
        List<TagKey> rootDamageTypes = damageSource.m_269150_().getTagKeys().filter(tagKey -> VALID_NAMESPACES.contains(tagKey.f_203868_().m_135827_()) && tagKey.f_203868_().m_135815_().startsWith(TAG_PREFIX)).toList();
        if (rootDamageTypes.isEmpty()) {
            return damage;
        }
        DamageTypeResistanceTracker resistanceTracker = armor.getDamageTypeResistanceTracker(stack);
        for (Object damageType2 : rootDamageTypes) {
            resistanceTracker.count((TagKey<DamageType>)damageType2);
        }
        float healthPct = 1.0f - (float)armor.getDamage(stack) / (float)armor.getMaxDamage(stack);
        damageType2 = HEALTH_GATES;
        int n = ((TagKey)damageType2).length;
        for (int i = 0; i < n; ++i) {
            double healthGate = (double)damageType2[i];
            if (!((double)healthPct <= healthGate)) continue;
            AdaptiveDamageResistanceHandler.adaptToDamageType(resistanceTracker);
            break;
        }
        float reducedDamage = AdaptiveDamageResistanceHandler.reduceDamage(livingEntity, damageSource, damage, resistanceTracker);
        armor.saveDamageTypeResistanceTracker(resistanceTracker, stack);
        return reducedDamage;
    }

    private static float reduceDamage(LivingEntity livingEntity, DamageSource damageSource, float damage, DamageTypeResistanceTracker resistanceTracker) {
        Map<TagKey<DamageType>, Float> resistances = resistanceTracker.resistances;
        for (Map.Entry<TagKey<DamageType>, Float> resistance : resistances.entrySet()) {
            if (!damageSource.m_269533_(resistance.getKey())) continue;
            damage *= 1.0f - resistance.getValue().floatValue();
        }
        if (resistanceTracker.hasResistanceForLargestDamageTypeCount()) {
            damage *= 0.6f;
        }
        for (Object damageGatePct : (Object)DAMAGE_GATE_PERCENTAGES) {
            float damageGate = livingEntity.m_21233_() * damageGatePct;
            if (!(livingEntity.m_21223_() - damage <= damageGate)) continue;
            damage = Math.max(damage - (damageGate - livingEntity.m_21223_()), 0.0f);
            break;
        }
        return Math.max(damage, 0.0f);
    }

    private static void adaptToDamageType(DamageTypeResistanceTracker damageTypeTracker) {
        int maxCount = 0;
        TagKey<DamageType> adaptedType = null;
        for (Map.Entry<TagKey<DamageType>, Integer> entry : damageTypeTracker.counter.entrySet()) {
            Integer value = entry.getValue();
            TagKey<DamageType> key = entry.getKey();
            if (value <= maxCount || damageTypeTracker.resistances.containsKey(key)) continue;
            maxCount = value;
            adaptedType = key;
        }
        if (adaptedType != null) {
            Map<TagKey<DamageType>, Float> resistances = damageTypeTracker.resistances;
            int i = Math.min(resistances.size(), ADAPTATION_EFFECTIVENESS.length - 1);
            resistances.put(adaptedType, Float.valueOf(ADAPTATION_EFFECTIVENESS[i]));
        }
    }

    public record DamageTypeResistanceTracker(Map<TagKey<DamageType>, Integer> counter, Map<TagKey<DamageType>, Float> resistances) {
        static DamageTypeResistanceTracker fromNBT(CompoundTag compoundTag) {
            HashMap<TagKey<DamageType>, Integer> counter = new HashMap<TagKey<DamageType>, Integer>();
            HashMap<TagKey<DamageType>, Float> resistances = new HashMap<TagKey<DamageType>, Float>();
            ListTag list = compoundTag.m_128437_("list", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag tag = list.m_128728_(i);
                ResourceLocation key = new ResourceLocation(tag.m_128461_("damage_type_tag"));
                TagKey damageType = TagKey.m_203882_((ResourceKey)Registries.f_268580_, (ResourceLocation)key);
                if (tag.m_128441_("count")) {
                    counter.put((TagKey<DamageType>)damageType, tag.m_128451_("count"));
                }
                if (!tag.m_128441_("resistance")) continue;
                resistances.put((TagKey<DamageType>)damageType, Float.valueOf(tag.m_128457_("resistance")));
            }
            return new DamageTypeResistanceTracker(counter, resistances);
        }

        static void appendTooltipText(CompoundTag compoundTag, List<Component> tooltip) {
            if (!compoundTag.m_128441_("list")) {
                return;
            }
            tooltip.add(ComponentUtil.emptyLine());
            tooltip.add((Component)ComponentUtil.mutable().m_130948_(TextStyles.GRAY).m_7220_((Component)ComponentUtil.literal("Adaptations:")));
            ListTag list = compoundTag.m_128437_("list", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag tag = list.m_128728_(i);
                tooltip.add((Component)ComponentUtil.mutable().m_130948_(TextStyles.GRAY).m_7220_((Component)ComponentUtil.literal(tag.m_128461_("damage_type_tag"))));
                if (tag.m_128441_("count")) {
                    tooltip.add((Component)ComponentUtil.mutable().m_130948_(TextStyles.GRAY).m_7220_(ComponentUtil.space()).m_7220_((Component)ComponentUtil.literal("Count: " + tag.m_128451_("count"))));
                }
                if (!tag.m_128441_("resistance")) continue;
                tooltip.add((Component)ComponentUtil.mutable().m_130948_(TextStyles.GRAY).m_7220_(ComponentUtil.space()).m_7220_((Component)ComponentUtil.literal("Resistance: " + tag.m_128457_("resistance"))));
            }
        }

        public void count(TagKey<DamageType> damageType) {
            this.counter.merge(damageType, 1, Integer::sum);
        }

        public boolean hasResistanceForLargestDamageTypeCount() {
            return this.counter.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).filter(this.resistances::containsKey).isPresent();
        }

        public CompoundTag toNBT() {
            HashSet<TagKey<DamageType>> damageTypes = new HashSet<TagKey<DamageType>>();
            damageTypes.addAll(this.counter.keySet());
            damageTypes.addAll(this.resistances.keySet());
            ListTag list = new ListTag();
            for (TagKey tagKey : damageTypes) {
                CompoundTag tag = new CompoundTag();
                tag.m_128359_("damage_type_tag", tagKey.f_203868_().toString());
                if (this.counter.containsKey(tagKey)) {
                    tag.m_128405_("count", this.counter.get(tagKey).intValue());
                }
                if (this.resistances.containsKey(tagKey)) {
                    tag.m_128350_("resistance", this.resistances.get(tagKey).floatValue());
                }
                list.add((Object)tag);
            }
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128365_("list", (Tag)list);
            return compoundTag;
        }
    }
}

