/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.item.weapon;

import com.github.elenterius.biomancy.api.livingtool.LivingToolState;
import com.github.elenterius.biomancy.api.livingtool.SpecialLivingTool;
import com.github.elenterius.biomancy.client.util.ClientTextUtil;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import com.github.elenterius.biomancy.item.KeyPressListener;
import com.github.elenterius.biomancy.item.weapon.SimpleClawsItem;
import com.github.elenterius.biomancy.styles.TextComponentUtil;
import com.github.elenterius.biomancy.util.ComponentUtil;
import com.github.elenterius.biomancy.util.MobUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;

public class LivingClawsItem
extends SimpleClawsItem
implements SpecialLivingTool,
KeyPressListener {
    private final int maxNutrients;

    public LivingClawsItem(Tier tier, float baseAttackDamage, float attackSpeedModifier, float attackRangeModifier, int maxNutrients, Item.Properties properties) {
        super(tier, baseAttackDamage, attackSpeedModifier, attackRangeModifier, properties);
        this.maxNutrients = maxNutrients;
    }

    @Override
    public InteractionResultHolder<Byte> onClientKeyPress(ItemStack stack, Level level, Player player, EquipmentSlot slot, byte flags) {
        if (!this.hasNutrients(stack)) {
            player.m_5661_((Component)TextComponentUtil.getFailureMsgText("not_enough_nutrients"), true);
            player.m_5496_((SoundEvent)ModSoundEvents.FLESHKIN_NO.get(), 1.0f, 1.0f + player.m_9236_().m_213780_().m_188501_() * 0.4f);
            return InteractionResultHolder.m_19100_((Object)flags);
        }
        return InteractionResultHolder.m_19090_((Object)flags);
    }

    @Override
    public void onServerReceiveKeyPress(ItemStack stack, ServerLevel level, Player player, byte flags) {
        this.updateLivingToolState(stack, level, player);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!MobUtil.isCreativePlayer(attacker)) {
            this.consumeNutrients(stack, this.getLivingToolActionCost(stack, ToolActions.SWORD_SWEEP));
        }
        return true;
    }

    @Override
    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entity) {
        if (!level.m_5776_() && state.m_60800_((BlockGetter)level, pos) != 0.0f && !MobUtil.isCreativePlayer(entity)) {
            this.consumeNutrients(stack, this.getLivingToolActionCost(stack, ToolActions.SWORD_DIG));
        }
        return true;
    }

    @Override
    public float m_8102_(ItemStack stack, BlockState state) {
        LivingToolState toolState = this.getLivingToolState(stack);
        return toolState == LivingToolState.BROKEN ? 1.0f : super.m_8102_(stack, state);
    }

    @Override
    public int getMaxNutrients(ItemStack container) {
        return this.maxNutrients;
    }

    public boolean m_142207_(ItemStack livingTool, Slot slot, ClickAction action, Player player) {
        if (this.handleOverrideStackedOnOther(livingTool, slot, action, player)) {
            this.playSound(player, (SoundEvent)ModSoundEvents.FLESHKIN_EAT.get());
            return true;
        }
        return false;
    }

    public boolean m_142305_(ItemStack livingTool, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (this.handleOverrideOtherStackedOnMe(livingTool, other, slot, action, player, access)) {
            this.playSound(player, (SoundEvent)ModSoundEvents.FLESHKIN_EAT.get());
            return true;
        }
        return false;
    }

    protected void playSound(Player player, SoundEvent soundEvent) {
        player.m_5496_(soundEvent, 0.8f, 0.8f + player.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    @Override
    public int getLivingToolActionCost(ItemStack livingTool, LivingToolState state, ToolAction toolAction) {
        int baseCost = 0;
        if (toolAction == ToolActions.SWORD_DIG) {
            baseCost = 2;
        }
        if (toolAction == ToolActions.SWORD_SWEEP) {
            baseCost = 1;
        }
        return switch (state) {
            case LivingToolState.AWAKENED -> baseCost + 4;
            case LivingToolState.DORMANT -> baseCost + 1;
            default -> baseCost;
        };
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return this.isValidEnchantment(stack, enchantment) && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean m_8120_(ItemStack stack) {
        return this.getMaxStackSize(stack) == 1;
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public boolean m_41465_() {
        return false;
    }

    public boolean m_5812_(ItemStack stack) {
        return false;
    }

    public boolean m_142522_(ItemStack stack) {
        return this.getNutrients(stack) < this.getMaxNutrients(stack);
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(this.getNutrientsPct(stack) * 13.0f);
    }

    public int m_142159_(ItemStack stack) {
        return 9742422;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltip, isAdvanced);
        tooltip.add(ComponentUtil.emptyLine());
        this.appendLivingToolTooltip(stack, tooltip);
        tooltip.add(ComponentUtil.emptyLine());
        tooltip.add((Component)ClientTextUtil.pressButtonTo(ClientTextUtil.getDefaultKey(), TextComponentUtil.getTooltipText("action.switch_mode")));
        if (stack.m_41793_()) {
            tooltip.add(ComponentUtil.emptyLine());
        }
    }

    public Component getHighlightTip(ItemStack stack, Component displayName) {
        return ComponentUtil.mutable().m_7220_(displayName).m_130946_(" (").m_7220_((Component)this.getLivingToolState(stack).getDisplayName()).m_130946_(")");
    }
}

