/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.menu;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.api.nutrients.Nutrients;
import com.github.elenterius.biomancy.block.biolab.BioLabBlockEntity;
import com.github.elenterius.biomancy.block.biolab.BioLabStateData;
import com.github.elenterius.biomancy.crafting.recipe.SimpleRecipeType;
import com.github.elenterius.biomancy.init.ModMenuTypes;
import com.github.elenterius.biomancy.inventory.BehavioralInventory;
import com.github.elenterius.biomancy.inventory.SimpleInventory;
import com.github.elenterius.biomancy.menu.PlayerContainerMenu;
import com.github.elenterius.biomancy.menu.slot.FuelSlot;
import com.github.elenterius.biomancy.menu.slot.ISlotZone;
import com.github.elenterius.biomancy.menu.slot.OutputSlot;
import com.github.elenterius.biomancy.util.fuel.FuelHandler;
import java.util.function.Predicate;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.MarkerManager;

public class BioLabMenu
extends PlayerContainerMenu {
    protected final Level level;
    private final Predicate<Player> isMenuValidPredicate;
    private final BioLabStateData stateData;

    protected BioLabMenu(int id, Inventory playerInventory, BehavioralInventory<?> fuelInventory, SimpleInventory inputInventory, BehavioralInventory<?> outputInventory, BioLabStateData stateData) {
        super((MenuType)ModMenuTypes.BIO_LAB.get(), id, playerInventory, 137, 195);
        this.level = playerInventory.f_35978_.m_9236_();
        this.isMenuValidPredicate = inputInventory::m_6542_;
        this.stateData = stateData;
        this.m_38897_(new FuelSlot(fuelInventory, 0, 31, 88));
        this.m_38897_(new Slot((Container)inputInventory, 0, 50, 28));
        this.m_38897_(new Slot((Container)inputInventory, 1, 70, 28));
        this.m_38897_(new Slot((Container)inputInventory, 2, 90, 28));
        this.m_38897_(new Slot((Container)inputInventory, 3, 110, 28));
        this.m_38897_(new Slot((Container)inputInventory, 4, 80, 62));
        this.m_38897_(new OutputSlot(outputInventory, 0, 80, 88));
        this.m_38884_(stateData);
    }

    public static BioLabMenu createServerMenu(int screenId, Inventory playerInventory, BehavioralInventory<?> fuelInventory, SimpleInventory inputInventory, BehavioralInventory<?> outputInventory, BioLabStateData stateData) {
        return new BioLabMenu(screenId, playerInventory, fuelInventory, inputInventory, outputInventory, stateData);
    }

    public static BioLabMenu createClientMenu(int screenId, Inventory playerInventory, FriendlyByteBuf extraData) {
        BehavioralInventory fuelInventory = BehavioralInventory.createClientContents(1);
        SimpleInventory inputInventory = SimpleInventory.createClientContents(5);
        BehavioralInventory outputInventory = BehavioralInventory.createClientContents(1);
        FuelHandler fuelHandler = FuelHandler.createNutrientFuelHandler(1000, () -> {});
        BioLabStateData state = new BioLabStateData(fuelHandler);
        return new BioLabMenu(screenId, playerInventory, fuelInventory, inputInventory, outputInventory, state);
    }

    public boolean m_6875_(Player player) {
        return this.isMenuValidPredicate.test(player);
    }

    public float getCraftingProgressNormalized() {
        if (this.stateData.timeForCompletion == 0) {
            return 0.0f;
        }
        return Mth.m_14036_((float)((float)this.stateData.timeElapsed / (float)this.stateData.timeForCompletion), (float)0.0f, (float)1.0f);
    }

    public int getFuelCost() {
        return this.stateData.getFuelCost();
    }

    public float getFuelAmountNormalized() {
        return Mth.m_14036_((float)((float)this.stateData.fuelHandler.getFuelAmount() / (float)this.stateData.fuelHandler.getMaxFuelAmount()), (float)0.0f, (float)1.0f);
    }

    public int getFuelAmount() {
        return this.stateData.fuelHandler.getFuelAmount();
    }

    public int getMaxFuelAmount() {
        return this.stateData.fuelHandler.getMaxFuelAmount();
    }

    public ItemStack m_7648_(Player player, int index) {
        boolean successfulTransfer;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stackInSlot = slot.m_7993_();
        ItemStack copyOfStack = stackInSlot.m_41777_();
        SlotZone slotZone = SlotZone.getZoneFromIndex(index);
        switch (slotZone) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case OUTPUT_ZONE: {
                boolean bl = this.mergeIntoEither(SlotZone.PLAYER_HOTBAR, SlotZone.PLAYER_MAIN_INVENTORY, stackInSlot, true);
                break;
            }
            case INPUT_ZONE: 
            case FUEL_ZONE: {
                boolean bl = this.mergeIntoEither(SlotZone.PLAYER_MAIN_INVENTORY, SlotZone.PLAYER_HOTBAR, stackInSlot, false);
                break;
            }
            case PLAYER_HOTBAR: 
            case PLAYER_MAIN_INVENTORY: {
                boolean bl = successfulTransfer = this.mergeIntoInputZone(stackInSlot) || this.mergeIntoFuelZone(stackInSlot) || this.mergeIntoPlayerZone(slotZone, stackInSlot);
            }
        }
        if (!successfulTransfer) {
            return ItemStack.f_41583_;
        }
        if (slotZone == SlotZone.OUTPUT_ZONE) {
            slot.m_40234_(stackInSlot, copyOfStack);
        }
        if (stackInSlot.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (stackInSlot.m_41613_() == copyOfStack.m_41613_()) {
            BiomancyMod.LOGGER.warn(MarkerManager.getMarker((String)"DecomposerMenu"), "Stack transfer failed in an unexpected way!");
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, stackInSlot);
        return copyOfStack;
    }

    private boolean mergeIntoInputZone(ItemStack stackInSlot) {
        if (((SimpleRecipeType.ItemStackRecipeType)BioLabBlockEntity.RECIPE_TYPE.get()).getRecipeForIngredient(this.level, stackInSlot).isPresent()) {
            return this.mergeInto(SlotZone.INPUT_ZONE, stackInSlot, false);
        }
        return false;
    }

    private boolean mergeIntoFuelZone(ItemStack stackInSlot) {
        if (Nutrients.isValidFuel(stackInSlot)) {
            return this.mergeInto(SlotZone.FUEL_ZONE, stackInSlot, true);
        }
        return false;
    }

    private boolean mergeIntoPlayerZone(SlotZone slotZone, ItemStack stackInSlot) {
        if (slotZone == SlotZone.PLAYER_HOTBAR) {
            return this.mergeInto(SlotZone.PLAYER_MAIN_INVENTORY, stackInSlot, false);
        }
        return this.mergeInto(SlotZone.PLAYER_HOTBAR, stackInSlot, false);
    }

    public static enum SlotZone implements ISlotZone
    {
        PLAYER_HOTBAR(0, 9),
        PLAYER_MAIN_INVENTORY(PLAYER_HOTBAR, 27),
        FUEL_ZONE(PLAYER_MAIN_INVENTORY, 1),
        INPUT_ZONE(FUEL_ZONE, 5),
        OUTPUT_ZONE(INPUT_ZONE, 1);

        public final int firstIndex;
        public final int slotCount;
        public final int lastIndexPlus1;

        private SlotZone(SlotZone prevSlotZone, int numberOfSlots) {
            this(prevSlotZone.lastIndexPlus1, numberOfSlots);
        }

        private SlotZone(int firstIndex, int numberOfSlots) {
            this.firstIndex = firstIndex;
            this.slotCount = numberOfSlots;
            this.lastIndexPlus1 = firstIndex + numberOfSlots;
        }

        public static SlotZone getZoneFromIndex(int slotIndex) {
            for (SlotZone slotZone : SlotZone.values()) {
                if (slotIndex < slotZone.firstIndex || slotIndex >= slotZone.lastIndexPlus1) continue;
                return slotZone;
            }
            throw new IndexOutOfBoundsException("Unexpected slotIndex");
        }

        @Override
        public int getFirstIndex() {
            return this.firstIndex;
        }

        @Override
        public int getLastIndexPlusOne() {
            return this.lastIndexPlus1;
        }

        @Override
        public int getSlotCount() {
            return this.slotCount;
        }
    }
}

