/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.mixin;

import com.github.elenterius.biomancy.init.ModMobEffects;
import com.github.elenterius.biomancy.item.ShieldBlockingListener;
import com.github.elenterius.biomancy.statuseffect.StatusEffectHandler;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Shadow
    protected ItemStack f_20935_;

    @Shadow
    public abstract boolean m_21023_(MobEffect var1);

    @Shadow
    public abstract AttributeMap m_21204_();

    @Inject(method={"getAttributeValue(Lnet/minecraft/world/entity/ai/attributes/Attribute;)D"}, at={@At(value="HEAD")}, cancellable=true)
    protected void onGetAttributeValue(Attribute attribute, CallbackInfoReturnable<Double> cir) {
        if (attribute == Attributes.f_22281_ && !this.m_21204_().m_22171_(Attributes.f_22281_) && this.m_21023_((MobEffect)ModMobEffects.FRENZY.get())) {
            cir.setReturnValue((Object)1.0);
        }
    }

    @Inject(method={"isSensitiveToWater"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsSensitiveToWater(CallbackInfoReturnable<Boolean> cir) {
        if (this.m_21023_((MobEffect)ModMobEffects.CORROSIVE.get())) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"blockUsingShield"}, at={@At(value="HEAD")})
    private void onBlockUsingShield(LivingEntity attacker, CallbackInfo ci) {
        Item item = this.f_20935_.m_41720_();
        if (item instanceof ShieldBlockingListener) {
            ShieldBlockingListener listener = (ShieldBlockingListener)item;
            listener.onShieldBlocking(this.f_20935_, (LivingEntity)this, attacker);
        }
    }

    @Inject(method={"addEffect(Lnet/minecraft/world/effect/MobEffectInstance;Lnet/minecraft/world/entity/Entity;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onAddEffect(MobEffectInstance effectInstance, @Nullable Entity source, CallbackInfoReturnable<Boolean> cir) {
        if ((source instanceof AreaEffectCloud || source instanceof ThrownPotion || source instanceof Arrow) && !StatusEffectHandler.canApplySplashEffectIfAllowed(effectInstance.m_19544_(), this.biomancy$self())) {
            cir.setReturnValue((Object)false);
        }
    }

    @Unique
    private LivingEntity biomancy$self() {
        return (LivingEntity)this;
    }
}

