/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.styles;

import com.github.elenterius.biomancy.styles.TextStyles;
import com.github.elenterius.biomancy.util.ComponentUtil;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public final class TextComponentUtil {
    private TextComponentUtil() {
    }

    public static String getTranslationKey(String prefix, String suffix) {
        return prefix + ".biomancy." + suffix;
    }

    public static MutableComponent getTranslationText(String prefix, String suffix) {
        return ComponentUtil.translatable(TextComponentUtil.getTranslationKey(prefix, suffix));
    }

    public static String getItemTooltipKey(Item item) {
        return item.m_5524_() + ".tooltip";
    }

    public static String getItemTooltipKey(Block block) {
        return block.m_7705_() + ".tooltip";
    }

    public static MutableComponent getItemTooltip(Item item) {
        return ComponentUtil.translatable(TextComponentUtil.getItemTooltipKey(item));
    }

    public static MutableComponent getTooltipText(String tooltipKey) {
        return ComponentUtil.translatable(TextComponentUtil.getTranslationKey("tooltip", tooltipKey));
    }

    public static MutableComponent getTooltipText(String tooltipKey, Object ... formatArgs) {
        return ComponentUtil.translatable(TextComponentUtil.getTranslationKey("tooltip", tooltipKey), formatArgs);
    }

    public static MutableComponent getMsgText(String msgKey) {
        return ComponentUtil.translatable(TextComponentUtil.getTranslationKey("msg", msgKey));
    }

    public static MutableComponent getMsgText(String msgKey, Object ... formatArgs) {
        return ComponentUtil.translatable(TextComponentUtil.getTranslationKey("msg", msgKey), formatArgs);
    }

    public static MutableComponent getFailureMsgText(String msgKey) {
        return TextComponentUtil.getMsgText(msgKey).m_130948_(TextStyles.ERROR);
    }

    public static MutableComponent getFailureMsgText(String msgKey, Object ... formatArgs) {
        return TextComponentUtil.getMsgText(msgKey, formatArgs).m_130948_(TextStyles.ERROR);
    }

    public static MutableComponent getAbilityText(String key) {
        return ComponentUtil.translatable(TextComponentUtil.getTranslationKey("ability", key));
    }
}

